/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.model.filter;

import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.filter.ChannelNameSearchFilter;
import com.mirth.connect.model.filter.ChannelTagSearchFilter;
import com.mirth.connect.model.filter.SearchFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class SearchFilterParser {
    private static final String DEFAULT_FILTER_KEY = "name";
    private static final String NAME_FILTER_KEY = "channel";
    private static final String TAG_FILTER_KEY = "tag";

    public static List<SearchFilter> parse(String filter, Set<ChannelTag> channelTags) {
        ArrayList<SearchFilter> searchFilters = new ArrayList<SearchFilter>();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            HashMap<String, ArrayList<String>> filterMap = new HashMap<String, ArrayList<String>>();
            for (String filterEntry : filter.split(",")) {
                Object[] filterPair = filterEntry.split(":");
                if (!ArrayUtils.isNotEmpty((Object[])filterPair) || filterPair.length != 2) continue;
                String filterType = ((String)filterPair[0]).trim().replace("\"", "");
                String filterName = ((String)filterPair[1]).trim().replace("\"", "");
                ArrayList<String> list = (ArrayList<String>)filterMap.get(filterType);
                if (list == null) {
                    list = new ArrayList<String>();
                    filterMap.put(filterType, list);
                }
                list.add(filterName);
            }
            for (Map.Entry entry : filterMap.entrySet()) {
                String filterType = (String)entry.getKey();
                if (StringUtils.equalsIgnoreCase((CharSequence)filterType, (CharSequence)NAME_FILTER_KEY)) {
                    searchFilters.add(new ChannelNameSearchFilter((List)entry.getValue(), false));
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)filterType, (CharSequence)TAG_FILTER_KEY)) {
                    searchFilters.add(new ChannelTagSearchFilter(channelTags, (List)entry.getValue()));
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)filterType, (CharSequence)DEFAULT_FILTER_KEY)) continue;
                searchFilters.add(new ChannelNameSearchFilter((List)entry.getValue(), true));
            }
        }
        return searchFilters;
    }
}

