/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server;

public class Command
implements Comparable<Command> {
    private Operation operation;
    private Priority priority;
    private Object parameter;

    public Command(Operation operation) {
        this(operation, null, Priority.NORMAL);
    }

    public Command(Operation operation, Object parameter) {
        this(operation, parameter, Priority.NORMAL);
    }

    public Command(Operation operation, Priority priority) {
        this(operation, null, priority);
    }

    public Command(Operation operation, Object parameter, Priority priority) {
        this.operation = operation;
        this.parameter = parameter;
        this.priority = priority;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public Object getParameter() {
        return this.parameter;
    }

    public void setParameter(Object parameter) {
        this.parameter = parameter;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(Command compareCommand) {
        if (this.getPriority().getValue() < compareCommand.getPriority().getValue()) {
            return -1;
        }
        if (this.getPriority().getValue() > compareCommand.getPriority().getValue()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Command[");
        builder.append("operation=" + String.valueOf((Object)this.getOperation()) + ", ");
        builder.append("priority=" + String.valueOf((Object)this.getPriority()) + ", ");
        builder.append("parameter=" + String.valueOf(this.getParameter()));
        builder.append("]");
        return builder.toString();
    }

    public static enum Priority {
        NORMAL(0),
        HIGH(1);

        private final int value;

        private Priority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Operation {
        START_SERVER,
        SHUTDOWN_SERVER;

    }
}

