/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server;

import com.mirth.connect.client.core.ConnectServiceUtil;
import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.client.core.PropertiesConfigurationUtil;
import com.mirth.connect.donkey.server.Donkey;
import com.mirth.connect.donkey.server.DonkeyConnectionPools;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.model.LibraryProperties;
import com.mirth.connect.model.ResourceProperties;
import com.mirth.connect.model.ResourcePropertiesList;
import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.model.UpdateSettings;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.util.MigrationException;
import com.mirth.connect.server.Command;
import com.mirth.connect.server.CommandQueue;
import com.mirth.connect.server.MirthWebServer;
import com.mirth.connect.server.controllers.AlertController;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EngineController;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.controllers.MigrationController;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.controllers.UsageController;
import com.mirth.connect.server.controllers.UserController;
import com.mirth.connect.server.logging.JuliToLog4JService;
import com.mirth.connect.server.logging.LogOutputStream;
import com.mirth.connect.server.logging.MirthLog4jFilter;
import com.mirth.connect.server.util.NetworkUtil;
import com.mirth.connect.server.util.ResourceUtil;
import com.mirth.connect.server.util.SqlConfig;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.filter.Filterable;

public class Mirth
extends Thread {
    private Logger logger = LogManager.getLogger(this.getClass());
    private boolean running = false;
    private PropertiesConfiguration mirthProperties = PropertiesConfigurationUtil.create();
    private PropertiesConfiguration versionProperties = PropertiesConfigurationUtil.create();
    private MirthWebServer webServer;
    private CommandQueue commandQueue = CommandQueue.getInstance();
    private EngineController engineController = ControllerFactory.getFactory().createEngineController();
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private UserController userController = ControllerFactory.getFactory().createUserController();
    private ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();
    private MigrationController migrationController = ControllerFactory.getFactory().createMigrationController();
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private ScriptController scriptController = ControllerFactory.getFactory().createScriptController();
    private ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private AlertController alertController = ControllerFactory.getFactory().createAlertController();
    private UsageController usageController = ControllerFactory.getFactory().createUsageController();
    private static List<Thread> shutdownHooks = new ArrayList<Thread>();

    public static void main(String[] args) {
        Mirth mirth = new Mirth();
        mirth.run();
        System.exit(0);
    }

    public static OutputStream getNullOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
    }

    public static void addShutdownHook(Thread hook) {
        if (shutdownHooks.contains(hook)) {
            return;
        }
        shutdownHooks.add(hook);
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Main Server Thread");
        try {
            ThreadContext.put((String)"hostAddress", (String)NetworkUtil.getIpv4HostAddress());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initializeLogging();
        if (this.initResources()) {
            this.logger.debug("starting BridgeLink server...");
            if (System.getProperty("jdk.tls.ephemeralDHKeySize") == null) {
                int keySize = NumberUtils.toInt((String)this.mirthProperties.getString("https.ephemeraldhkeysize", "2048"), (int)2048);
                if (keySize < 1024) {
                    keySize = 1024;
                } else if (keySize > 2048) {
                    keySize = 2048;
                }
                System.setProperty("jdk.tls.ephemeralDHKeySize", String.valueOf(keySize));
            }
            boolean httpPort = !this.isUsingHttp() || this.testPort(this.mirthProperties.getString("http.host"), this.mirthProperties.getString("http.port"), "http.port");
            boolean httpsPort = this.testPort(this.mirthProperties.getString("https.host"), this.mirthProperties.getString("https.port"), "https.port");
            if (!httpPort || !httpsPort) {
                return;
            }
            this.running = true;
            CommandQueue.getInstance().clear();
            CommandQueue.getInstance().addCommand(new Command(Command.Operation.START_SERVER));
            Runtime.getRuntime().addShutdownHook(new ShutdownHook());
            while (this.running) {
                Command command = this.commandQueue.getCommand();
                if (command.getOperation().equals((Object)Command.Operation.START_SERVER)) {
                    this.startup();
                    continue;
                }
                if (!command.getOperation().equals((Object)Command.Operation.SHUTDOWN_SERVER)) continue;
                this.shutdown();
            }
        } else {
            this.logger.error("could not initialize resources");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initResources() {
        InputStream mirthPropertiesStream = null;
        try {
            mirthPropertiesStream = ResourceUtil.getResourceStream(this.getClass(), "mirth.properties");
            this.mirthProperties = PropertiesConfigurationUtil.create((InputStream)mirthPropertiesStream);
        }
        catch (Exception e) {
            try {
                this.logger.error("could not load mirth.properties", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(mirthPropertiesStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)mirthPropertiesStream);
        }
        IOUtils.closeQuietly((InputStream)mirthPropertiesStream);
        InputStream versionPropertiesStream = null;
        try {
            versionPropertiesStream = ResourceUtil.getResourceStream(this.getClass(), "version.properties");
            this.versionProperties = PropertiesConfigurationUtil.create((InputStream)versionPropertiesStream);
        }
        catch (Exception e) {
            try {
                this.logger.error("could not load version.properties", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(versionPropertiesStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)versionPropertiesStream);
        }
        IOUtils.closeQuietly((InputStream)versionPropertiesStream);
        return !this.mirthProperties.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() {
        try {
            ObjectXMLSerializer.getInstance().init(this.versionProperties.getString("mirth.version"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Donkey.getInstance().setSerializer((Serializer)ObjectXMLSerializer.getInstance());
        this.configurationController.initializeSecuritySettings();
        this.configurationController.initializeDatabaseSettings();
        this.configurationController.updatePropertiesConfiguration(this.mirthProperties);
        try {
            int maxRetry = this.configurationController.getDatabaseSettings().getDatabaseConnectionMaxRetry();
            int maxRetryTimeout = this.configurationController.getDatabaseSettings().getDatabaseConnectionMaxRetryWaitTimeInMs();
            while (true) {
                try {
                    DonkeyConnectionPools.getInstance().init(this.configurationController.getDatabaseSettings().getProperties());
                }
                catch (Exception e) {
                    if (--maxRetry >= 0) {
                        try {
                            this.logger.error("Error establishing connection to database, retrying startup in " + maxRetryTimeout + " milliseconds", (Throwable)e);
                            Thread.sleep(maxRetryTimeout);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw e;
                    if (maxRetry >= 0) continue;
                }
                break;
            }
            maxRetry = this.configurationController.getDatabaseSettings().getDatabaseConnectionMaxRetry();
            while (true) {
                try {
                    if (!SqlConfig.getInstance().getSqlSessionManager().isManagedSessionStarted()) {
                        SqlConfig.getInstance().getSqlSessionManager().startManagedSession();
                    }
                    SqlConfig.getInstance().getSqlSessionManager().getConnection();
                }
                catch (Exception e) {
                    if (--maxRetry >= 0) {
                        try {
                            this.logger.error("Error establishing connection to database, retrying startup in " + maxRetryTimeout + " milliseconds", (Throwable)e);
                            Thread.sleep(maxRetryTimeout);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw e;
                    if (maxRetry >= 0) continue;
                }
                break;
            }
            maxRetry = this.configurationController.getDatabaseSettings().getDatabaseConnectionMaxRetry();
            if (SqlConfig.getInstance().isSplitReadWrite()) {
                while (true) {
                    try {
                        if (!SqlConfig.getInstance().getReadOnlySqlSessionManager().isManagedSessionStarted()) {
                            SqlConfig.getInstance().getReadOnlySqlSessionManager().startManagedSession();
                        }
                        SqlConfig.getInstance().getReadOnlySqlSessionManager().getConnection();
                    }
                    catch (Exception e) {
                        if (--maxRetry >= 0) {
                            try {
                                this.logger.error("Error establishing connection to database, retrying startup in " + maxRetryTimeout + " milliseconds", (Throwable)e);
                                Thread.sleep(maxRetryTimeout);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        throw e;
                        if (maxRetry >= 0) continue;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error establishing connection to database, aborting startup. " + e.getCause().getMessage());
            System.exit(0);
        }
        finally {
            if (SqlConfig.getInstance().getSqlSessionManager().isManagedSessionStarted()) {
                SqlConfig.getInstance().getSqlSessionManager().close();
            }
            if (SqlConfig.getInstance().isSplitReadWrite() && SqlConfig.getInstance().getReadOnlySqlSessionManager().isManagedSessionStarted()) {
                SqlConfig.getInstance().getReadOnlySqlSessionManager().close();
            }
        }
        this.migrationController.checkStartupLockTable();
        try {
            this.extensionController.removePropertiesForUninstalledExtensions();
            try {
                this.migrationController.migrate();
            }
            catch (MigrationException e) {
                this.logger.error("Failed to migrate database schema", (Throwable)e);
                this.stopDatabase();
                this.running = false;
                this.migrationController.clearStartupLockTable();
                return;
            }
            System.setProperty("org.terracotta.quartz.skipUpdateCheck", "true");
            this.configurationController.migrateKeystore();
            this.extensionController.setDefaultExtensionStatus();
            this.extensionController.uninstallExtensions();
            this.migrationController.migrateExtensions();
            this.extensionController.initPlugins();
            this.migrationController.migrateSerializedData();
            this.userController.resetUserStatus();
        }
        finally {
            this.migrationController.clearStartupLockTable();
        }
        Logger velocityLogger = LogManager.getLogger((String)"org.apache.velocity");
        if (velocityLogger != null && velocityLogger.getLevel() == null && velocityLogger instanceof org.apache.logging.log4j.core.Logger) {
            ((org.apache.logging.log4j.core.Logger)velocityLogger).setLevel(Level.OFF);
        }
        this.eventController.dispatchEvent(new ServerEvent(this.configurationController.getServerId(), "Server startup"));
        this.startWebServer();
        this.configurationController.setStatus(2);
        this.startEngine();
        this.extensionController.startPlugins();
        this.contextFactoryController.initGlobalContextFactory();
        try {
            MirthContextFactory contextFactory;
            this.alertController.initAlerts();
            this.configurationController.setStatus(3);
            try {
                ArrayList<LibraryProperties> libraryResources = new ArrayList<LibraryProperties>();
                for (ResourceProperties resource : ObjectXMLSerializer.getInstance().deserialize(this.configurationController.getResources(), ResourcePropertiesList.class).getList()) {
                    if (!(resource instanceof LibraryProperties)) continue;
                    libraryResources.add((LibraryProperties)resource);
                }
                this.contextFactoryController.updateResources(libraryResources, true);
            }
            catch (LinkageError e) {
                this.logger.warn("Unable to initialize library resources.", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.warn("Unable to initialize library resources.", (Throwable)e);
            }
            try {
                contextFactory = this.contextFactoryController.getGlobalScriptContextFactory();
            }
            catch (LinkageError e) {
                this.logger.warn("Unable to initialize global script context factory.", (Throwable)e);
                contextFactory = this.contextFactoryController.getGlobalContextFactory();
            }
            catch (Exception e) {
                this.logger.warn("Unable to initialize global script context factory.", (Throwable)e);
                contextFactory = this.contextFactoryController.getGlobalContextFactory();
            }
            this.scriptController.compileGlobalScripts(contextFactory, false);
            this.engineController.startupDeploy(this.configurationController.isStartupDeploy());
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        this.configurationController.setStatus(0);
        this.eventController.dispatchEvent(new ServerEvent(this.configurationController.getServerId(), "Server startup complete"));
        this.printSplashScreen();
        Timer timer = new Timer();
        timer.schedule((TimerTask)new UsageSenderTask(), 0L, (long)ConnectServiceUtil.MILLIS_PER_DAY.intValue());
    }

    public void shutdown() {
        this.logger.info("shutting down mirth due to normal request");
        this.stopEngine();
        try {
            SqlConfig.getInstance().getSqlSessionManager().startManagedSession();
            SqlConfig.getInstance().getSqlSessionManager().getConnection();
            this.eventController.dispatchEvent(new ServerEvent(this.configurationController.getServerId(), "Server shutdown"));
        }
        catch (Exception e) {
            this.logger.debug("could not log shutdown even since database is unavailable", (Throwable)e);
        }
        finally {
            if (SqlConfig.getInstance().getSqlSessionManager().isManagedSessionStarted()) {
                SqlConfig.getInstance().getSqlSessionManager().close();
            }
        }
        this.stopWebServer();
        this.extensionController.stopPlugins();
        this.stopDatabase();
        this.running = false;
    }

    private void startEngine() {
        this.logger.debug("starting engine");
        try {
            this.engineController.startEngine();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    private void stopEngine() {
        this.logger.debug("stopping engine");
        try {
            this.engineController.stopEngine();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    private void startWebServer() {
        this.logger.debug("starting jetty web server");
        try {
            this.webServer = new MirthWebServer(this.mirthProperties);
            this.webServer.startup();
        }
        catch (Exception e) {
            this.logger.warn("Could not start web server.", (Throwable)e);
            try {
                if (this.webServer != null) {
                    this.webServer.stop();
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                this.webServer = null;
            }
        }
    }

    private void stopWebServer() {
        this.logger.debug("stopping jetty web server");
        try {
            if (this.webServer != null) {
                this.webServer.stop();
            }
        }
        catch (Exception e) {
            this.logger.warn("Could not stop web server.", (Throwable)e);
        }
    }

    private void stopDatabase() {
        String database = this.mirthProperties.getString("database");
        if (database.equals("derby")) {
            boolean gotException;
            block4: {
                gotException = false;
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getSQLState() == null || !sqle.getSQLState().equals("XJ015")) break block4;
                    gotException = true;
                }
            }
            if (gotException) {
                System.out.println("Database shut down normally.");
            }
        }
    }

    private void printSplashScreen() {
        this.logger.info("BridgeLink " + this.versionProperties.getString("mirth.version") + " (Built on " + this.versionProperties.getString("mirth.date") + ") server successfully started.");
        this.logger.info("This product was developed by Innovar Healthcare (https://www.innovarhealthcare.com) and its contributors (c)2025-now.");
        this.logger.info("Running " + System.getProperty("java.vm.name") + " " + System.getProperty("java.version") + " on " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + "), " + this.configurationController.getDatabaseType() + ", with charset " + String.valueOf(Charset.defaultCharset()) + ".");
        if (this.webServer != null) {
            String httpUrl = null;
            if (this.isUsingHttp()) {
                httpUrl = this.getWebServerUrl("http://", this.mirthProperties.getString("http.host", "0.0.0.0"), this.mirthProperties.getInt("http.port"), this.mirthProperties.getString("http.contextpath"));
            }
            String httpsUrl = this.getWebServerUrl("https://", this.mirthProperties.getString("https.host", "0.0.0.0"), this.mirthProperties.getInt("https.port"), this.mirthProperties.getString("http.contextpath"));
            this.logger.info("Web server running at " + (String)(httpUrl != null ? httpUrl + " and " : "") + httpsUrl);
        }
    }

    private boolean isUsingHttp() {
        return this.mirthProperties.containsKey("http.port") && this.mirthProperties.getInt("http.port") > 0;
    }

    private String getWebServerUrl(String prefix, String host, int port, String contextPath) {
        if (StringUtils.equals((CharSequence)host, (CharSequence)"0.0.0.0") || StringUtils.equals((CharSequence)host, (CharSequence)"::")) {
            try {
                host = NetworkUtil.getIpv4HostAddress();
            }
            catch (Exception e) {
                host = "localhost";
            }
        } else if (StringUtils.isEmpty((CharSequence)host)) {
            host = "localhost";
        }
        if (!StringUtils.startsWith((CharSequence)contextPath, (CharSequence)"/")) {
            contextPath = "/" + (String)contextPath;
        }
        if (!StringUtils.endsWith((CharSequence)contextPath, (CharSequence)"/")) {
            contextPath = (String)contextPath + "/";
        }
        return prefix + host + ":" + port + (String)contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testPort(String host, String port, String name) {
        ServerSocket socket = null;
        try {
            socket = StringUtils.equals((CharSequence)host, (CharSequence)"0.0.0.0") || StringUtils.equals((CharSequence)host, (CharSequence)"::") ? new ServerSocket(Integer.parseInt(port)) : new ServerSocket(Integer.parseInt(port), 0, InetAddress.getByName(host));
        }
        catch (NumberFormatException ex) {
            this.logger.error(name + " port is invalid: " + port);
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            this.logger.error(name + " port is already in use: " + port);
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    this.logger.error("Could not close test socket for " + name + ": " + port);
                    return false;
                }
            }
        }
        return true;
    }

    private void initializeLogging() {
        System.setErr(new PrintStream(new LogOutputStream()));
        JuliToLog4JService.getInstance().start();
        Logger rootLogger = LogManager.getRootLogger();
        if (rootLogger instanceof org.apache.logging.log4j.core.Logger) {
            for (Appender appender : ((org.apache.logging.log4j.core.Logger)rootLogger).getAppenders().values()) {
                if (!(appender instanceof Filterable)) continue;
                ((Filterable)appender).addFilter((Filter)new MirthLog4jFilter());
            }
        }
    }

    static {
        System.setProperty("log4j2.enableThreadlocals", "false");
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("Shutdown Hook Thread");
            Mirth.this.shutdown();
            for (Thread thread : shutdownHooks) {
                thread.start();
            }
        }
    }

    private class UsageSenderTask
    extends TimerTask {
        private UsageSenderTask() {
        }

        @Override
        public void run() {
            boolean isSent = ConnectServiceUtil.sendStatistics((String)Mirth.this.configurationController.getServerId(), (String)Mirth.this.configurationController.getServerVersion(), (boolean)true, (String)Mirth.this.usageController.createUsageStats(null), (String[])Mirth.this.configurationController.getHttpsClientProtocols(), (String[])Mirth.this.configurationController.getHttpsCipherSuites());
            if (isSent) {
                UpdateSettings settings = new UpdateSettings();
                settings.setLastStatsTime(System.currentTimeMillis());
                try {
                    Mirth.this.configurationController.setUpdateSettings(settings);
                }
                catch (ControllerException controllerException) {
                    // empty catch block
                }
            }
        }
    }
}

