/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server;

import com.google.common.base.Predicate;
import com.mirth.connect.client.core.Version;
import com.mirth.connect.client.core.api.BaseServletInterface;
import com.mirth.connect.client.core.api.Replaces;
import com.mirth.connect.model.ApiProvider;
import com.mirth.connect.model.MetaData;
import com.mirth.connect.server.MethodFilter;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.api.providers.ApiOriginFilter;
import com.mirth.connect.server.api.providers.ClickjackingFilter;
import com.mirth.connect.server.api.providers.RequestedWithFilter;
import com.mirth.connect.server.api.providers.StrictTransportSecurityFilter;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.servlets.SwaggerExamplesServlet;
import com.mirth.connect.server.servlets.SwaggerServlet;
import com.mirth.connect.server.servlets.WebStartServlet;
import com.mirth.connect.server.tools.ClassPathResource;
import com.mirth.connect.server.util.PackagePredicate;
import com.mirth.connect.server.util.SqlConfig;
import com.mirth.connect.util.MirthSSLUtil;
import io.swagger.v3.jaxrs2.integration.resources.AcceptHeaderOpenApiResource;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ext.Provider;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.session.DatabaseAdaptor;
import org.eclipse.jetty.server.session.DefaultSessionCacheFactory;
import org.eclipse.jetty.server.session.JDBCSessionDataStore;
import org.eclipse.jetty.server.session.JDBCSessionDataStoreFactory;
import org.eclipse.jetty.server.session.NullSessionCacheFactory;
import org.eclipse.jetty.server.session.NullSessionDataStore;
import org.eclipse.jetty.server.session.SessionCache;
import org.eclipse.jetty.server.session.SessionDataStoreFactory;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.wadl.internal.generators.WadlGeneratorJAXBGrammarGenerator;
import org.glassfish.jersey.servlet.ServletContainer;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class MirthWebServer
extends Server {
    private static final String CONNECTOR = "connector";
    private static final String CONNECTOR_SSL = "sslconnector";
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();
    private List<WebAppContext> webapps;
    private HandlerList handlers;
    private ServerConnector connector;
    private ServerConnector sslConnector;

    public MirthWebServer(PropertiesConfiguration mirthProperties) throws Exception {
        String sessionCacheProperty;
        boolean apiAllowHTTP;
        System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", "-1");
        Logger logger2 = LogManager.getLogger(WadlGeneratorJAXBGrammarGenerator.class);
        Configurator.setLevel((String)logger2.getName(), (Level)Level.OFF);
        String baseAPI = "/api";
        boolean usingHttp = mirthProperties.containsKey("http.port") && mirthProperties.getInt("http.port") > 0;
        boolean bl = apiAllowHTTP = usingHttp && Boolean.parseBoolean(mirthProperties.getString("server.api.allowhttp", "false"));
        if (usingHttp) {
            HttpConfiguration config = new HttpConfiguration();
            config.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
            config.setSendServerVersion(false);
            config.setSendXPoweredBy(false);
            this.connector = new ServerConnector((Server)this, new ConnectionFactory[]{new HttpConnectionFactory(config)});
            this.connector.setName(CONNECTOR);
            this.connector.setHost(mirthProperties.getString("http.host", "0.0.0.0"));
            this.connector.setPort(mirthProperties.getInt("http.port"));
        }
        this.sslConnector = this.createSSLConnector(CONNECTOR_SSL, mirthProperties);
        boolean sessionStore = Boolean.parseBoolean(mirthProperties.getString("server.api.sessionstore", "false"));
        if (sessionStore) {
            String sessionStoreTable = mirthProperties.getString("server.api.sessionstoretable", "sessiondata");
            this.addBean(this.createSessionDataStoreFactory(sessionStoreTable));
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)(sessionCacheProperty = mirthProperties.getString("server.api.sessioncache", "default")), (CharSequence)"none") && sessionStore) {
            this.addBean(new NullSessionCacheFactory());
        } else {
            DefaultSessionCacheFactory sessionCacheFactory = new DefaultSessionCacheFactory();
            sessionCacheFactory.setEvictionPolicy(this.configurationController.getMaxInactiveSessionInterval());
            this.addBean(sessionCacheFactory);
        }
        this.handlers = new HandlerList();
        Object contextPath = mirthProperties.getString("http.contextpath", "");
        if (!((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        if (((String)contextPath).endsWith("/")) {
            contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 1);
        }
        String clientLibPath = null;
        clientLibPath = ClassPathResource.getResourceURI("client-lib") != null ? Paths.get(ClassPathResource.getResourceURI("client-lib")).toString() + File.separator : ControllerFactory.getFactory().createConfigurationController().getBaseDir() + File.separator + "client-lib" + File.separator;
        ContextHandler libContextHandler = new ContextHandler();
        libContextHandler.setContextPath((String)contextPath + "/webstart/client-lib");
        libContextHandler.setResourceBase(clientLibPath);
        libContextHandler.setHandler((Handler)new ResourceHandler());
        this.handlers.addHandler((Handler)libContextHandler);
        ContextHandler extensionsContextHandler = new ContextHandler();
        extensionsContextHandler.setContextPath((String)contextPath + "/webstart/extensions/libs");
        String extensionsPath = new File(ExtensionController.getExtensionsPath()).getPath();
        extensionsContextHandler.setResourceBase(extensionsPath);
        extensionsContextHandler.setHandler((Handler)new ResourceHandler());
        this.handlers.addHandler((Handler)extensionsContextHandler);
        ContextHandler publicContextHandler = new ContextHandler();
        publicContextHandler.setContextPath((String)contextPath);
        String publicPath = ControllerFactory.getFactory().createConfigurationController().getBaseDir() + File.separator + "public_html";
        publicContextHandler.setResourceBase(publicPath);
        publicContextHandler.setHandler((Handler)new ResourceHandler());
        this.handlers.addHandler((Handler)publicContextHandler);
        this.addLauncherInstallerContextHandlers((String)contextPath);
        ContextHandler javadocsContextHandler = new ContextHandler();
        javadocsContextHandler.setContextPath((String)contextPath + "/javadocs");
        String javadocsPath = ControllerFactory.getFactory().createConfigurationController().getBaseDir() + File.separator + "docs" + File.separator + "javadocs";
        javadocsContextHandler.setResourceBase(javadocsPath);
        ResourceHandler javadocsResourceHandler = new ResourceHandler();
        javadocsResourceHandler.setDirectoriesListed(true);
        javadocsContextHandler.setHandler((Handler)javadocsResourceHandler);
        this.handlers.addHandler((Handler)javadocsContextHandler);
        this.webapps = new ArrayList<WebAppContext>();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".war");
            }
        };
        String webappsDir = null;
        webappsDir = ClassPathResource.getResourceURI("webapps") != null ? ClassPathResource.getResourceURI("webapps").getPath() + File.separator : ControllerFactory.getFactory().createConfigurationController().getBaseDir() + File.separator + "webapps" + File.separator;
        File[] listOfFiles = new File(webappsDir).listFiles(filter);
        if (listOfFiles != null) {
            Configuration.ClassList classlist = Configuration.ClassList.setServerDefault((Server)this);
            classlist.addBefore("org.eclipse.jetty.webapp.JettyWebXmlConfiguration", new String[]{"org.eclipse.jetty.annotations.AnnotationConfiguration"});
            for (File file : listOfFiles) {
                this.logger.debug("webApp File Path: " + file.getAbsolutePath());
                WebAppContext webapp = new WebAppContext();
                SessionHandler sessionHandler = new SessionHandler();
                DefaultSessionCacheFactory sessionCacheFactory = new DefaultSessionCacheFactory();
                sessionCacheFactory.setEvictionPolicy(this.configurationController.getMaxInactiveSessionInterval());
                SessionCache sessionCache = sessionCacheFactory.getSessionCache(sessionHandler);
                Object sessionDataStore = null;
                SessionDataStoreFactory sessionDataStoreFactory = (SessionDataStoreFactory)this.getBean(SessionDataStoreFactory.class);
                sessionDataStore = sessionDataStoreFactory != null ? sessionDataStoreFactory.getSessionDataStore(sessionHandler) : new NullSessionDataStore();
                sessionCache.setSessionDataStore(sessionDataStore);
                sessionHandler.setSessionCache(sessionCache);
                webapp.setSessionHandler(sessionHandler);
                webapp.setContextPath((String)contextPath + "/" + file.getName().substring(0, file.getName().length() - 4));
                webapp.addFilter(new FilterHolder((Filter)new ClickjackingFilter(mirthProperties)), "/*", EnumSet.of(DispatcherType.REQUEST));
                webapp.addFilter(new FilterHolder((Filter)new StrictTransportSecurityFilter(mirthProperties)), "/*", EnumSet.of(DispatcherType.REQUEST));
                webapp.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/[^/]*(javax\\.servlet-api|taglibs)[^/]*\\.jar$");
                this.logger.debug("webApp Context Path: " + webapp.getContextPath());
                webapp.setWar(file.getAbsolutePath());
                this.handlers.addHandler((Handler)webapp);
                this.webapps.add(webapp);
            }
        }
        ServletContextHandler apiServletContextHandler = this.createApiServletContextHandler((String)contextPath, baseAPI, apiAllowHTTP, Version.getLatest(), mirthProperties);
        this.addApiServlets(this.handlers, apiServletContextHandler, (String)contextPath, baseAPI, apiAllowHTTP, Version.getLatest(), mirthProperties);
        apiServletContextHandler = this.createApiServletContextHandler((String)contextPath, baseAPI, apiAllowHTTP, null, mirthProperties);
        this.addApiServlets(this.handlers, apiServletContextHandler, (String)contextPath, baseAPI, apiAllowHTTP, null, mirthProperties);
        this.addSwaggerServlets(this.handlers, apiServletContextHandler, (String)contextPath, baseAPI, apiAllowHTTP, null);
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        servletContextHandler.setContextPath((String)contextPath);
        servletContextHandler.addFilter(new FilterHolder((Filter)new MethodFilter()), "/*", EnumSet.of(DispatcherType.REQUEST));
        servletContextHandler.addServlet(new ServletHolder((Servlet)new WebStartServlet()), "/webstart.jnlp");
        servletContextHandler.addServlet(new ServletHolder((Servlet)new WebStartServlet()), "/webstart");
        servletContextHandler.addServlet(new ServletHolder((Servlet)new WebStartServlet()), "/webstart/extensions/*");
        this.handlers.addHandler((Handler)servletContextHandler);
        DefaultHandler defaultHandler = new DefaultHandler();
        defaultHandler.setServeIcon(false);
        this.handlers.addHandler((Handler)defaultHandler);
        this.setHandler((Handler)this.handlers);
        if (usingHttp) {
            this.setConnectors(new Connector[]{this.connector, this.sslConnector});
        } else {
            this.setConnectors(new Connector[]{this.sslConnector});
        }
    }

    public void startup() throws Exception {
        try {
            this.start();
        }
        catch (Throwable e) {
            this.logger.error("Could not load web app", e);
            try {
                this.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (WebAppContext webapp : this.webapps) {
                this.handlers.removeHandler((Handler)webapp);
            }
            this.start();
        }
        this.logger.debug("started jetty web server on ports: " + (String)(this.connector != null ? this.connector.getPort() + ", " : "") + this.sslConnector.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerConnector createSSLConnector(String name, PropertiesConfiguration mirthProperties) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(mirthProperties.getString("keystore.type", "JCEKS"));
        FileInputStream is = new FileInputStream(new File(mirthProperties.getString("keystore.path")));
        try {
            keyStore.load(is, mirthProperties.getString("keystore.storepass").toCharArray());
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        SslContextFactory.Server contextFactory = new SslContextFactory.Server();
        contextFactory.setKeyStore(keyStore);
        contextFactory.setCertAlias("mirthconnect");
        contextFactory.setKeyManagerPassword(mirthProperties.getString("keystore.keypass"));
        contextFactory.setEndpointIdentificationAlgorithm(null);
        HttpConfiguration config = new HttpConfiguration();
        config.setSecureScheme("https");
        config.setSecurePort(mirthProperties.getInt("https.port"));
        config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        config.setSendServerVersion(false);
        config.setSendXPoweredBy(false);
        ServerConnector sslConnector = new ServerConnector((Server)this, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)contextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(config)});
        sslConnector.setIdleTimeout(86400000L);
        LowResourceMonitor lowResourceMonitor = new LowResourceMonitor((Server)this);
        lowResourceMonitor.setMonitoredConnectors(Collections.singleton(sslConnector));
        lowResourceMonitor.setMaxConnections(200);
        lowResourceMonitor.setLowResourcesIdleTimeout(200000);
        sslConnector.setName(name);
        sslConnector.setHost(mirthProperties.getString("https.host", "0.0.0.0"));
        sslConnector.setPort(mirthProperties.getInt("https.port"));
        contextFactory.setExcludeProtocols(new String[0]);
        contextFactory.setExcludeCipherSuites(new String[0]);
        contextFactory.setIncludeProtocols(MirthSSLUtil.getEnabledHttpsProtocols(this.configurationController.getHttpsServerProtocols()));
        contextFactory.setIncludeCipherSuites(MirthSSLUtil.getEnabledHttpsCipherSuites(this.configurationController.getHttpsCipherSuites()));
        return sslConnector;
    }

    private ServletContextHandler createApiServletContextHandler(String contextPath, String baseAPI, boolean apiAllowHTTP, Version version, PropertiesConfiguration mirthProperties) {
        Object apiPath = "";
        Version apiVersion = version;
        if (apiVersion != null) {
            apiPath = (String)apiPath + "/" + apiVersion.toString();
        }
        ServletContextHandler apiServletContextHandler = new ServletContextHandler();
        apiServletContextHandler.setMaxFormContentSize(0);
        apiServletContextHandler.setSessionHandler(new SessionHandler());
        apiServletContextHandler.setContextPath(contextPath + baseAPI + (String)apiPath);
        apiServletContextHandler.addFilter(new FilterHolder((Filter)new ApiOriginFilter(mirthProperties)), "/*", EnumSet.of(DispatcherType.REQUEST));
        apiServletContextHandler.addFilter(new FilterHolder((Filter)new ClickjackingFilter(mirthProperties)), "/*", EnumSet.of(DispatcherType.REQUEST));
        apiServletContextHandler.addFilter(new FilterHolder((Filter)new RequestedWithFilter(mirthProperties)), "/*", EnumSet.of(DispatcherType.REQUEST));
        apiServletContextHandler.addFilter(new FilterHolder((Filter)new MethodFilter()), "/*", EnumSet.of(DispatcherType.REQUEST));
        apiServletContextHandler.addFilter(new FilterHolder((Filter)new StrictTransportSecurityFilter(mirthProperties)), "/*", EnumSet.of(DispatcherType.REQUEST));
        this.setConnectorNames((ContextHandler)apiServletContextHandler, apiAllowHTTP);
        return apiServletContextHandler;
    }

    private void addApiServlets(HandlerList handlers, ServletContextHandler apiServletContextHandler, String contextPath, String baseAPI, boolean apiAllowHTTP, Version version, PropertiesConfiguration mirthProperties) {
        Version apiVersion = version;
        if (apiVersion == null) {
            apiVersion = Version.getLatest();
        }
        ApiProviders apiProviders = this.getApiProviders(apiVersion);
        ServletHolder jerseyVersionedServlet = apiServletContextHandler.addServlet(ServletContainer.class, "/*");
        jerseyVersionedServlet.setInitOrder(1);
        jerseyVersionedServlet.setInitParameter("jersey.config.server.provider.packages", StringUtils.join(apiProviders.providerPackages, (char)','));
        jerseyVersionedServlet.setInitParameter("jersey.config.server.provider.classnames", this.joinClasses(apiProviders.providerClasses));
        handlers.addHandler((Handler)apiServletContextHandler);
    }

    private void addSwaggerServlets(HandlerList handlers, ServletContextHandler apiServletContextHandler, String contextPath, String baseAPI, boolean apiAllowHTTP, PropertiesConfiguration mirthProperties) {
        String apiPath = "";
        Version apiVersion = Version.getLatest();
        ApiProviders apiProviders = this.getApiProviders(apiVersion);
        ServletHolder swaggerVersionedServlet = new ServletHolder((Servlet)new SwaggerServlet(contextPath + baseAPI + apiPath, null, apiVersion, apiProviders.servletInterfacePackages, apiProviders.servletInterfaces, apiAllowHTTP));
        swaggerVersionedServlet.setInitOrder(2);
        apiServletContextHandler.addServlet(swaggerVersionedServlet, contextPath + baseAPI + apiPath + "/openapi.json");
        apiServletContextHandler.addServlet(swaggerVersionedServlet, contextPath + baseAPI + apiPath + "/openapi.yaml");
        handlers.addHandler((Handler)this.getSwaggerContextHandler(contextPath, baseAPI, apiAllowHTTP, null));
        ServletContextHandler swaggerExamplesServletContextHandler = new ServletContextHandler();
        swaggerExamplesServletContextHandler.setContextPath("/apiexamples");
        ServletHolder swaggerExamplesServlet = new ServletHolder((Servlet)new SwaggerExamplesServlet());
        swaggerExamplesServlet.setInitOrder(3);
        swaggerExamplesServletContextHandler.addServlet(swaggerExamplesServlet, "/*");
        handlers.addHandler((Handler)apiServletContextHandler);
        handlers.addHandler((Handler)swaggerExamplesServletContextHandler);
    }

    private ContextHandler getSwaggerContextHandler(String contextPath, String baseAPI, boolean apiAllowHTTP, Version version) {
        ContextHandler swaggerContextHandler = new ContextHandler();
        swaggerContextHandler.setContextPath(contextPath + baseAPI + (String)(version != null ? "/" + version.toString() : ""));
        swaggerContextHandler.setResourceBase(ControllerFactory.getFactory().createConfigurationController().getBaseDir() + File.separator + "public_api_html");
        swaggerContextHandler.setHandler((Handler)new ResourceHandler());
        this.setConnectorNames(swaggerContextHandler, apiAllowHTTP);
        return swaggerContextHandler;
    }

    private void setConnectorNames(ContextHandler contextHandler, boolean apiAllowHTTP) {
        ArrayList<String> connectorNames = new ArrayList<String>();
        connectorNames.add("@sslconnector");
        if (apiAllowHTTP) {
            connectorNames.add("@connector");
        }
        contextHandler.setVirtualHosts(connectorNames.toArray(new String[connectorNames.size()]));
    }

    private ApiProviders getApiProviders(Version version) {
        LinkedHashSet<String> servletInterfacePackages = new LinkedHashSet<String>();
        LinkedHashSet servletInterfaces = new LinkedHashSet();
        servletInterfaces.addAll(this.getApiClassesForVersion("com.mirth.connect.client.core.api.servlets", version, new Class[]{BaseServletInterface.class}, new Class[0]));
        LinkedHashSet<String> coreProviderPackages = new LinkedHashSet<String>();
        LinkedHashSet coreProviderClasses = new LinkedHashSet();
        coreProviderClasses.addAll(this.getApiClassesForVersion("com.mirth.connect.client.core.api.providers", version, new Class[0], new Class[]{Provider.class}));
        coreProviderClasses.add(MultiPartFeature.class);
        LinkedHashSet<String> serverProviderPackages = new LinkedHashSet<String>();
        serverProviderPackages.add("io.swagger.jaxrs.listing");
        LinkedHashSet serverProviderClasses = new LinkedHashSet();
        serverProviderClasses.addAll(this.getApiClassesForVersion("com.mirth.connect.server.api.providers", version, new Class[0], new Class[]{Provider.class}));
        serverProviderClasses.addAll(this.getApiClassesForVersion("com.mirth.connect.server.api.servlets", version, new Class[]{MirthServlet.class}, new Class[0]));
        for (MetaData metaData : CollectionUtils.union(this.extensionController.getPluginMetaData().values(), this.extensionController.getConnectorMetaData().values())) {
            if (!this.extensionController.isExtensionEnabled(metaData.getName())) continue;
            for (ApiProvider apiProvider : metaData.getApiProviders(version)) {
                try {
                    switch (apiProvider.getType()) {
                        case SERVLET_INTERFACE_PACKAGE: {
                            servletInterfacePackages.add(apiProvider.getName());
                            break;
                        }
                        case SERVLET_INTERFACE: {
                            servletInterfaces.add(Class.forName(apiProvider.getName()));
                            break;
                        }
                        case CORE_PACKAGE: {
                            coreProviderPackages.add(apiProvider.getName());
                            break;
                        }
                        case SERVER_PACKAGE: {
                            serverProviderPackages.add(apiProvider.getName());
                            break;
                        }
                        case CORE_CLASS: {
                            coreProviderClasses.add(Class.forName(apiProvider.getName()));
                            break;
                        }
                        case SERVER_CLASS: {
                            serverProviderClasses.add(Class.forName(apiProvider.getName()));
                        }
                    }
                }
                catch (Throwable t) {
                    this.logger.error("Error adding API provider to web server: " + String.valueOf(apiProvider));
                }
            }
        }
        LinkedHashSet<String> providerPackages = new LinkedHashSet<String>();
        LinkedHashSet providerClasses = new LinkedHashSet();
        providerPackages.addAll(coreProviderPackages);
        providerPackages.addAll(serverProviderPackages);
        providerClasses.addAll(coreProviderClasses);
        providerClasses.addAll(serverProviderClasses);
        providerClasses.add(OpenApiResource.class);
        providerClasses.add(AcceptHeaderOpenApiResource.class);
        return new ApiProviders(servletInterfacePackages, servletInterfaces, providerPackages, providerClasses);
    }

    private Set<Class<?>> getApiClassesForVersion(String packageName, Version version, Class<?>[] baseClasses, Class<?>[] annotations) {
        Version testVersion;
        if (version == Version.getLatest()) {
            return this.getClassesInPackage(packageName, baseClasses, annotations);
        }
        boolean useDefaultPackage = true;
        for (testVersion = version.getNextVersion(); testVersion != null; testVersion = testVersion.getNextVersion()) {
            if (!this.testPackageVersion(packageName, testVersion, baseClasses, annotations)) continue;
            useDefaultPackage = false;
            break;
        }
        if (useDefaultPackage) {
            return this.getClassesInPackage(packageName, baseClasses, annotations);
        }
        HashSet classes = new HashSet();
        for (testVersion = Version.getApiEarliest(); testVersion != null && testVersion.ordinal() <= version.ordinal(); testVersion = testVersion.getNextVersion()) {
            for (Class<?> clazz : this.getClassesInPackage(this.getVersionedPackageName(packageName, testVersion), baseClasses, annotations)) {
                Replaces replaces = clazz.getAnnotation(Replaces.class);
                if (replaces != null) {
                    classes.remove(replaces.value());
                }
                classes.add(clazz);
            }
        }
        return classes;
    }

    private Set<Class<?>> getClassesInPackage(String packageName, Class<?>[] baseClasses, Class<?>[] annotations) {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.setScanners(new Scanner[]{new ResourcesScanner(), new TypeAnnotationsScanner(), new SubTypesScanner(false)});
        config.addUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0]));
        config.setInputsFilter((Predicate)new PackagePredicate(packageName));
        Reflections reflections = new Reflections((Configuration)config);
        HashSet classes = new HashSet();
        if (ArrayUtils.isNotEmpty((Object[])baseClasses)) {
            for (Class<?> baseClass : baseClasses) {
                classes.addAll(reflections.getSubTypesOf(baseClass));
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])annotations)) {
            for (Class<?> annotation : annotations) {
                if (!annotation.isAnnotation()) continue;
                classes.addAll(reflections.getTypesAnnotatedWith(annotation));
            }
        }
        return classes;
    }

    private boolean testPackageVersion(String packageName, Version version, Class<?>[] baseClasses, Class<?>[] annotations) {
        packageName = this.getVersionedPackageName(packageName, version);
        try {
            Class.forName(packageName + ".package-info");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return CollectionUtils.isNotEmpty(this.getClassesInPackage(packageName, baseClasses, annotations));
        }
    }

    private String getVersionedPackageName(String packageName, Version version) {
        return packageName + "." + version.toPackageString();
    }

    private String joinClasses(Set<Class<?>> classes) {
        StringBuilder builder = new StringBuilder();
        if (CollectionUtils.isNotEmpty(classes)) {
            boolean added = false;
            for (Class<?> clazz : classes) {
                String name;
                if (clazz == null || (name = clazz.getCanonicalName()) == null) continue;
                if (added) {
                    builder.append(',');
                }
                builder.append(name);
                added = true;
            }
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionDataStoreFactory createSessionDataStoreFactory(String sessionStoreTable) throws SQLException {
        JDBCSessionDataStoreFactory jdbcSDSFactory = new JDBCSessionDataStoreFactory();
        JDBCSessionDataStore.SessionTableSchema schema = new JDBCSessionDataStore.SessionTableSchema();
        schema.setTableName(sessionStoreTable);
        jdbcSDSFactory.setSessionTableSchema(schema);
        DatabaseAdaptor dbAdapter = new DatabaseAdaptor(){

            public String getBlobType() {
                if (this._blobType == null && StringUtils.containsIgnoreCase((CharSequence)this.getDBName(), (CharSequence)"sql server")) {
                    this.setBlobType("image");
                }
                return super.getBlobType();
            }
        };
        SqlSessionManager sqlSessionManager = SqlConfig.getInstance().getSqlSessionManager();
        sqlSessionManager.startManagedSession();
        Connection connection = sqlSessionManager.getConnection();
        try {
            dbAdapter.adaptTo(connection.getMetaData());
            dbAdapter.setDatasource(sqlSessionManager.getConfiguration().getEnvironment().getDataSource());
        }
        finally {
            if (sqlSessionManager.isManagedSessionStarted()) {
                sqlSessionManager.close();
            }
        }
        jdbcSDSFactory.setDatabaseAdaptor(dbAdapter);
        return jdbcSDSFactory;
    }

    private void addLauncherInstallerContextHandlers(String contextPath) {
        File installersDirectory = new File(ControllerFactory.getFactory().createConfigurationController().getBaseDir() + File.separator + "public_html" + File.separator + "installers");
        Collection installerFiles = installersDirectory.exists() && installersDirectory.isDirectory() ? FileUtils.listFiles((File)installersDirectory, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)FalseFileFilter.FALSE) : new ArrayList();
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("dmg", "application/x-apple-diskimage");
        mimeTypes.addMimeMapping("sh", "text/x-sh");
        mimeTypes.addMimeMapping("exe", "application/octet-stream");
        this.addLauncherInstallerContextHandler(contextPath, "macos", "macos", ".dmg", installerFiles, mimeTypes);
        this.addLauncherInstallerContextHandler(contextPath, "linux", "unix", ".sh", installerFiles, mimeTypes);
        this.addLauncherInstallerContextHandler(contextPath, "windows", "windows", ".exe", installerFiles, mimeTypes);
        this.addLauncherInstallerContextHandler(contextPath, "windows-x64", "windows-x64", ".exe", installerFiles, mimeTypes);
    }

    private void addLauncherInstallerContextHandler(String contextPath, String os, String fileSuffix, String fileExt, Collection<File> installers, MimeTypes mimeTypes) {
        File installerFile = null;
        for (File file : installers) {
            if (!StringUtils.endsWithIgnoreCase((CharSequence)file.getName(), (CharSequence)(fileSuffix + fileExt))) continue;
            installerFile = file;
            break;
        }
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath(contextPath + "/launcher/" + os + fileExt);
        contextHandler.setAllowNullPathInfo(true);
        contextHandler.setHandler((Handler)new InstallerFileHandler(installerFile, mimeTypes));
        this.handlers.addHandler((Handler)contextHandler);
    }

    private class ApiProviders {
        public Set<String> servletInterfacePackages;
        public Set<Class<?>> servletInterfaces;
        public Set<String> providerPackages;
        public Set<Class<?>> providerClasses;

        public ApiProviders(Set<String> servletInterfacePackages, Set<Class<?>> servletInterfaces, Set<String> providerPackages, Set<Class<?>> providerClasses) {
            this.servletInterfacePackages = servletInterfacePackages;
            this.servletInterfaces = servletInterfaces;
            this.providerPackages = providerPackages;
            this.providerClasses = providerClasses;
        }
    }

    private class InstallerFileHandler
    extends AbstractHandler {
        private File file;
        private String contentType;

        public InstallerFileHandler(File file, MimeTypes mimeTypes) {
            this.file = file;
            if (file != null) {
                this.contentType = mimeTypes.getMimeByExtension(file.getName());
            }
            if (StringUtils.isBlank((CharSequence)this.contentType)) {
                this.contentType = ContentType.APPLICATION_OCTET_STREAM.getMimeType();
            }
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (!baseRequest.getMethod().equalsIgnoreCase(HttpMethod.GET.asString()) && !baseRequest.getMethod().equalsIgnoreCase(HttpMethod.HEAD.asString())) {
                return;
            }
            if (this.file != null && this.file.exists()) {
                response.setStatus(200);
                if (baseRequest.getMethod().equalsIgnoreCase(HttpMethod.GET.asString())) {
                    FileInputStream fis = null;
                    try {
                        response.setContentType(this.contentType);
                        response.addHeader("Content-Disposition", "attachment; filename=" + this.file.getName());
                        Object responseOutputStream = response.getOutputStream();
                        Enumeration en = request.getHeaders("Accept-Encoding");
                        while (en.hasMoreElements()) {
                            if (!StringUtils.contains((CharSequence)((CharSequence)en.nextElement()), (CharSequence)"gzip")) continue;
                            response.setHeader("Content-Encoding", "gzip");
                            responseOutputStream = new GZIPOutputStream((OutputStream)responseOutputStream);
                            break;
                        }
                        fis = new FileInputStream(this.file);
                        IOUtils.copy((InputStream)fis, (OutputStream)responseOutputStream);
                        if (responseOutputStream instanceof GZIPOutputStream) {
                            ((GZIPOutputStream)responseOutputStream).finish();
                        }
                    }
                    catch (Throwable t) {
                        IOUtils.closeQuietly(fis);
                        response.reset();
                        response.setStatus(500);
                    }
                }
            } else {
                response.setStatus(404);
            }
            baseRequest.setHandled(true);
        }
    }
}

