/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.alert;

import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.server.event.EventType;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.alert.AlertActionGroup;
import com.mirth.connect.model.alert.AlertChannels;
import com.mirth.connect.model.alert.DefaultTrigger;
import com.mirth.connect.server.alert.Alert;
import com.mirth.connect.server.alert.AlertWorker;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.util.ErrorMessageBuilder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultAlertWorker
extends AlertWorker {
    private ChannelController channelController = ControllerFactory.getFactory().createChannelController();

    @Override
    public Set<EventType> getEventTypes() {
        HashSet<EventType> eventTypes = new HashSet<EventType>();
        eventTypes.add(EventType.ERROR);
        return eventTypes;
    }

    @Override
    protected void onShutdown() {
    }

    @Override
    protected void alertEnabled(Alert alert) {
    }

    @Override
    protected void alertDisabled(Alert alert) {
    }

    @Override
    public Class<?> getTriggerClass() {
        return DefaultTrigger.class;
    }

    @Override
    protected void triggerAction(Alert alert, Map<String, Object> context) {
        if (!this.acceptAlertAction(alert, context)) {
            return;
        }
        for (AlertActionGroup actionGroup : alert.getModel().getActionGroups()) {
            if (!CollectionUtils.isNotEmpty(actionGroup.getActions())) continue;
            this.actionExecutor.submit(new AlertWorker.ActionTask(alert.getModel().getId(), actionGroup, context));
            alert.incrementAlertedCount();
        }
    }

    @Override
    protected void processEvent(Event event) {
        if (event instanceof ErrorEvent) {
            ErrorEvent errorEvent = (ErrorEvent)event;
            String channelId = errorEvent.getChannelId();
            Integer metaDataId = errorEvent.getMetaDataId();
            for (Alert alert : this.enabledAlerts.values()) {
                Channel channel;
                boolean eventSourceEnabled;
                DefaultTrigger errorTrigger = (DefaultTrigger)alert.getModel().getTrigger();
                Set<ErrorEventType> errorEventTypes = errorTrigger.getErrorEventTypes();
                AlertChannels alertChannels = errorTrigger.getAlertChannels();
                boolean containsType = errorEventTypes.contains(errorEvent.getType()) || errorEventTypes.contains(ErrorEventType.ANY);
                boolean bl = eventSourceEnabled = metaDataId == null ? alertChannels.isChannelEnabled(channelId) : alertChannels.isConnectorEnabled(channelId, metaDataId);
                if (!containsType || !eventSourceEnabled) continue;
                boolean trigger = true;
                Object errorSource = errorEvent.getType().toString();
                if (errorEvent.getConnectorType() != null) {
                    errorSource = (String)errorSource + " (" + errorEvent.getConnectorType() + ")";
                }
                String fullErrorMessage = ErrorMessageBuilder.buildErrorMessage((String)errorSource, errorEvent.getCustomMessage(), errorEvent.getThrowable());
                if (StringUtils.isNotBlank((CharSequence)errorTrigger.getRegex())) {
                    Pattern pattern = (Pattern)alert.getProperties().get((Object)Keys.PATTERN);
                    if (pattern == null) {
                        pattern = Pattern.compile(errorTrigger.getRegex());
                        alert.getProperties().put((Object)Keys.PATTERN, pattern);
                    }
                    trigger = pattern.matcher(fullErrorMessage).find();
                }
                if (!trigger) continue;
                String channelName = "";
                if (channelId != null && (channel = this.channelController.getDeployedChannelById(channelId)) != null) {
                    channelName = channel.getName();
                }
                Map<String, Object> context = alert.createContext();
                context.put("systemTime", String.valueOf(errorEvent.getDateTime()));
                context.put("channelId", channelId);
                context.put("channelName", channelName);
                context.put("connectorName", errorEvent.getConnectorName());
                context.put("connectorType", errorEvent.getConnectorType());
                context.put("error", fullErrorMessage);
                context.put("errorMessage", errorEvent.getThrowable() == null ? "No exception message." : errorEvent.getThrowable().getMessage());
                context.put("errorType", errorEvent.getType());
                if (errorEvent.getMessageId() != null) {
                    context.put("messageId", errorEvent.getMessageId());
                }
                this.triggerAction(alert, context);
            }
        }
    }

    private static enum Keys {
        PATTERN;

    }
}

