/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.api;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.client.core.ExtensionOperation;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelSummary;
import com.mirth.connect.model.LoginStatus;
import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.model.ServerEventContext;
import com.mirth.connect.model.User;
import com.mirth.connect.server.controllers.AuthorizationController;
import com.mirth.connect.server.controllers.ChannelAuthorizer;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.UserController;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public abstract class MirthServlet {
    public static final String BYPASS_USERNAME = "bypass";
    protected static final String SESSION_USER = "user";
    protected static final String SESSION_AUTHORIZED = "authorized";
    protected HttpServletRequest request;
    protected ContainerRequestContext containerRequestContext;
    protected SecurityContext sc;
    protected ServerEventContext context;
    protected Operation operation;
    protected Map<String, Object> parameterMap;
    private boolean channelRestrictionsInitialized;
    private boolean userHasChannelRestrictions;
    private ChannelAuthorizer channelAuthorizer;
    protected ControllerFactory controllerFactory;
    private static UserController userController;
    private static AuthorizationController authorizationController;
    private static ConfigurationController configurationController;
    private String extensionName;
    private boolean bypassUser;
    private int currentUserId;

    public MirthServlet(HttpServletRequest request, SecurityContext sc) {
        this(request, null, sc);
    }

    public MirthServlet(HttpServletRequest request, SecurityContext sc, ControllerFactory controllerFactory) {
        this(request, null, sc, controllerFactory);
    }

    public MirthServlet(HttpServletRequest request, ContainerRequestContext containerRequestContext, SecurityContext sc) {
        this(request, containerRequestContext, sc, true);
    }

    public MirthServlet(HttpServletRequest request, ContainerRequestContext containerRequestContext, SecurityContext sc, ControllerFactory controllerFactory) {
        this(request, containerRequestContext, sc, true, controllerFactory);
    }

    public MirthServlet(HttpServletRequest request, SecurityContext sc, boolean initLogin) {
        this(request, null, sc, initLogin);
    }

    public MirthServlet(HttpServletRequest request, ContainerRequestContext containerRequestContext, SecurityContext sc, boolean initLogin) {
        this(request, containerRequestContext, sc, null, initLogin);
    }

    public MirthServlet(HttpServletRequest request, ContainerRequestContext containerRequestContext, SecurityContext sc, boolean initLogin, ControllerFactory controllerFactory) {
        this(request, containerRequestContext, sc, null, initLogin, controllerFactory);
    }

    public MirthServlet(HttpServletRequest request, SecurityContext sc, String extensionName) {
        this(request, null, sc, extensionName);
    }

    public MirthServlet(HttpServletRequest request, ContainerRequestContext containerRequestContext, SecurityContext sc, String extensionName) {
        this(request, containerRequestContext, sc, extensionName, true);
    }

    public MirthServlet(HttpServletRequest request, SecurityContext sc, String extensionName, boolean initLogin) {
        this(request, null, sc, extensionName, initLogin);
    }

    public MirthServlet(HttpServletRequest request, ContainerRequestContext containerRequestContext, SecurityContext sc, String extensionName, boolean initLogin) {
        this(request, containerRequestContext, sc, extensionName, initLogin, ControllerFactory.getFactory());
    }

    public MirthServlet(HttpServletRequest request, ContainerRequestContext containerRequestContext, SecurityContext sc, String extensionName, boolean initLogin, ControllerFactory controllerFactory) {
        this.controllerFactory = controllerFactory;
        this.initializeControllers();
        this.request = request;
        this.containerRequestContext = containerRequestContext;
        this.sc = sc;
        this.extensionName = extensionName;
        this.parameterMap = new HashMap<String, Object>();
        if (initLogin) {
            this.initLogin();
        }
    }

    protected void initializeControllers() {
        userController = this.controllerFactory.createUserController();
        authorizationController = this.controllerFactory.createAuthorizationController();
        configurationController = this.controllerFactory.createConfigurationController();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initLogin() {
        boolean validLogin = false;
        if (this.isUserLoggedIn()) {
            this.currentUserId = Integer.parseInt(this.request.getSession().getAttribute(SESSION_USER).toString());
            this.setContext();
            return;
        }
        String authHeader = this.request.getHeader("Authorization");
        if (StringUtils.startsWith((CharSequence)authHeader, (CharSequence)"Basic ")) {
            String username = null;
            String password = null;
            try {
                authHeader = new String(Base64.decodeBase64((String)StringUtils.removeStartIgnoreCase((String)authHeader, (String)"Basic ").trim()), "US-ASCII");
                int colonIndex = StringUtils.indexOf((CharSequence)authHeader, (int)58);
                if (colonIndex > 0) {
                    username = StringUtils.substring((String)authHeader, (int)0, (int)colonIndex);
                    password = StringUtils.substring((String)authHeader, (int)(colonIndex + 1));
                }
            }
            catch (Exception colonIndex) {
                // empty catch block
            }
            if (username != null && password != null) {
                if (StringUtils.equals(username, (CharSequence)BYPASS_USERNAME)) {
                    if (configurationController.isBypasswordEnabled() && this.isRequestLocal() && configurationController.checkBypassword(password)) {
                        this.context = ServerEventContext.SYSTEM_USER_EVENT_CONTEXT;
                        this.currentUserId = this.context.getUserId();
                        this.bypassUser = true;
                        return;
                    }
                } else {
                    try {
                        int status = configurationController.getStatus(false);
                        if (status == 3 || status == 0) {
                            User user;
                            LoginStatus loginStatus = userController.authorizeUser(username, password, null);
                            if (loginStatus.getStatus() != LoginStatus.Status.SUCCESS) {
                                if (loginStatus.getStatus() != LoginStatus.Status.SUCCESS_GRACE_PERIOD) throw new MirthApiException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)loginStatus).build());
                            }
                            if ((user = userController.getUser(null, username)) != null) {
                                this.currentUserId = user.getId();
                                this.setContext();
                                return;
                            }
                            loginStatus = new LoginStatus(LoginStatus.Status.FAIL, "Could not find a valid user with username: " + username);
                            throw new MirthApiException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)loginStatus).build());
                        }
                        LoginStatus loginStatus = new LoginStatus(LoginStatus.Status.FAIL, "Server is still starting or otherwise unavailable. Please try again shortly.");
                        throw new MirthApiException(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)loginStatus).build());
                    }
                    catch (ControllerException e) {
                        throw new MirthApiException((Throwable)e);
                    }
                }
            }
        }
        if (validLogin) return;
        throw new MirthApiException(Response.Status.UNAUTHORIZED);
    }

    private void setContext() {
        this.context = new ServerEventContext(this.currentUserId);
    }

    public void setOperation(Operation operation) {
        if (this.extensionName != null) {
            operation = new ExtensionOperation(this.extensionName, operation);
        }
        this.operation = operation;
    }

    public void addToParameterMap(String name, Object value) {
        this.parameterMap.put(name, value);
    }

    protected String getSessionId() {
        return this.request.getSession().getId();
    }

    protected boolean isUserLoggedIn() {
        HttpSession session = this.request.getSession();
        return session.getAttribute(SESSION_AUTHORIZED) != null && session.getAttribute(SESSION_AUTHORIZED).equals(true);
    }

    public void checkUserAuthorized() {
        if (!this.isUserAuthorized()) {
            throw new MirthApiException(Response.Status.FORBIDDEN);
        }
    }

    public void checkUserAuthorized(Integer userId) {
        this.checkUserAuthorized(userId, true);
    }

    public void checkUserAuthorized(Integer userId, boolean auditCurrentUser) {
        if (auditCurrentUser ? !this.isUserAuthorized() && !this.isCurrentUser(userId) : !this.isCurrentUser(userId) && !this.isUserAuthorized()) {
            throw new MirthApiException(Response.Status.FORBIDDEN);
        }
    }

    public void checkUserAuthorized(String channelId) {
        if (!this.isUserAuthorized() || this.isChannelRedacted(channelId)) {
            throw new MirthApiException(Response.Status.FORBIDDEN);
        }
    }

    protected boolean isUserAuthorized() {
        return this.isUserAuthorized(true);
    }

    protected boolean isUserAuthorized(boolean audit) {
        if (this.context == null) {
            this.initLogin();
        }
        if (this.operation == null) {
            throw new MirthApiException("Method operation not set.");
        }
        try {
            if (this.bypassUser) {
                if (audit) {
                    this.auditAuthorizationRequest(ServerEvent.Outcome.SUCCESS);
                }
                return true;
            }
            return authorizationController.isUserAuthorized(this.getCurrentUserId(), this.operation, this.parameterMap, this.getRequestIpAddress(), audit);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    protected void checkUserAuthorizedForExtension(String extensionName) {
        if (!this.isUserAuthorizedForExtension(extensionName)) {
            throw new MirthApiException(Response.Status.FORBIDDEN);
        }
    }

    protected boolean isUserAuthorizedForExtension(String extensionName) {
        return this.isUserAuthorizedForExtension(extensionName, true);
    }

    protected boolean isUserAuthorizedForExtension(String extensionName, boolean audit) {
        if (this.operation == null) {
            throw new MirthApiException("Method operation not set.");
        }
        try {
            ExtensionOperation extensionOperation = new ExtensionOperation(extensionName, this.operation);
            if (this.bypassUser) {
                if (audit) {
                    this.auditAuthorizationRequest(ServerEvent.Outcome.SUCCESS, (Operation)extensionOperation);
                }
                return true;
            }
            return authorizationController.isUserAuthorized(this.getCurrentUserId(), (Operation)extensionOperation, this.parameterMap, this.getRequestIpAddress(), audit);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    protected void auditAuthorizationRequest(ServerEvent.Outcome outcome) {
        this.auditAuthorizationRequest(outcome, this.operation);
    }

    protected void auditAuthorizationRequest(ServerEvent.Outcome outcome, Operation operation) {
        authorizationController.auditAuthorizationRequest(this.getCurrentUserId(), operation, this.parameterMap, outcome, this.getRequestIpAddress());
    }

    protected int getCurrentUserId() {
        return this.currentUserId;
    }

    protected String getRequestIpAddress() {
        String address = this.request.getHeader("x-forwarded-for");
        if (address == null) {
            address = this.request.getRemoteAddr();
        }
        return address;
    }

    protected List<Channel> redactChannels(List<Channel> channels) {
        this.initChannelRestrictions();
        if (this.userHasChannelRestrictions) {
            ArrayList<Channel> authorizedChannels = new ArrayList<Channel>();
            for (Channel channel : channels) {
                if (!this.channelAuthorizer.isChannelAuthorized(channel.getId())) continue;
                authorizedChannels.add(channel);
            }
            return authorizedChannels;
        }
        return channels;
    }

    protected Set<String> redactChannelIds(Set<String> channelIds) {
        this.initChannelRestrictions();
        if (this.userHasChannelRestrictions) {
            HashSet<String> finishedChannelIds = new HashSet<String>();
            for (String channelId : channelIds) {
                if (!this.channelAuthorizer.isChannelAuthorized(channelId)) continue;
                finishedChannelIds.add(channelId);
            }
            return finishedChannelIds;
        }
        return channelIds;
    }

    protected <T> Map<String, T> redactChannelIds(Map<String, T> map) {
        this.initChannelRestrictions();
        if (this.userHasChannelRestrictions) {
            HashMap<String, T> authorizedMap = new HashMap<String, T>();
            for (Map.Entry<String, T> entry : map.entrySet()) {
                if (!this.channelAuthorizer.isChannelAuthorized(entry.getKey())) continue;
                authorizedMap.put(entry.getKey(), entry.getValue());
            }
            return authorizedMap;
        }
        return map;
    }

    protected List<ChannelSummary> redactChannelSummaries(List<ChannelSummary> channelSummaries) {
        this.initChannelRestrictions();
        if (this.userHasChannelRestrictions) {
            ArrayList<ChannelSummary> authorizedChannelSummaries = new ArrayList<ChannelSummary>();
            for (ChannelSummary channelSummary : channelSummaries) {
                if (!this.channelAuthorizer.isChannelAuthorized(channelSummary.getChannelId())) continue;
                authorizedChannelSummaries.add(channelSummary);
            }
            return authorizedChannelSummaries;
        }
        return channelSummaries;
    }

    protected boolean doesUserHaveChannelRestrictions() {
        this.initChannelRestrictions();
        return this.userHasChannelRestrictions;
    }

    protected boolean isChannelRedacted(String channelId) {
        this.initChannelRestrictions();
        return this.userHasChannelRestrictions && !this.channelAuthorizer.isChannelAuthorized(channelId);
    }

    protected ChannelAuthorizer getChannelAuthorizer() {
        return this.channelAuthorizer;
    }

    private void initChannelRestrictions() {
        if (!this.channelRestrictionsInitialized) {
            try {
                boolean bl = this.userHasChannelRestrictions = !this.bypassUser && authorizationController.doesUserHaveChannelRestrictions(this.currentUserId, this.operation);
                if (this.userHasChannelRestrictions) {
                    this.channelAuthorizer = authorizationController.getChannelAuthorizer(this.currentUserId, this.operation);
                }
            }
            catch (ControllerException e) {
                throw new MirthApiException((Throwable)e);
            }
            this.channelRestrictionsInitialized = true;
        }
    }

    protected boolean isCurrentUser(Integer userId) {
        return userId.intValue() == this.getCurrentUserId();
    }

    protected boolean isRequestLocal() {
        String remoteAddr = this.request.getRemoteAddr().replace("[", "").replace("]", "");
        try {
            if (StringUtils.equals((CharSequence)InetAddress.getLocalHost().getHostAddress(), (CharSequence)remoteAddr)) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            for (InetAddress inetAddress : InetAddress.getAllByName("localhost")) {
                if (!StringUtils.equals((CharSequence)inetAddress.getHostAddress(), (CharSequence)remoteAddr)) continue;
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }
}

