/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.api.providers;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ext.Provider;
import org.apache.commons.configuration2.PropertiesConfiguration;

@Provider
public class ClickjackingFilter
implements Filter {
    private String contentSecurityPolicy;
    private String xFrameOptions;

    public ClickjackingFilter(PropertiesConfiguration mirthProperties) {
        this.contentSecurityPolicy = mirthProperties.getString("server.api.contentsecuritypolicy", "frame-ancestors 'none'");
        this.xFrameOptions = mirthProperties.getString("server.api.xframeoptions", "DENY");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse res = (HttpServletResponse)response;
        res.addHeader("Content-Security-Policy", this.contentSecurityPolicy);
        res.addHeader("X-Frame-Options", this.xFrameOptions);
        res.addHeader("X-Content-Type-Options", "nosniff");
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

