/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.api.providers;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ext.Provider;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;

@Provider
public class RequestedWithFilter
implements Filter {
    private boolean isRequestedWithHeaderRequired = true;

    public RequestedWithFilter(PropertiesConfiguration mirthProperties) {
        this.isRequestedWithHeaderRequired = mirthProperties.getBoolean("server.api.require-requested-with", true);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse res = (HttpServletResponse)response;
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        String requestedWithHeader = servletRequest.getHeader("X-Requested-With");
        if (this.isRequestedWithHeaderRequired && StringUtils.isBlank((CharSequence)requestedWithHeader)) {
            res.sendError(400, "All requests must have 'X-Requested-With' header");
        } else {
            chain.doFilter(request, response);
        }
    }

    public boolean isRequestedWithHeaderRequired() {
        return this.isRequestedWithHeaderRequired;
    }

    public void destroy() {
    }
}

