/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.client.core.api.servlets.ChannelServletInterface;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.model.channel.PollConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.channel.Ports;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelDependency;
import com.mirth.connect.model.ChannelHeader;
import com.mirth.connect.model.ChannelMetadata;
import com.mirth.connect.model.ChannelSummary;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.server.api.CheckAuthorizedChannelId;
import com.mirth.connect.server.api.DontCheckAuthorized;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.CodeTemplateController;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EngineController;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChannelServlet
extends MirthServlet
implements ChannelServletInterface {
    private static final EngineController engineController = ControllerFactory.getFactory().createEngineController();
    private static final ChannelController channelController = ControllerFactory.getFactory().createChannelController();
    private static final CodeTemplateController codeTemplateController = ControllerFactory.getFactory().createCodeTemplateController();
    private static final ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private Logger logger = LogManager.getLogger(this.getClass());

    public ChannelServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc);
    }

    public boolean createChannel(Channel channel) {
        if (this.isChannelRedacted(channel.getId())) {
            throw new MirthApiException(Response.Status.FORBIDDEN);
        }
        try {
            return channelController.updateChannel(channel, this.context, false, null);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @DontCheckAuthorized
    public List<Channel> getChannels(Set<String> channelIds, boolean pollingOnly, boolean includeCodeTemplateLibraries) {
        if (CollectionUtils.isNotEmpty(channelIds)) {
            this.parameterMap.put("channelIds", channelIds);
        }
        if (!this.isUserAuthorized()) {
            return new ArrayList<Channel>();
        }
        List<Channel> channels = CollectionUtils.isEmpty(channelIds) ? this.redactChannels(channelController.getChannels(null)) : channelController.getChannels(this.redactChannelIds(channelIds));
        if (pollingOnly) {
            this.retainPollingChannels(channels);
        }
        if (channels == null) {
            return channels;
        }
        Map<String, ChannelMetadata> channelMetadata = configurationController.getChannelMetadata();
        Set<ChannelTag> channelTags = configurationController.getChannelTags();
        Set<ChannelDependency> channelDependencies = configurationController.getChannelDependencies();
        List<CodeTemplateLibrary> codeTemplateLibraries = includeCodeTemplateLibraries ? this.getCodeTemplateLibraries() : null;
        ArrayList<Channel> clonedChannels = new ArrayList<Channel>();
        for (Channel channel : channels) {
            Channel clonedChannel = channel.clone();
            this.addExportData(clonedChannel, channelMetadata, channelTags, channelDependencies, codeTemplateLibraries);
            clonedChannels.add(clonedChannel);
        }
        return clonedChannels;
    }

    @DontCheckAuthorized
    public List<Channel> getChannelsPost(Set<String> channelIds, boolean pollingOnly, boolean includeCodeTemplateLibraries) {
        return this.getChannels(channelIds, pollingOnly, includeCodeTemplateLibraries);
    }

    @DontCheckAuthorized
    public Channel getChannel(String channelId, boolean includeCodeTemplateLibraries) {
        this.parameterMap.put("channelId", channelId);
        if (!this.isUserAuthorized() || this.isChannelRedacted(channelId)) {
            return null;
        }
        Channel channel = channelController.getChannelById(channelId);
        if (channel == null) {
            return channel;
        }
        Channel clonedChannel = channel.clone();
        this.addExportData(clonedChannel, includeCodeTemplateLibraries);
        return clonedChannel;
    }

    @DontCheckAuthorized
    public Map<Integer, String> getConnectorNames(String channelId) {
        this.parameterMap.put("channelId", channelId);
        if (!this.isUserAuthorized()) {
            return new LinkedHashMap<Integer, String>();
        }
        if (this.isChannelRedacted(channelId)) {
            return null;
        }
        return channelController.getConnectorNames(channelId);
    }

    @DontCheckAuthorized
    public List<MetaDataColumn> getMetaDataColumns(String channelId) {
        this.parameterMap.put("channelId", channelId);
        if (!this.isUserAuthorized()) {
            return new ArrayList<MetaDataColumn>();
        }
        if (this.isChannelRedacted(channelId)) {
            return null;
        }
        return channelController.getMetaDataColumns(channelId);
    }

    @DontCheckAuthorized
    public Map<String, String> getChannelIdsAndNames() throws ClientException {
        HashMap<String, String> channelIdsAndNames = new HashMap<String, String>();
        if (this.isUserAuthorized()) {
            for (Channel channel : this.redactChannels(channelController.getChannels(null))) {
                channelIdsAndNames.put(channel.getId(), channel.getName());
            }
        }
        return channelIdsAndNames;
    }

    @DontCheckAuthorized
    public List<Ports> getChannelPortsInUse() throws ClientException {
        List<Ports> ports = new ArrayList<Ports>();
        if (this.isUserAuthorized()) {
            ports = channelController.getPortsInUse();
        }
        return ports;
    }

    @DontCheckAuthorized
    public List<ChannelSummary> getChannelSummary(Map<String, ChannelHeader> cachedChannels, boolean ignoreNewChannels) {
        this.parameterMap.put("cachedChannels", cachedChannels);
        if (!this.isUserAuthorized()) {
            return new ArrayList<ChannelSummary>();
        }
        try {
            return this.redactChannelSummaries(channelController.getChannelSummary(cachedChannels, ignoreNewChannels));
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public void setChannelEnabled(Set<String> channelIds, boolean enabled) {
        if (CollectionUtils.isEmpty(channelIds)) {
            channelIds = channelController.getChannelIds();
        }
        try {
            channelController.setChannelEnabled(this.redactChannelIds(channelIds), this.context, enabled);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @CheckAuthorizedChannelId
    public void setChannelEnabled(String channelId, boolean enabled) {
        try {
            channelController.setChannelEnabled(Collections.singleton(channelId), this.context, enabled);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public void setChannelInitialState(Set<String> channelIds, DeployedState initialState) {
        if (CollectionUtils.isEmpty(channelIds)) {
            channelIds = channelController.getChannelIds();
        }
        try {
            channelController.setChannelInitialState(this.redactChannelIds(channelIds), this.context, initialState);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @CheckAuthorizedChannelId
    public void setChannelInitialState(String channelId, DeployedState initialState) {
        try {
            channelController.setChannelInitialState(Collections.singleton(channelId), this.context, initialState);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @CheckAuthorizedChannelId
    public boolean updateChannel(String channelId, Channel channel, boolean override, String startEdit) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.getDefault());
            Calendar dateStartEdit = Calendar.getInstance();
            try {
                if (startEdit != null) {
                    dateStartEdit.setTime(sdf.parse(startEdit));
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return channelController.updateChannel(channel, this.context, override, dateStartEdit);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @CheckAuthorizedChannelId
    public void removeChannel(String channelId) {
        engineController.removeChannels(this.redactChannelIds(Collections.singleton(channelId)), this.context, null);
    }

    public void removeChannels(Set<String> channelIds) {
        engineController.removeChannels(this.redactChannelIds(channelIds), this.context, null);
    }

    public void removeChannelsPost(Set<String> channelIds) {
        this.removeChannels(channelIds);
    }

    private void retainPollingChannels(List<Channel> channels) {
        Iterator<Channel> it = channels.iterator();
        while (it.hasNext()) {
            if (ArrayUtils.contains((Object[])it.next().getSourceConnector().getProperties().getClass().getInterfaces(), PollConnectorPropertiesInterface.class)) continue;
            it.remove();
        }
    }

    protected void addExportData(Channel channel, boolean includeCodeTemplateLibraries) {
        if (channel != null) {
            List<CodeTemplateLibrary> codeTemplateLibraries = includeCodeTemplateLibraries ? this.getCodeTemplateLibraries() : null;
            this.addExportData(channel, configurationController.getChannelMetadata(), configurationController.getChannelTags(), configurationController.getChannelDependencies(), codeTemplateLibraries);
        }
    }

    protected void addExportData(Channel channel, Map<String, ChannelMetadata> channelMetadata, Set<ChannelTag> channelTags, Set<ChannelDependency> channelDependencies, List<CodeTemplateLibrary> codeTemplateLibraries) {
        if (channel != null) {
            channel.getExportData().setMetadata(channelMetadata.get(channel.getId()));
            channel.getExportData().setChannelTags(channelTags.stream().filter(tag -> tag.getChannelIds().contains(channel.getId())).collect(Collectors.toList()));
            channel.getExportData().setDependencyIds(channelDependencies.stream().filter(dependency -> channel.getId().equals(dependency.getDependentId())).map(dependency -> dependency.getDependencyId()).collect(Collectors.toSet()));
            channel.getExportData().setDependentIds(channelDependencies.stream().filter(dependency -> channel.getId().equals(dependency.getDependencyId())).map(dependency -> dependency.getDependentId()).collect(Collectors.toSet()));
            if (codeTemplateLibraries != null) {
                channel.getExportData().setCodeTemplateLibraries(codeTemplateLibraries.stream().filter(library -> library.getEnabledChannelIds().contains(channel.getId())).collect(Collectors.toList()));
            } else {
                channel.getExportData().setCodeTemplateLibraries(null);
            }
        }
    }

    private List<CodeTemplateLibrary> getCodeTemplateLibraries() {
        List<CodeTemplateLibrary> codeTemplateLibraries = null;
        try {
            codeTemplateLibraries = codeTemplateController.getLibraries(null, true);
        }
        catch (ControllerException e) {
            this.logger.error("Failed to get code template libraries.", (Throwable)e);
            codeTemplateLibraries = null;
        }
        return codeTemplateLibraries;
    }
}

