/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.api.servlets;

import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.client.core.api.servlets.ChannelStatusServletInterface;
import com.mirth.connect.model.DashboardChannelInfo;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.model.filter.SearchFilter;
import com.mirth.connect.model.filter.SearchFilterParser;
import com.mirth.connect.server.api.CheckAuthorizedChannelId;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.channel.ErrorTaskHandler;
import com.mirth.connect.server.controllers.ChannelAuthorizer;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EngineController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ChannelStatusServlet
extends MirthServlet
implements ChannelStatusServletInterface {
    private static EngineController engineController;
    private static ConfigurationController configurationController;

    public ChannelStatusServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc);
    }

    public ChannelStatusServlet(@Context HttpServletRequest request, @Context SecurityContext sc, ControllerFactory controllerFactory) {
        super(request, sc, controllerFactory);
    }

    @Override
    protected void initializeControllers() {
        super.initializeControllers();
        engineController = this.controllerFactory.createEngineController();
        configurationController = this.controllerFactory.createConfigurationController();
    }

    @CheckAuthorizedChannelId
    public DashboardStatus getChannelStatus(String channelId) {
        DashboardStatus status = engineController.getChannelStatus(channelId);
        if (status == null) {
            throw new MirthApiException(Response.Status.NOT_FOUND);
        }
        return status;
    }

    public List<DashboardStatus> getChannelStatusList(Set<String> channelIds, String filter, boolean includeUndeployed) {
        List<SearchFilter> searchFilterList;
        List<DashboardStatus> statuses = CollectionUtils.isEmpty(channelIds) ? this.redactChannelStatuses(engineController.getChannelStatusList(null, includeUndeployed)) : engineController.getChannelStatusList(this.redactChannelIds(channelIds), includeUndeployed);
        if (StringUtils.isNotBlank((CharSequence)filter) && CollectionUtils.isNotEmpty(searchFilterList = SearchFilterParser.parse(filter, configurationController.getChannelTags())) && CollectionUtils.isNotEmpty(statuses)) {
            for (SearchFilter searchFilter : searchFilterList) {
                searchFilter.filterDashboardStatuses(statuses);
            }
        }
        return statuses;
    }

    public List<DashboardStatus> getChannelStatusListPost(Set<String> channelIds, String filter, boolean includeUndeployed) {
        return this.getChannelStatusList(channelIds, filter, includeUndeployed);
    }

    public DashboardChannelInfo getDashboardChannelInfo(int fetchSize, String filter) {
        Set<String> channelIds;
        boolean filterDashboardStatuses;
        List<Object> searchFilterList;
        Set<String> remainingChannelIds = this.redactChannelIds(engineController.getDeployedIds());
        int deployedCount = remainingChannelIds.size();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchFilterList = SearchFilterParser.parse(filter, configurationController.getChannelTags());
            filterDashboardStatuses = CollectionUtils.isNotEmpty(searchFilterList);
            if (filterDashboardStatuses) {
                for (SearchFilter searchFilter : searchFilterList) {
                    searchFilter.filterChannelIds(remainingChannelIds);
                }
            }
        } else {
            searchFilterList = new ArrayList();
            filterDashboardStatuses = false;
        }
        if (remainingChannelIds.size() > fetchSize) {
            channelIds = new HashSet<String>(fetchSize);
            Iterator<String> iterator = remainingChannelIds.iterator();
            while (iterator.hasNext() && channelIds.size() < fetchSize) {
                channelIds.add(iterator.next());
                iterator.remove();
            }
        } else {
            channelIds = remainingChannelIds;
            remainingChannelIds = Collections.emptySet();
        }
        List<Object> channelStatuses = CollectionUtils.isNotEmpty(channelIds) ? this.redactChannelStatuses(engineController.getChannelStatusList(channelIds)) : new ArrayList();
        if (filterDashboardStatuses && CollectionUtils.isNotEmpty(channelStatuses)) {
            for (SearchFilter searchFilter : searchFilterList) {
                searchFilter.filterDashboardStatuses(channelStatuses);
            }
        }
        return new DashboardChannelInfo(channelStatuses, remainingChannelIds, deployedCount);
    }

    @CheckAuthorizedChannelId
    public void startChannel(String channelId, boolean returnErrors) {
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.startChannels(Collections.singleton(channelId), handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    public void startChannels(Set<String> channelIds, boolean returnErrors) {
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.startChannels(this.redactChannelIds(channelIds), handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    @CheckAuthorizedChannelId
    public void stopChannel(String channelId, boolean returnErrors) {
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.stopChannels(Collections.singleton(channelId), handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    public void stopChannels(Set<String> channelIds, boolean returnErrors) {
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.stopChannels(this.redactChannelIds(channelIds), handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    @CheckAuthorizedChannelId
    public void haltChannel(String channelId, boolean returnErrors) {
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.haltChannels(Collections.singleton(channelId), handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    public void haltChannels(Set<String> channelIds, boolean returnErrors) {
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.haltChannels(this.redactChannelIds(channelIds), handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    @CheckAuthorizedChannelId
    public void pauseChannel(String channelId, boolean returnErrors) {
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.pauseChannels(Collections.singleton(channelId), handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    public void pauseChannels(Set<String> channelIds, boolean returnErrors) {
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.pauseChannels(this.redactChannelIds(channelIds), handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    @CheckAuthorizedChannelId
    public void resumeChannel(String channelId, boolean returnErrors) {
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.resumeChannels(Collections.singleton(channelId), handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    public void resumeChannels(Set<String> channelIds, boolean returnErrors) {
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.resumeChannels(this.redactChannelIds(channelIds), handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    @CheckAuthorizedChannelId
    public void startConnector(String channelId, Integer metaDataId, boolean returnErrors) {
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.startConnector(Collections.singletonMap(channelId, Collections.singletonList(metaDataId)), handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    public void startConnectors(Map<String, List<Integer>> connectorInfo, boolean returnErrors) {
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.startConnector(this.redactConnectorInfo(connectorInfo), handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    @CheckAuthorizedChannelId
    public void stopConnector(String channelId, Integer metaDataId, boolean returnErrors) {
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.stopConnector(Collections.singletonMap(channelId, Collections.singletonList(metaDataId)), handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    public void stopConnectors(Map<String, List<Integer>> connectorInfo, boolean returnErrors) {
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.stopConnector(this.redactConnectorInfo(connectorInfo), handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    List<DashboardStatus> redactChannelStatuses(List<DashboardStatus> channelStatuses) {
        if (this.doesUserHaveChannelRestrictions()) {
            ChannelAuthorizer channelAuthorizer = this.getChannelAuthorizer();
            ArrayList<DashboardStatus> authorizedStatuses = new ArrayList<DashboardStatus>();
            for (DashboardStatus status : channelStatuses) {
                if (!channelAuthorizer.isChannelAuthorized(status.getChannelId())) continue;
                authorizedStatuses.add(status);
            }
            return authorizedStatuses;
        }
        return channelStatuses;
    }

    Map<String, List<Integer>> redactConnectorInfo(Map<String, List<Integer>> connectorInfo) {
        if (this.doesUserHaveChannelRestrictions()) {
            ChannelAuthorizer channelAuthorizer = this.getChannelAuthorizer();
            HashMap<String, List<Integer>> finishedConnectorInfo = new HashMap<String, List<Integer>>();
            for (String channelId : connectorInfo.keySet()) {
                if (!channelAuthorizer.isChannelAuthorized(channelId)) continue;
                finishedConnectorInfo.put(channelId, connectorInfo.get(channelId));
            }
            return finishedConnectorInfo;
        }
        return connectorInfo;
    }
}

