/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.api.servlets;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.client.core.api.servlets.ConfigurationServletInterface;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.channel.PollConnectorPropertiesInterface;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelDependency;
import com.mirth.connect.model.ChannelMetadata;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.DriverInfo;
import com.mirth.connect.model.EncryptionSettings;
import com.mirth.connect.model.LibraryProperties;
import com.mirth.connect.model.LicenseInfo;
import com.mirth.connect.model.MetaData;
import com.mirth.connect.model.PasswordRequirements;
import com.mirth.connect.model.PublicServerSettings;
import com.mirth.connect.model.ResourceProperties;
import com.mirth.connect.model.ResourcePropertiesList;
import com.mirth.connect.model.ServerConfiguration;
import com.mirth.connect.model.ServerSettings;
import com.mirth.connect.model.UpdateSettings;
import com.mirth.connect.model.alert.AlertModel;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.server.api.DontCheckAuthorized;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.util.ConfigurationProperty;
import com.mirth.connect.util.ConnectionTestResponse;
import com.mirth.connect.util.MirthSSLUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationServlet
extends MirthServlet
implements ConfigurationServletInterface {
    private static final Logger logger = LogManager.getLogger(ConfigurationServlet.class);
    private static final ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private static final ScriptController scriptController = ControllerFactory.getFactory().createScriptController();
    private static final ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private static final ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();
    private static final ChannelController channelController = ControllerFactory.getFactory().createChannelController();
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();

    public ConfigurationServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc, false);
    }

    public String getServerId() {
        return configurationController.getServerId();
    }

    @DontCheckAuthorized
    public String getVersion() {
        return configurationController.getServerVersion();
    }

    public String getBuildDate() {
        return configurationController.getBuildDate();
    }

    @DontCheckAuthorized
    public int getStatus() {
        return configurationController.getStatus();
    }

    public String getServerTimezone() {
        return configurationController.getServerTimezone(this.request.getLocale());
    }

    public Calendar getServerTime() {
        return configurationController.getServerTime();
    }

    public String getJVMName() {
        return System.getProperty("java.vm.name");
    }

    public Map<String, Object> getAbout() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("name", configurationController.getServerName());
        properties.put("version", configurationController.getServerVersion());
        properties.put("date", configurationController.getBuildDate());
        properties.put("database", configurationController.getDatabaseType());
        properties.put("channelCount", channelController.getChannelIds().size());
        HashMap<String, String> plugins = new HashMap<String, String>();
        for (MetaData metaData : extensionController.getPluginMetaData().values()) {
            plugins.put(metaData.getName(), metaData.getPluginVersion());
        }
        HashMap<String, String> connectors = new HashMap<String, String>();
        for (MetaData metaData : extensionController.getConnectorMetaData().values()) {
            connectors.put(metaData.getName(), metaData.getPluginVersion());
        }
        properties.put("plugins", plugins);
        properties.put("connectors", connectors);
        return properties;
    }

    public ServerConfiguration getServerConfiguration(DeployedState initialState, boolean pollingOnly, boolean disableAlerts) {
        if (initialState != null && initialState != DeployedState.STARTED && initialState != DeployedState.PAUSED && initialState != DeployedState.STOPPED) {
            throw new MirthApiException("Initial state cannot be set to " + String.valueOf(initialState) + ".");
        }
        try {
            ServerConfiguration config = configurationController.getServerConfiguration();
            if (initialState != null || disableAlerts) {
                config = serializer.deserialize(serializer.serialize(config), ServerConfiguration.class);
                if (initialState != null) {
                    for (Channel channel : config.getChannels()) {
                        if (pollingOnly && !ArrayUtils.contains((Object[])channel.getSourceConnector().getProperties().getClass().getInterfaces(), PollConnectorPropertiesInterface.class)) continue;
                        channel.getProperties().setInitialState(initialState);
                    }
                }
                if (disableAlerts) {
                    for (AlertModel alert : config.getAlerts()) {
                        alert.setEnabled(false);
                    }
                }
            }
            return config;
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public void setServerConfiguration(ServerConfiguration serverConfiguration, boolean deploy, boolean overwriteConfigMap) {
        try {
            configurationController.setServerConfiguration(serverConfiguration, deploy, overwriteConfigMap);
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public List<String> getAvailableCharsetEncodings() {
        try {
            return configurationController.getAvailableCharsetEncodings();
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public ServerSettings getServerSettings() {
        try {
            return configurationController.getServerSettings();
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public void setServerSettings(ServerSettings settings) {
        try {
            configurationController.setServerSettings(settings);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public PublicServerSettings getPublicServerSettings() {
        try {
            return configurationController.getPublicServerSettings();
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public EncryptionSettings getEncryptionSettings() {
        try {
            return configurationController.getEncryptionSettings();
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public ConnectionTestResponse sendTestEmail(Properties properties) {
        try {
            return configurationController.sendTestEmail(properties);
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public UpdateSettings getUpdateSettings() {
        try {
            return configurationController.getUpdateSettings();
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public void setUpdateSettings(UpdateSettings settings) {
        try {
            configurationController.setUpdateSettings(settings);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public LicenseInfo getLicenseInfo() {
        return LicenseInfo.INSTANCE;
    }

    public String getGuid() {
        return configurationController.generateGuid();
    }

    public Map<String, String> getGlobalScripts() {
        try {
            return scriptController.getGlobalScripts();
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public void setGlobalScripts(Map<String, String> scripts) {
        try {
            scriptController.setGlobalScripts(scripts);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public Map<String, ConfigurationProperty> getConfigurationMap() {
        try {
            return configurationController.getConfigurationProperties();
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public void setConfigurationMap(Map<String, ConfigurationProperty> map) {
        try {
            configurationController.setConfigurationProperties(map, true);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public List<DriverInfo> getDatabaseDrivers() {
        try {
            return configurationController.getDatabaseDrivers();
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public void setDatabaseDrivers(List<DriverInfo> drivers) {
        try {
            configurationController.setDatabaseDrivers(drivers);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public PasswordRequirements getPasswordRequirements() {
        return configurationController.getPasswordRequirements();
    }

    public List<ResourceProperties> getResources() {
        return ObjectXMLSerializer.getInstance().deserialize(configurationController.getResources(), ResourcePropertiesList.class).getList();
    }

    public void setResources(List<ResourceProperties> resources) {
        final ArrayList<LibraryProperties> libraryResources = new ArrayList<LibraryProperties>();
        for (ResourceProperties resource : resources) {
            if (!(resource instanceof LibraryProperties)) continue;
            libraryResources.add((LibraryProperties)resource);
        }
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    contextFactoryController.updateResources(libraryResources, false);
                }
                catch (Exception e) {
                    logger.error("Unable to update libraries: " + e.getMessage(), (Throwable)e);
                }
            }
        });
        configurationController.setResources(ObjectXMLSerializer.getInstance().serialize(new ResourcePropertiesList(resources)));
    }

    public void reloadResource(String resourceId) {
        try {
            contextFactoryController.reloadResource(resourceId);
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public Set<ChannelTag> getChannelTags() throws ClientException {
        return configurationController.getChannelTags();
    }

    public void setChannelTags(Set<ChannelTag> channelTags) throws ClientException {
        configurationController.setChannelTags(channelTags);
    }

    public Set<ChannelDependency> getChannelDependencies() {
        return configurationController.getChannelDependencies();
    }

    public void setChannelDependencies(Set<ChannelDependency> dependencies) {
        configurationController.setChannelDependencies(dependencies);
    }

    public Map<String, ChannelMetadata> getChannelMetadata() {
        return configurationController.getChannelMetadata();
    }

    public void setChannelMetadata(Map<String, ChannelMetadata> metadata) {
        configurationController.setChannelMetadata(metadata);
    }

    public Map<String, String[]> getProtocolsAndCipherSuites() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("supportedProtocols", MirthSSLUtil.getSupportedHttpsProtocols());
        map.put("supportedCipherSuites", MirthSSLUtil.getSupportedHttpsCipherSuites());
        map.put("enabledClientProtocols", MirthSSLUtil.getEnabledHttpsProtocols(configurationController.getHttpsClientProtocols()));
        map.put("enabledServerProtocols", MirthSSLUtil.getEnabledHttpsProtocols(configurationController.getHttpsServerProtocols()));
        map.put("enabledCipherSuites", MirthSSLUtil.getEnabledHttpsCipherSuites(configurationController.getHttpsCipherSuites()));
        return map;
    }

    public int getRhinoLanguageVersion() {
        int languageVersion = 0;
        Integer rhinoLanguageVersion = configurationController.getRhinoLanguageVersion();
        if (rhinoLanguageVersion != null) {
            try {
                org.mozilla.javascript.Context.checkLanguageVersion((int)rhinoLanguageVersion);
                languageVersion = rhinoLanguageVersion;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return languageVersion;
    }

    public String getProperty(String group, String name) throws ClientException {
        return configurationController.getProperty(group, name);
    }
}

