/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.api.servlets;

import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.client.core.api.servlets.DatabaseTaskServletInterface;
import com.mirth.connect.model.DatabaseTask;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.DatabaseTaskController;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.collections4.MapUtils;

public class DatabaseTaskServlet
extends MirthServlet
implements DatabaseTaskServletInterface {
    private static final DatabaseTaskController databaseTaskController = ControllerFactory.getFactory().createDatabaseTaskController();

    public DatabaseTaskServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc);
    }

    public Map<String, DatabaseTask> getDatabaseTasks() {
        try {
            return databaseTaskController.getDatabaseTasks();
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public DatabaseTask getDatabaseTask(String databaseTaskId) {
        Map<String, DatabaseTask> tasks;
        try {
            tasks = databaseTaskController.getDatabaseTasks();
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
        if (MapUtils.isEmpty(tasks) || !tasks.containsKey(databaseTaskId)) {
            throw new MirthApiException(Response.Status.NOT_FOUND);
        }
        return tasks.get(databaseTaskId);
    }

    public String runDatabaseTask(String databaseTaskId) {
        try {
            return databaseTaskController.runDatabaseTask(databaseTaskId);
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public void cancelDatabaseTask(String databaseTaskId) {
        try {
            databaseTaskController.cancelDatabaseTask(databaseTaskId);
        }
        catch (Exception e) {
            throw new MirthApiException((Throwable)e);
        }
    }
}

