/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.api.servlets;

import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.client.core.api.servlets.EngineServletInterface;
import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.server.api.CheckAuthorizedChannelId;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.channel.ErrorTaskHandler;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EngineController;
import com.mirth.connect.server.util.DebuggerUtil;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.collections4.CollectionUtils;

public class EngineServlet
extends MirthServlet
implements EngineServletInterface {
    private static EngineController engineController;
    private static ChannelController channelController;

    public EngineServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc);
    }

    public EngineServlet(@Context HttpServletRequest request, @Context SecurityContext sc, ControllerFactory controllerFactory) {
        super(request, sc, controllerFactory);
    }

    @Override
    protected void initializeControllers() {
        super.initializeControllers();
        engineController = this.controllerFactory.createEngineController();
        channelController = this.controllerFactory.createChannelController();
    }

    public void redeployAllChannels(boolean returnErrors) {
        if (this.doesUserHaveChannelRestrictions()) {
            throw new MirthApiException(Response.Status.FORBIDDEN);
        }
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.redeployAllChannels(this.context, handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    @CheckAuthorizedChannelId
    public void deployChannel(String channelId, boolean returnErrors, String debug) {
        ErrorTaskHandler handler = new ErrorTaskHandler();
        DebugOptions debugOptions = DebuggerUtil.parseDebugOptions(debug);
        engineController.deployChannels(Collections.singleton(channelId), this.context, handler, debugOptions);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    public void deployChannels(Set<String> channelIds, boolean returnErrors) {
        if (CollectionUtils.isEmpty(channelIds)) {
            channelIds = channelController.getChannelIds();
        }
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.deployChannels(this.redactChannelIds(channelIds), this.context, handler, new DebugOptions());
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    @CheckAuthorizedChannelId
    public void undeployChannel(String channelId, boolean returnErrors) {
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.undeployChannels(Collections.singleton(channelId), this.context, handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }

    public void undeployChannels(Set<String> channelIds, boolean returnErrors) {
        if (CollectionUtils.isEmpty(channelIds)) {
            channelIds = engineController.getDeployedIds();
        }
        ErrorTaskHandler handler = new ErrorTaskHandler();
        engineController.undeployChannels(this.redactChannelIds(channelIds), this.context, handler);
        if (returnErrors && handler.isErrored()) {
            throw new MirthApiException((Throwable)handler.getError());
        }
    }
}

