/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.api.servlets;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.client.core.api.servlets.EventServletInterface;
import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.model.filters.EventFilter;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.collections4.CollectionUtils;

public class EventServlet
extends MirthServlet
implements EventServletInterface {
    private static final EventController eventController = ControllerFactory.getFactory().createEventController();

    public EventServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc);
    }

    public Integer getMaxEventId() {
        try {
            return eventController.getMaxEventId();
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public ServerEvent getEvent(Integer eventId) {
        try {
            EventFilter filter = new EventFilter();
            filter.setId(eventId);
            List<ServerEvent> events = eventController.getEvents(filter, 0, 1);
            if (CollectionUtils.isEmpty(events)) {
                throw new MirthApiException(Response.Status.NOT_FOUND);
            }
            return events.iterator().next();
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public List<ServerEvent> getEvents(EventFilter filter, Integer offset, Integer limit) {
        try {
            return eventController.getEvents(filter, offset, limit);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public List<ServerEvent> getEvents(Integer maxEventId, Integer minEventId, Set<ServerEvent.Level> levels, Calendar startDate, Calendar endDate, String name, ServerEvent.Outcome outcome, Integer userId, String attributeSearch, String ipAddress, String serverId, Integer offset, Integer limit) {
        EventFilter filter = new EventFilter();
        filter.setMaxEventId(maxEventId);
        filter.setMinEventId(minEventId);
        if (CollectionUtils.isNotEmpty(levels)) {
            filter.setLevels(levels);
        }
        filter.setStartDate(startDate);
        filter.setEndDate(endDate);
        filter.setName(name);
        filter.setOutcome(outcome);
        filter.setUserId(userId);
        filter.setAttributeSearch(attributeSearch);
        filter.setIpAddress(ipAddress);
        filter.setServerId(serverId);
        try {
            return eventController.getEvents(filter, offset, limit);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public Long getEventCount(EventFilter filter) {
        try {
            return eventController.getEventCount(filter);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public Long getEventCount(Integer maxEventId, Integer minEventId, Set<ServerEvent.Level> levels, Calendar startDate, Calendar endDate, String name, ServerEvent.Outcome outcome, Integer userId, String attributeSearch, String ipAddress, String serverId) {
        EventFilter filter = new EventFilter();
        filter.setMaxEventId(maxEventId);
        filter.setMinEventId(minEventId);
        filter.setLevels(levels);
        filter.setStartDate(startDate);
        filter.setEndDate(endDate);
        filter.setName(name);
        filter.setOutcome(outcome);
        filter.setUserId(userId);
        filter.setAttributeSearch(attributeSearch);
        filter.setIpAddress(ipAddress);
        filter.setServerId(serverId);
        try {
            return eventController.getEventCount(filter);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public String exportAllEvents() {
        try {
            return eventController.exportAllEvents();
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }
}

