/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.api.servlets;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.client.core.api.MirthApiException;
import com.mirth.connect.client.core.api.servlets.ExtensionServletInterface;
import com.mirth.connect.model.ConnectorMetaData;
import com.mirth.connect.model.MetaData;
import com.mirth.connect.model.PluginMetaData;
import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.server.api.DontCheckAuthorized;
import com.mirth.connect.server.api.MirthServlet;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ExtensionController;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

public class ExtensionServlet
extends MirthServlet
implements ExtensionServletInterface {
    private static final ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();

    public ExtensionServlet(@Context HttpServletRequest request, @Context SecurityContext sc) {
        super(request, sc);
    }

    @DontCheckAuthorized
    public void installExtension(InputStream inputStream) {
        if (!this.isUserAuthorized(false)) {
            this.isUserAuthorized(true);
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        ExtensionController.InstallationResult result = extensionController.extractExtension(inputStream);
        this.parameterMap.put("metadata", result.getMetaData());
        this.auditAuthorizationRequest(result.getCause() == null ? ServerEvent.Outcome.SUCCESS : ServerEvent.Outcome.FAILURE);
        if (result.getCause() != null) {
            throw new MirthApiException(result.getCause());
        }
    }

    public void uninstallExtension(String extensionPath) {
        try {
            extensionController.prepareExtensionForUninstallation(extensionPath);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    public MetaData getExtensionMetaData(String extensionName) {
        MetaData metaData = extensionController.getPluginMetaData().get(extensionName);
        if (metaData == null && (metaData = (MetaData)extensionController.getConnectorMetaData().get(extensionName)) == null) {
            throw new MirthApiException(Response.Status.NOT_FOUND);
        }
        return metaData;
    }

    public Map<String, ConnectorMetaData> getConnectorMetaData() {
        return extensionController.getConnectorMetaData();
    }

    public Map<String, PluginMetaData> getPluginMetaData() {
        return extensionController.getPluginMetaData();
    }

    public boolean isExtensionEnabled(String extensionName) {
        return extensionController.isExtensionEnabled(extensionName);
    }

    public void setExtensionEnabled(String extensionName, boolean enabled) {
        try {
            extensionController.setExtensionEnabled(extensionName, enabled);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @DontCheckAuthorized
    public Properties getPluginProperties(String extensionName, Set<String> propertyKeys) {
        this.parameterMap.put("extensionName", extensionName);
        this.checkUserAuthorizedForExtension(extensionName);
        try {
            return extensionController.getPluginProperties(extensionName, propertyKeys);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }

    @DontCheckAuthorized
    public void setPluginProperties(String extensionName, Properties properties, boolean mergeProperties) {
        this.parameterMap.put("extensionName", extensionName);
        this.parameterMap.put("properties", properties);
        this.checkUserAuthorizedForExtension(extensionName);
        try {
            extensionController.setPluginProperties(extensionName, properties, mergeProperties);
            extensionController.updatePluginProperties(extensionName, properties);
        }
        catch (ControllerException e) {
            throw new MirthApiException((Throwable)e);
        }
    }
}

