/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.attachments.dicom;

import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.model.message.attachment.AttachmentException;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandler;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.donkey.util.Base64Util;
import com.mirth.connect.model.converters.DICOMConverter;
import com.mirth.connect.server.util.ServerUUIDGenerator;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public class DICOMAttachmentHandler
implements AttachmentHandler {
    private DicomObject dicomObject;
    private DicomElement dicomElement;
    private int index;
    private String attachmentId;

    public void initialize(RawMessage message, Channel channel) throws AttachmentException {
        this.index = 0;
        try {
            byte[] messageBytes = null;
            boolean decode = false;
            if (message.isBinary().booleanValue()) {
                messageBytes = message.getRawBytes();
            } else {
                messageBytes = org.apache.commons.codec.binary.StringUtils.getBytesUsAscii((String)message.getRawData());
                decode = true;
            }
            this.dicomObject = DICOMConverter.byteArrayToDicomObject(messageBytes, decode);
            this.dicomElement = this.dicomObject.remove(2145386512);
            this.attachmentId = ServerUUIDGenerator.getUUID();
        }
        catch (Throwable t) {
            throw new AttachmentException(t);
        }
    }

    public Attachment nextAttachment() throws AttachmentException {
        try {
            if (this.dicomElement != null) {
                if (this.dicomElement.hasItems()) {
                    int total = this.dicomElement.countItems();
                    if (this.index < total) {
                        String fragment = "F" + StringUtils.leftPad((String)String.valueOf(this.index), (int)String.valueOf(total).length(), (char)'0') + "-";
                        return new Attachment(fragment + this.attachmentId, this.dicomElement.getFragment(this.index++), "DICOM");
                    }
                } else {
                    Attachment attachment = new Attachment(this.attachmentId, this.dicomElement.getBytes(), "DICOM");
                    this.dicomElement = null;
                    return attachment;
                }
            }
            return null;
        }
        catch (Throwable t) {
            throw new AttachmentException(t);
        }
    }

    public String shutdown() throws AttachmentException {
        try {
            byte[] encodedMessage = Base64Util.encodeBase64((byte[])DICOMConverter.dicomObjectToByteArray(this.dicomObject));
            this.dicomElement = null;
            this.dicomObject = null;
            return org.apache.commons.codec.binary.StringUtils.newStringUsAscii((byte[])encodedMessage);
        }
        catch (Throwable t) {
            throw new AttachmentException(t);
        }
    }
}

