/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.attachments.javascript;

import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.model.message.attachment.AttachmentException;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandler;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.server.attachments.javascript.JavaScriptAttachmentHandlerProvider;
import com.mirth.connect.server.util.javascript.JavaScriptExecutorException;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import java.util.ArrayList;
import java.util.List;

public class JavaScriptAttachmentHandler
implements AttachmentHandler {
    private JavaScriptAttachmentHandlerProvider provider;
    private String newMessage;
    private List<com.mirth.connect.server.userutil.Attachment> attachments;
    private int index;

    public JavaScriptAttachmentHandler(JavaScriptAttachmentHandlerProvider provider) {
        this.provider = provider;
    }

    public void initialize(RawMessage message, Channel channel) throws AttachmentException {
        this.index = 0;
        this.attachments = new ArrayList<com.mirth.connect.server.userutil.Attachment>();
        try {
            this.provider.showDebugger();
            this.newMessage = JavaScriptUtil.executeAttachmentScript(this.provider.getContextFactory(channel), message, channel.getChannelId(), channel.getName(), this.attachments);
        }
        catch (Throwable t) {
            if (t instanceof JavaScriptExecutorException) {
                t = t.getCause();
            }
            throw new AttachmentException("Error running javascript attachment handler script", t);
        }
    }

    public Attachment nextAttachment() {
        if (this.index < this.attachments.size()) {
            com.mirth.connect.server.userutil.Attachment attachment = this.attachments.get(this.index++);
            return new Attachment(attachment.getId(), attachment.getContent(), attachment.getType());
        }
        return null;
    }

    public String shutdown() {
        String finalMessage = this.newMessage;
        this.newMessage = null;
        this.attachments = null;
        return finalMessage;
    }
}

