/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.attachments.javascript;

import com.mirth.connect.donkey.model.message.attachment.AttachmentHandler;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProperties;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.server.MirthScopeProvider;
import com.mirth.connect.server.attachments.MirthAttachmentHandlerProvider;
import com.mirth.connect.server.attachments.javascript.JavaScriptAttachmentHandler;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.MessageController;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.tools.debugger.MirthMain;

public class JavaScriptAttachmentHandlerProvider
extends MirthAttachmentHandlerProvider {
    private Logger logger = LogManager.getLogger(this.getClass());
    private ContextFactoryController contextFactoryController = this.getContextFactoryController();
    private String scriptId;
    private Set<String> resourceIds;
    private volatile String contextFactoryId;
    private boolean debug = false;
    private MirthMain debugger;
    private MirthScopeProvider scopeProvider = new MirthScopeProvider();

    public JavaScriptAttachmentHandlerProvider() {
    }

    public JavaScriptAttachmentHandlerProvider(MessageController messageController) {
        super(messageController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MirthContextFactory getContextFactory(Channel channel) throws Exception {
        MirthContextFactory contextFactory;
        MirthContextFactory mirthContextFactory = contextFactory = this.debug ? this.contextFactoryController.getDebugContextFactory(channel.getResourceIds(), channel.getChannelId(), this.scriptId) : this.contextFactoryController.getContextFactory(this.resourceIds);
        if (!this.contextFactoryId.equals(contextFactory.getId())) {
            JavaScriptAttachmentHandlerProvider javaScriptAttachmentHandlerProvider = this;
            synchronized (javaScriptAttachmentHandlerProvider) {
                contextFactory = this.contextFactoryController.getContextFactory(this.resourceIds);
                if (!this.contextFactoryId.equals(contextFactory.getId())) {
                    JavaScriptUtil.recompileGeneratedScript(contextFactory, this.scriptId);
                    this.contextFactoryId = contextFactory.getId();
                }
            }
        }
        return contextFactory;
    }

    public void setProperties(Channel channel, AttachmentHandlerProperties attachmentProperties) {
        String attachmentScript = (String)attachmentProperties.getProperties().get("javascript.script");
        if (attachmentScript != null) {
            this.scriptId = ScriptController.getScriptId("Attachment", channel.getChannelId());
            try {
                MirthContextFactory contextFactory;
                this.debug = channel.getDebugOptions() != null && channel.getDebugOptions().isAttachmentBatchScripts();
                HashSet<String> scriptOptions = new HashSet<String>();
                scriptOptions.add("useAttachmentList");
                this.resourceIds = channel.getResourceIds();
                if (this.debug) {
                    contextFactory = this.contextFactoryController.getDebugContextFactory(channel.getResourceIds(), channel.getChannelId(), this.scriptId);
                    contextFactory.setContextType(ContextType.CHANNEL_ATTACHMENT);
                    contextFactory.setScriptText(attachmentScript);
                    contextFactory.setDebugType(true);
                    this.debugger = this.getDebugger(contextFactory, channel);
                } else {
                    contextFactory = this.contextFactoryController.getContextFactory(this.resourceIds);
                }
                this.contextFactoryId = contextFactory.getId();
                this.compileAndAddScript(channel, contextFactory, this.scriptId, attachmentScript, scriptOptions);
            }
            catch (Exception e) {
                this.logger.error("Error compiling attachment handler script " + this.scriptId + ".", (Throwable)e);
            }
        }
    }

    public boolean canExtractAttachments() {
        return true;
    }

    public byte[] replaceOutboundAttachment(byte[] content) throws Exception {
        return content;
    }

    public AttachmentHandler getHandler() {
        return new JavaScriptAttachmentHandler(this);
    }

    protected MirthMain getDebugger(MirthContextFactory contextFactory, Channel channel) {
        if (this.debug) {
            return JavaScriptUtil.getDebugger(contextFactory, this.scopeProvider, channel, this.scriptId, false);
        }
        return null;
    }

    protected void showDebugger() {
        if (this.debug && this.debugger != null && JavaScriptUtil.getCompiledScript(this.scriptId) != null) {
            this.debugger.doBreak();
            if (!this.debugger.isVisible()) {
                this.debugger.setVisible(true);
            }
        }
    }

    protected ContextFactoryController getContextFactoryController() {
        return ControllerFactory.getFactory().createContextFactoryController();
    }

    protected void compileAndAddScript(Channel channel, MirthContextFactory contextFactory, String scriptId, String attachmentScript, Set<String> scriptOptions) throws Exception {
        JavaScriptUtil.compileAndAddScript(channel.getChannelId(), contextFactory, scriptId, attachmentScript, ContextType.CHANNEL_ATTACHMENT, scriptOptions);
    }
}

