/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.attachments.regex;

import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.model.message.attachment.AttachmentException;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandler;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.donkey.util.Base64Util;
import com.mirth.connect.donkey.util.StringUtil;
import com.mirth.connect.server.attachments.regex.RegexAttachmentHandlerProvider;
import com.mirth.connect.server.util.ServerUUIDGenerator;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RegexAttachmentHandler
implements AttachmentHandler {
    private RegexAttachmentHandlerProvider provider;
    private int currentPattern;
    private Matcher matcher;
    private String message;
    private Map<String, Object> sourceMap;
    private StringBuilder newMessage;
    private int offset;
    private int group;

    public RegexAttachmentHandler(RegexAttachmentHandlerProvider provider) {
        this.provider = provider;
    }

    public void initialize(RawMessage message, Channel channel) throws AttachmentException {
        try {
            if (message.isBinary().booleanValue()) {
                String messageData = org.apache.commons.codec.binary.StringUtils.newStringUsAscii((byte[])Base64Util.encodeBase64((byte[])message.getRawBytes()));
                message.clearMessage();
                message = new RawMessage(messageData, message.getDestinationMetaDataIds(), message.getSourceMap());
            }
            this.message = message.getRawData();
            this.sourceMap = message.getSourceMap();
            this.newMessage = new StringBuilder();
            this.offset = 0;
            if (CollectionUtils.isNotEmpty(this.provider.getRegexInfo())) {
                this.currentPattern = 0;
                this.matcher = this.provider.getRegexInfo().get(this.currentPattern).getPattern().matcher(message.getRawData());
                this.group = this.matcher.groupCount();
            }
        }
        catch (Throwable t) {
            throw new AttachmentException(t);
        }
    }

    public Attachment nextAttachment() throws AttachmentException {
        try {
            if (this.matcher != null) {
                boolean done = false;
                while (!done) {
                    while (this.matcher.find()) {
                        String uuid = ServerUUIDGenerator.getUUID();
                        String attachmentString = this.message.substring(this.matcher.start(this.group), this.matcher.end(this.group));
                        for (Map.Entry<String, String> replacementEntry : this.provider.getInboundReplacements().entrySet()) {
                            String replaceKey = replacementEntry.getKey();
                            String replaceValue = replacementEntry.getValue();
                            if (replaceKey == null || replaceValue == null) continue;
                            replaceKey = this.provider.getReplacer().replaceValues(replaceKey, this.provider.getChannelId(), this.provider.getChannelName(), this.sourceMap);
                            replaceValue = this.provider.getReplacer().replaceValues(replaceValue, this.provider.getChannelId(), this.provider.getChannelName(), this.sourceMap);
                            attachmentString = attachmentString.replace(replaceKey, replaceValue);
                        }
                        this.newMessage.append(this.message.substring(this.offset, this.matcher.start(this.group)));
                        this.offset = this.matcher.end(this.group);
                        if (StringUtils.isNotBlank((CharSequence)attachmentString)) {
                            String mimeType = this.provider.getReplacer().replaceValues(this.provider.getRegexInfo().get(this.currentPattern).getMimeType(), this.provider.getChannelId(), this.provider.getChannelName(), this.sourceMap);
                            Attachment attachment = new Attachment(uuid, StringUtil.getBytesUncheckedChunked((String)attachmentString, (String)"UTF-8"), mimeType);
                            attachmentString = null;
                            this.newMessage.append(attachment.getAttachmentId());
                            return attachment;
                        }
                        this.newMessage.append(attachmentString);
                    }
                    if (this.currentPattern < this.provider.getRegexInfo().size() - 1) {
                        ++this.currentPattern;
                        this.newMessage.append(this.message.substring(this.offset));
                        this.message = this.newMessage.toString();
                        this.newMessage = new StringBuilder();
                        this.offset = 0;
                        this.matcher = this.provider.getRegexInfo().get(this.currentPattern).getPattern().matcher(this.message);
                        this.group = this.matcher.groupCount();
                        continue;
                    }
                    done = true;
                }
            }
            return null;
        }
        catch (Throwable t) {
            throw new AttachmentException(t);
        }
    }

    public String shutdown() throws AttachmentException {
        try {
            this.newMessage.append(this.message.substring(this.offset));
            this.matcher = null;
            this.message = null;
            String finalMessage = this.newMessage.toString();
            this.newMessage = null;
            return finalMessage;
        }
        catch (Throwable t) {
            throw new AttachmentException(t);
        }
    }
}

