/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.channel;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.util.MessageMaps;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.util.GlobalChannelVariableStore;
import com.mirth.connect.server.util.GlobalChannelVariableStoreFactory;
import com.mirth.connect.server.util.GlobalVariableStore;
import java.util.Map;

public class MirthMessageMaps
extends MessageMaps {
    private GlobalChannelVariableStore globalChannelMap;
    private GlobalVariableStore globalMap;
    private ConfigurationController configurationController;

    public MirthMessageMaps(String channelId) {
        this.globalChannelMap = GlobalChannelVariableStoreFactory.getInstance().get(channelId);
        this.globalMap = GlobalVariableStore.getInstance();
        this.configurationController = ConfigurationController.getInstance();
    }

    public Object get(String key, ConnectorMessage connectorMessage) {
        return this.get(key, connectorMessage, true);
    }

    public Object get(String key, ConnectorMessage connectorMessage, boolean includeResponseMap) {
        Object value = super.get(key, connectorMessage, includeResponseMap);
        if (value == null) {
            if (this.globalChannelMap != null && this.globalChannelMap.containsKey(key)) {
                value = this.globalChannelMap.get(key);
            } else if (this.globalMap != null && this.globalMap.containsKey(key)) {
                value = this.globalMap.get(key);
            } else {
                Map<String, String> configurationMap = this.configurationController.getConfigurationMap();
                if (configurationMap != null) {
                    value = configurationMap.get(key);
                }
            }
        }
        return value;
    }
}

