/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.client.core.ExtensionOperation;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.model.Auditable;
import com.mirth.connect.model.ExtensionPermission;
import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.server.controllers.ChannelAuthorizer;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;

public abstract class AuthorizationController {
    private EventController eventController;
    private ChannelController channelController;
    private String serverId;

    public AuthorizationController() {
        this(ControllerFactory.getFactory());
    }

    public AuthorizationController(ControllerFactory controllerFactory) {
        this.eventController = controllerFactory.createEventController();
        this.channelController = controllerFactory.createChannelController();
        this.serverId = controllerFactory.createConfigurationController().getServerId();
    }

    public abstract boolean isUserAuthorized(Integer var1, Operation var2, Map<String, Object> var3, String var4, boolean var5) throws ControllerException;

    public abstract void addExtensionPermission(ExtensionPermission var1);

    public abstract boolean doesUserHaveChannelRestrictions(Integer var1, Operation var2) throws ControllerException;

    public abstract ChannelAuthorizer getChannelAuthorizer(Integer var1, Operation var2) throws ControllerException;

    public abstract void usernameChanged(String var1, String var2) throws ControllerException;

    public void auditAuthorizationRequest(Integer userId, Operation operation, Map<String, Object> parameterMap, ServerEvent.Outcome outcome, String address) {
        if (operation != null && operation.isAuditable()) {
            Object displayName = operation.getDisplayName();
            if (operation instanceof ExtensionOperation) {
                displayName = (String)displayName + " invoked through " + ((ExtensionOperation)operation).getExtensionName();
            }
            ServerEvent serverEvent = new ServerEvent(this.serverId, (String)displayName);
            serverEvent.setLevel(ServerEvent.Level.INFORMATION);
            serverEvent.setUserId(userId);
            serverEvent.setOutcome(outcome);
            serverEvent.setIpAddress(address);
            if (MapUtils.isNotEmpty(parameterMap)) {
                for (Map.Entry<String, Object> entry : parameterMap.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (key.contains("channelId")) {
                        Set<String> collection = null;
                        if (value instanceof Set) {
                            collection = (Set<String>)value;
                        } else if (value instanceof String) {
                            collection = Collections.singleton((String)value);
                        }
                        if (collection == null) continue;
                        String[] channelIds = collection.toArray(new String[collection.size()]);
                        for (int i = 0; i < channelIds.length; ++i) {
                            Object name = "channel";
                            if (channelIds.length > 1) {
                                name = (String)name + "[" + i + "]";
                            }
                            value = this.channelController.getChannelById(channelIds[i]);
                            this.addAttribute(serverEvent.getAttributes(), (String)name, value);
                        }
                        continue;
                    }
                    this.addAttribute(serverEvent.getAttributes(), key, value);
                }
            }
            this.eventController.dispatchEvent(serverEvent);
        }
    }

    private void getAuditDescription(Object value, StringBuilder builder) {
        if (value instanceof Collection) {
            for (Object obj : (Collection)value) {
                this.getAuditDescription(obj, builder);
            }
        } else if (value instanceof Auditable) {
            builder.append(((Auditable)value).toAuditString() + "\n");
        } else if (value != null) {
            builder.append(value.toString() + "\n");
        }
    }

    private void addAttribute(Map<String, String> attributes, String name, Object value) {
        StringBuilder builder = new StringBuilder();
        this.getAuditDescription(value, builder);
        attributes.put(name, builder.toString());
    }
}

