/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.model.channel.Ports;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.channel.Statistics;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelGroup;
import com.mirth.connect.model.ChannelHeader;
import com.mirth.connect.model.ChannelSummary;
import com.mirth.connect.model.DeployedChannelInfo;
import com.mirth.connect.model.ServerEventContext;
import com.mirth.connect.server.controllers.Controller;
import com.mirth.connect.server.controllers.ControllerFactory;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ChannelController
extends Controller {
    private Logger logger = LogManager.getLogger(this.getClass());

    public static ChannelController getInstance() {
        return ControllerFactory.getFactory().createChannelController();
    }

    public abstract List<Channel> getChannels(Set<String> var1);

    public abstract Channel getChannelById(String var1);

    public abstract Channel getChannelByName(String var1);

    public abstract String getDestinationName(String var1, int var2);

    public abstract Set<String> getChannelIds();

    public abstract Set<String> getChannelNames();

    public abstract List<ChannelSummary> getChannelSummary(Map<String, ChannelHeader> var1, boolean var2) throws ControllerException;

    public abstract void setChannelEnabled(Set<String> var1, ServerEventContext var2, boolean var3) throws ControllerException;

    public abstract void setChannelInitialState(Set<String> var1, ServerEventContext var2, DeployedState var3) throws ControllerException;

    public abstract boolean updateChannel(Channel var1, ServerEventContext var2, boolean var3, Calendar var4) throws ControllerException;

    public abstract void removeChannel(Channel var1, ServerEventContext var2) throws ControllerException;

    public abstract Map<String, Integer> getChannelRevisions() throws ControllerException;

    public abstract Map<Integer, String> getConnectorNames(String var1);

    public abstract List<MetaDataColumn> getMetaDataColumns(String var1);

    public abstract void putDeployedChannelInCache(Channel var1);

    public abstract void removeDeployedChannelFromCache(String var1);

    public abstract Channel getDeployedChannelById(String var1);

    public abstract Channel getDeployedChannelByName(String var1);

    public abstract DeployedChannelInfo getDeployedChannelInfoById(String var1);

    public abstract String getDeployedDestinationName(String var1, int var2);

    public abstract Statistics getStatistics();

    public abstract Statistics getTotalStatistics();

    public abstract Statistics getStatisticsFromStorage(String var1);

    public abstract Statistics getTotalStatisticsFromStorage(String var1);

    public abstract int getConnectorMessageCount(String var1, String var2, int var3, Status var4);

    public abstract void resetStatistics(Map<String, List<Integer>> var1, Set<Status> var2);

    public abstract void resetAllStatistics();

    public abstract List<Channel> getDeployedChannels(Set<String> var1);

    public abstract List<ChannelGroup> getChannelGroups(Set<String> var1);

    public abstract boolean updateChannelGroups(Set<ChannelGroup> var1, Set<String> var2, boolean var3) throws ControllerException;

    public abstract List<Ports> getPortsInUse();
}

