/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.google.inject.Inject;
import com.mirth.connect.server.controllers.AlertController;
import com.mirth.connect.server.controllers.AuthorizationController;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.CodeTemplateController;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.DatabaseTaskController;
import com.mirth.connect.server.controllers.DebugUsageController;
import com.mirth.connect.server.controllers.DefaultControllerFactory;
import com.mirth.connect.server.controllers.EngineController;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.controllers.MessageController;
import com.mirth.connect.server.controllers.MigrationController;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.controllers.UsageController;
import com.mirth.connect.server.controllers.UserController;

public abstract class ControllerFactory {
    @Inject
    private static ControllerFactory factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ControllerFactory getFactory() {
        Class<ControllerFactory> clazz = ControllerFactory.class;
        synchronized (ControllerFactory.class) {
            if (factory == null) {
                factory = new DefaultControllerFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return factory;
        }
    }

    public abstract AuthorizationController createAuthorizationController();

    public abstract AlertController createAlertController();

    public abstract ChannelController createChannelController();

    public abstract CodeTemplateController createCodeTemplateController();

    public abstract ConfigurationController createConfigurationController();

    public abstract DebugUsageController createDebugUsageController();

    public abstract EngineController createEngineController();

    public abstract EventController createEventController();

    public abstract ExtensionController createExtensionController();

    public abstract MessageController createMessageController();

    public abstract MigrationController createMigrationController();

    public abstract ScriptController createScriptController();

    public abstract UsageController createUsageController();

    public abstract UserController createUserController();

    public abstract DatabaseTaskController createDatabaseTaskController();

    public abstract ContextFactoryController createContextFactoryController();
}

