/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.model.alert.AlertModel;
import com.mirth.connect.model.alert.AlertStatus;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.server.ExtensionLoader;
import com.mirth.connect.server.alert.Alert;
import com.mirth.connect.server.alert.AlertWorker;
import com.mirth.connect.server.alert.DefaultAlertWorker;
import com.mirth.connect.server.alert.action.ChannelProtocol;
import com.mirth.connect.server.alert.action.EmailProtocol;
import com.mirth.connect.server.alert.action.Protocol;
import com.mirth.connect.server.alert.action.UserProtocol;
import com.mirth.connect.server.controllers.AlertController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.util.DatabaseUtil;
import com.mirth.connect.server.util.SqlConfig;
import com.mirth.connect.server.util.StatementLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultAlertController
extends AlertController {
    public static final String VACUUM_LOCK_ALERT_STATEMENT_ID = "Alert.vacuumAlertTable";
    private Logger logger = LogManager.getLogger(this.getClass());
    private static AlertController instance = null;
    private static Map<Class<?>, AlertWorker> alertWorkers = new HashMap();
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private Map<String, Protocol> alertActionProtocols = new LinkedHashMap<String, Protocol>();

    protected DefaultAlertController() {
        this.addWorker(new DefaultAlertWorker());
        this.registerAlertActionProtocol(new EmailProtocol());
        this.registerAlertActionProtocol(new ChannelProtocol());
        this.registerAlertActionProtocol(new UserProtocol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AlertController create() {
        Class<DefaultAlertController> clazz = DefaultAlertController.class;
        synchronized (DefaultAlertController.class) {
            if (instance == null && (instance = ExtensionLoader.getInstance().getControllerInstance(AlertController.class)) == null) {
                instance = new DefaultAlertController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void initAlerts() {
        try {
            List<AlertModel> alertModels = this.getAlerts();
            for (AlertModel alertModel : alertModels) {
                if (!alertModel.isEnabled()) continue;
                this.enableAlert(alertModel);
            }
        }
        catch (ControllerException e) {
            this.logger.error("Failed to enable alerts on startup.", (Throwable)e);
        }
    }

    @Override
    public void addWorker(AlertWorker alertWorker) {
        alertWorkers.put(alertWorker.getTriggerClass(), alertWorker);
        this.eventController.addListener(alertWorker);
    }

    @Override
    public void removeAllWorkers() {
        for (AlertWorker worker : alertWorkers.values()) {
            this.eventController.removeListener(worker);
        }
        alertWorkers.clear();
    }

    @Override
    public List<AlertStatus> getAlertStatusList() throws ControllerException {
        ArrayList<AlertStatus> alertStatuses = new ArrayList<AlertStatus>();
        List<AlertModel> alertModels = this.getAlerts();
        for (AlertModel alertModel : alertModels) {
            AlertStatus alertStatus = this.getEnabledAlertStatus(alertModel.getId());
            if (alertStatus == null) {
                alertStatus = new AlertStatus();
            }
            alertStatus.setId(alertModel.getId());
            alertStatus.setName(alertModel.getName());
            alertStatus.setEnabled(alertModel.isEnabled());
            alertStatuses.add(alertStatus);
        }
        return alertStatuses;
    }

    private AlertStatus getEnabledAlertStatus(String alertId) {
        for (AlertWorker alertWorker : alertWorkers.values()) {
            AlertStatus alertStatus = alertWorker.getAlertStatus(alertId);
            if (alertStatus == null) continue;
            return alertStatus;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public AlertModel getAlert(String alertId) throws ControllerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<AlertModel> getAlerts() throws ControllerException {
        this.logger.trace("getting alert");
        StatementLock.getInstance(VACUUM_LOCK_ALERT_STATEMENT_ID).readLock();
        try {
            ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
            List rows = SqlConfig.getInstance().getReadOnlySqlSessionManager().selectList("Alert.getAlert", null);
            ArrayList<AlertModel> alerts = new ArrayList<AlertModel>();
            for (Map row : rows) {
                try {
                    alerts.add(serializer.deserialize((String)row.get("alert"), AlertModel.class));
                }
                catch (Exception e) {
                    this.logger.warn("Failed to load alert " + String.valueOf(row.get("id")), (Throwable)e);
                }
            }
            ArrayList<AlertModel> arrayList = alerts;
            return arrayList;
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_ALERT_STATEMENT_ID).readUnlock();
        }
    }

    @Override
    public void updateAlert(AlertModel alert) throws ControllerException {
        if (alert == null) {
            return;
        }
        StatementLock.getInstance(VACUUM_LOCK_ALERT_STATEMENT_ID).readLock();
        try {
            if (alert.getName() != null) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", alert.getId());
                params.put("name", alert.getName());
                if (((Boolean)SqlConfig.getInstance().getSqlSessionManager().selectOne("Alert.getAlertNameExists", params)).booleanValue()) {
                    throw new ControllerException("An alert with that name already exists.");
                }
            }
            ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
            boolean alertExists = CollectionUtils.isNotEmpty((Collection)SqlConfig.getInstance().getSqlSessionManager().selectList("Alert.getAlert", (Object)alert.getId()));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", alert.getId());
            params.put("name", alert.getName());
            params.put("alert", serializer.serialize(alert));
            if (alertExists) {
                this.disableAlert(alert.getId());
                this.logger.debug("updating alert");
                SqlConfig.getInstance().getSqlSessionManager().update("Alert.updateAlert", params);
            } else {
                this.logger.debug("adding alert");
                SqlConfig.getInstance().getSqlSessionManager().insert("Alert.insertAlert", params);
            }
            if (alert.isEnabled()) {
                this.enableAlert(alert);
            }
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_ALERT_STATEMENT_ID).readUnlock();
        }
    }

    @Override
    public void removeAlert(String alertId) throws ControllerException {
        this.logger.debug("removing alert");
        StatementLock.getInstance(VACUUM_LOCK_ALERT_STATEMENT_ID).writeLock();
        try {
            if (alertId != null) {
                this.disableAlert(alertId);
                SqlConfig.getInstance().getSqlSessionManager().delete("Alert.deleteAlert", (Object)alertId);
                if (DatabaseUtil.statementExists(VACUUM_LOCK_ALERT_STATEMENT_ID)) {
                    this.vacuumAlertTable();
                }
            }
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_ALERT_STATEMENT_ID).writeUnlock();
        }
    }

    public void vacuumAlertTable() {
        try (SqlSession session = null;){
            session = SqlConfig.getInstance().getSqlSessionManager().openSession(false);
            if (DatabaseUtil.statementExists("Alert.lockAlertTable")) {
                session.update("Alert.lockAlertTable");
            }
            session.update(VACUUM_LOCK_ALERT_STATEMENT_ID);
            session.commit();
        }
    }

    @Override
    public void enableAlert(AlertModel alert) throws ControllerException {
        Class<?> clazz = alert.getTrigger().getClass();
        if (alertWorkers.containsKey(clazz)) {
            alertWorkers.get(clazz).enableAlert(alert);
        } else {
            this.logger.error("Failed to enable alert " + alert.getId() + ". Worker class for trigger " + clazz.getName() + " not found.");
            alert.setEnabled(false);
            this.updateAlert(alert);
        }
    }

    @Override
    public void disableAlert(String alertId) throws ControllerException {
        for (AlertWorker worker : alertWorkers.values()) {
            worker.disableAlert(alertId);
        }
    }

    @Override
    public Alert getEnabledAlert(String alertId) {
        for (AlertWorker worker : alertWorkers.values()) {
            Alert alert = worker.getEnabledAlert(alertId);
            if (alert == null) continue;
            return alert;
        }
        return null;
    }

    @Override
    public Protocol getAlertActionProtocol(String protocolName) {
        return this.alertActionProtocols.get(protocolName);
    }

    @Override
    public void registerAlertActionProtocol(Protocol protocol) {
        this.alertActionProtocols.put(protocol.getName(), protocol);
    }

    @Override
    public Map<String, Map<String, String>> getAlertActionProtocolOptions() {
        LinkedHashMap<String, Map<String, String>> options = new LinkedHashMap<String, Map<String, String>>();
        for (String protocol : this.alertActionProtocols.keySet()) {
            options.put(protocol, this.alertActionProtocols.get(protocol).getRecipientOptions());
        }
        return options;
    }
}

