/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.model.channel.Ports;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.Donkey;
import com.mirth.connect.donkey.server.channel.Statistics;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelDependency;
import com.mirth.connect.model.ChannelExportData;
import com.mirth.connect.model.ChannelGroup;
import com.mirth.connect.model.ChannelHeader;
import com.mirth.connect.model.ChannelMetadata;
import com.mirth.connect.model.ChannelSummary;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.DeployedChannelInfo;
import com.mirth.connect.model.InvalidChannel;
import com.mirth.connect.model.ServerEventContext;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.plugins.ChannelPlugin;
import com.mirth.connect.server.ExtensionLoader;
import com.mirth.connect.server.controllers.Cache;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.CodeTemplateController;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.util.DatabaseUtil;
import com.mirth.connect.server.util.SqlConfig;
import com.mirth.connect.server.util.StatementLock;
import com.mirth.connect.server.util.TemplateValueReplacer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.ibatis.session.SqlSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultChannelController
extends ChannelController {
    public static final String VACUUM_LOCK_CHANNEL_STATEMENT_ID = "Channel.vacuumChannelTable";
    public static final String VACUUM_LOCK_CHANNEL_GROUP_STATEMENT_ID = "Channel.vacuumChannelGroupTable";
    private Logger logger = LogManager.getLogger(this.getClass());
    private ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();
    private CodeTemplateController codeTemplateController = ControllerFactory.getFactory().createCodeTemplateController();
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private ChannelCache channelCache = new ChannelCache();
    private DeployedChannelCache deployedChannelCache = new DeployedChannelCache();
    private Cache<ChannelGroup> channelGroupCache = new Cache("Channel Group", "Channel.getChannelGroupRevision", "Channel.getChannelGroup");
    private Donkey donkey;
    private static ChannelController instance = null;

    protected DefaultChannelController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChannelController create() {
        Class<DefaultChannelController> clazz = DefaultChannelController.class;
        synchronized (DefaultChannelController.class) {
            if (instance == null && (instance = ExtensionLoader.getInstance().getControllerInstance(ChannelController.class)) == null) {
                instance = new DefaultChannelController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public List<Channel> getChannels(Set<String> channelIds) {
        Map channelMap = this.channelCache.getAllItems();
        ArrayList<Channel> channels = new ArrayList<Channel>();
        if (channelIds == null) {
            channels.addAll(channelMap.values());
        } else {
            for (String channelId : channelIds) {
                if (channelMap.containsKey(channelId)) {
                    channels.add((Channel)channelMap.get(channelId));
                    continue;
                }
                this.logger.error("Cannot find channel, it may have been removed: " + channelId);
            }
        }
        return channels;
    }

    @Override
    public Channel getChannelById(String channelId) {
        return (Channel)this.channelCache.getCachedItemById(channelId);
    }

    @Override
    public Channel getChannelByName(String channelName) {
        return (Channel)this.channelCache.getCachedItemByName(channelName);
    }

    @Override
    public String getDestinationName(String channelId, int metaDataId) {
        return this.channelCache.getCachedDestinationName(channelId, metaDataId);
    }

    @Override
    public Set<String> getChannelIds() {
        return this.channelCache.getCachedIds();
    }

    @Override
    public Set<String> getChannelNames() {
        return this.channelCache.getCachedNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ChannelSummary> getChannelSummary(Map<String, ChannelHeader> clientChannels, boolean ignoreNewChannels) throws ControllerException {
        this.logger.debug("getting channel summary");
        ArrayList<ChannelSummary> channelSummaries = new ArrayList<ChannelSummary>();
        try {
            ChannelSummary summary;
            Map localChannelIds;
            HashMap<String, Channel> serverChannels = new HashMap<String, Channel>();
            List<Channel> channels = this.getChannels(ignoreNewChannels ? clientChannels.keySet() : null);
            for (Channel serverChannel : channels) {
                serverChannels.put(serverChannel.getId(), serverChannel);
            }
            if (this.donkey == null) {
                this.donkey = Donkey.getInstance();
            }
            try (DonkeyDao dao = this.donkey.getReadOnlyDaoFactory().getDao();){
                localChannelIds = dao.getLocalChannelIds();
            }
            List<CodeTemplateLibrary> codeTemplateLibraries = this.codeTemplateController.getLibraries(null, true);
            for (String cachedChannelId : clientChannels.keySet()) {
                summary = new ChannelSummary(cachedChannelId);
                boolean addSummary = false;
                if (localChannelIds != null) {
                    summary.getChannelStatus().setLocalChannelId((Long)localChannelIds.get(cachedChannelId));
                }
                if (serverChannels.containsKey(cachedChannelId)) {
                    boolean clientChannelDeployed;
                    DeployedChannelInfo deployedChannelInfo;
                    boolean channelOutdated;
                    ChannelHeader header = clientChannels.get(cachedChannelId);
                    Integer revision = ((Channel)serverChannels.get(cachedChannelId)).getRevision();
                    boolean bl = channelOutdated = !revision.equals(header.getRevision());
                    if (channelOutdated) {
                        summary.getChannelStatus().setChannel((Channel)serverChannels.get(cachedChannelId));
                        addSummary = true;
                    }
                    boolean serverChannelDeployed = (deployedChannelInfo = this.getDeployedChannelInfoById(cachedChannelId)) != null;
                    boolean bl2 = clientChannelDeployed = header.getDeployedDate() != null;
                    if (!serverChannelDeployed) {
                        if (clientChannelDeployed) {
                            summary.setUndeployed(true);
                            addSummary = true;
                        }
                    } else {
                        if (channelOutdated || !clientChannelDeployed || deployedChannelInfo.getDeployedDate().compareTo(header.getDeployedDate()) != 0) {
                            summary.getChannelStatus().setDeployedRevisionDelta(revision - deployedChannelInfo.getDeployedRevision());
                            summary.getChannelStatus().setDeployedDate(deployedChannelInfo.getDeployedDate());
                            addSummary = true;
                        }
                        summary.getChannelStatus().setCodeTemplatesChanged(!this.codeTemplateController.getCodeTemplateRevisionsForChannel(cachedChannelId, codeTemplateLibraries).equals(deployedChannelInfo.getCodeTemplateRevisions()));
                        if (summary.getChannelStatus().isCodeTemplatesChanged() != header.isCodeTemplatesChanged()) {
                            addSummary = true;
                        }
                    }
                } else {
                    summary.setDeleted(true);
                    addSummary = true;
                }
                if (!addSummary) continue;
                channelSummaries.add(summary);
            }
            for (String serverChannelId : serverChannels.keySet()) {
                boolean serverChannelDeployed;
                if (clientChannels.containsKey(serverChannelId)) continue;
                summary = new ChannelSummary(serverChannelId);
                summary.getChannelStatus().setChannel((Channel)serverChannels.get(serverChannelId));
                summary.getChannelStatus().setLocalChannelId(com.mirth.connect.donkey.server.controllers.ChannelController.getInstance().getLocalChannelId(serverChannelId, true));
                DeployedChannelInfo deployedChannelInfo = this.getDeployedChannelInfoById(serverChannelId);
                boolean bl = serverChannelDeployed = deployedChannelInfo != null;
                if (serverChannelDeployed) {
                    summary.getChannelStatus().setDeployedRevisionDelta(((Channel)serverChannels.get(serverChannelId)).getRevision() - deployedChannelInfo.getDeployedRevision());
                    summary.getChannelStatus().setDeployedDate(deployedChannelInfo.getDeployedDate());
                    if (!this.codeTemplateController.getCodeTemplateRevisionsForChannel(serverChannelId, codeTemplateLibraries).equals(deployedChannelInfo.getCodeTemplateRevisions())) {
                        summary.getChannelStatus().setCodeTemplatesChanged(true);
                    }
                }
                channelSummaries.add(summary);
            }
            return channelSummaries;
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
    }

    @Override
    public synchronized void setChannelEnabled(Set<String> channelIds, ServerEventContext context, boolean enabled) throws ControllerException {
        Map<String, ChannelMetadata> metadataMap = this.configurationController.getChannelMetadata();
        Map cachedChannelMap = this.channelCache.getAllItems();
        boolean changed = false;
        for (String channelId : channelIds) {
            Channel cachedChannel = (Channel)cachedChannelMap.get(channelId);
            ChannelMetadata metadata = metadataMap.get(channelId);
            if (cachedChannel == null || cachedChannel instanceof InvalidChannel || metadata != null && metadata.isEnabled() == enabled) continue;
            if (metadata == null) {
                metadata = new ChannelMetadata();
                metadataMap.put(channelId, metadata);
            }
            metadata.setEnabled(enabled);
            changed = true;
        }
        if (changed) {
            this.configurationController.setChannelMetadata(metadataMap);
        }
    }

    @Override
    public synchronized void setChannelInitialState(Set<String> channelIds, ServerEventContext context, DeployedState initialState) throws ControllerException {
        if (initialState != DeployedState.STARTED && initialState != DeployedState.PAUSED && initialState != DeployedState.STOPPED) {
            throw new ControllerException("Cannot set initial state to " + String.valueOf(initialState));
        }
        ControllerException firstCause = null;
        List<Channel> cachedChannels = this.getChannels(channelIds);
        StatementLock.getInstance(VACUUM_LOCK_CHANNEL_STATEMENT_ID).readLock();
        try {
            for (Channel cachedChannel : cachedChannels) {
                if (cachedChannel instanceof InvalidChannel || cachedChannel.getProperties().getInitialState() == initialState) continue;
                Channel channel = (Channel)SerializationUtils.clone((Serializable)cachedChannel);
                channel.getProperties().setInitialState(initialState);
                channel.setRevision(channel.getRevision() + 1);
                try {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("id", channel.getId());
                    params.put("name", channel.getName());
                    params.put("revision", channel.getRevision());
                    params.put("channel", channel);
                    this.logger.debug("updating channel");
                    SqlConfig.getInstance().getSqlSessionManager().update("Channel.updateChannel", params);
                    for (ChannelPlugin channelPlugin : this.extensionController.getChannelPlugins().values()) {
                        channelPlugin.save(channel, context);
                    }
                }
                catch (Exception e) {
                    if (firstCause != null) continue;
                    firstCause = new ControllerException((Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_CHANNEL_STATEMENT_ID).readUnlock();
        }
        if (firstCause != null) {
            throw firstCause;
        }
    }

    @Override
    public synchronized boolean updateChannel(Channel channel, ServerEventContext context, boolean override, Calendar dateStartEdit) throws ControllerException {
        ChannelExportData exportData = channel.getExportData();
        channel.clearExportData();
        Calendar lastModifiedDate = null;
        int newRevision = channel.getRevision();
        int currentRevision = 0;
        Channel matchingChannel = this.getChannelById(channel.getId());
        if (matchingChannel != null) {
            if (EqualsBuilder.reflectionEquals((Object)channel, (Object)matchingChannel, (String[])new String[]{"lastModified", "revision"})) {
                this.updateChannelMetadata(channel.getId(), exportData.getMetadata());
                this.updateChannelTags(channel.getId(), exportData.getChannelTags());
                return true;
            }
            currentRevision = matchingChannel.getRevision();
            channel.setNextMetaDataId(Math.max(matchingChannel.getNextMetaDataId(), channel.getNextMetaDataId()));
        }
        if (currentRevision > 0) {
            if (dateStartEdit == null) {
                dateStartEdit = Calendar.getInstance();
            }
            Map<String, ChannelMetadata> metadata = this.configurationController.getChannelMetadata();
            lastModifiedDate = metadata.get(channel.getId()).getLastModified();
        }
        if (currentRevision > 0 && !override && dateStartEdit.before(lastModifiedDate)) {
            return false;
        }
        channel.setRevision(currentRevision + 1);
        ArrayList<String> destConnectorNames = new ArrayList<String>(channel.getDestinationConnectors().size());
        for (Connector connector : channel.getDestinationConnectors()) {
            if (destConnectorNames.contains(connector.getName())) {
                throw new ControllerException("Destination connectors must have unique names");
            }
            destConnectorNames.add(connector.getName());
        }
        StatementLock.getInstance(VACUUM_LOCK_CHANNEL_STATEMENT_ID).readLock();
        try {
            matchingChannel = this.getChannelByName(channel.getName());
            if (matchingChannel != null && !channel.getId().equals(matchingChannel.getId())) {
                this.logger.error("There is already a channel with the name " + channel.getName());
                throw new ControllerException("A channel with that name already exists");
            }
            this.updateChannelMetadata(channel.getId(), exportData.getMetadata());
            this.updateChannelTags(channel.getId(), exportData.getChannelTags());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", channel.getId());
            params.put("name", channel.getName());
            params.put("revision", channel.getRevision());
            params.put("channel", channel);
            if (this.getChannelById(channel.getId()) == null) {
                this.logger.debug("adding channel");
                SqlConfig.getInstance().getSqlSessionManager().insert("Channel.insertChannel", params);
            } else {
                this.logger.debug("updating channel");
                SqlConfig.getInstance().getSqlSessionManager().update("Channel.updateChannel", params);
            }
            for (ChannelPlugin channelPlugin : this.extensionController.getChannelPlugins().values()) {
                channelPlugin.save(channel, context);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_CHANNEL_STATEMENT_ID).readUnlock();
        }
    }

    private void updateChannelMetadata(String channelId, ChannelMetadata metadata) {
        Map<String, ChannelMetadata> metadataMap = this.configurationController.getChannelMetadata();
        if (!Objects.equals(metadataMap.get(channelId), metadata)) {
            metadataMap.put(channelId, metadata);
            this.configurationController.setChannelMetadata(metadataMap);
        }
    }

    private void updateChannelTags(String channelId, List<ChannelTag> channelTags) {
        boolean updateTags = false;
        Set<ChannelTag> serverChannelTags = this.configurationController.getChannelTags();
        for (ChannelTag existingTag : serverChannelTags) {
            boolean found = false;
            Iterator<ChannelTag> it = channelTags.iterator();
            while (it.hasNext()) {
                ChannelTag tag = it.next();
                if (!existingTag.getId().equals(tag.getId()) && !existingTag.getName().equalsIgnoreCase(tag.getName())) continue;
                found = true;
                if (!existingTag.getChannelIds().contains(channelId)) {
                    updateTags = true;
                    existingTag.getChannelIds().add(channelId);
                }
                it.remove();
                break;
            }
            if (found || !existingTag.getChannelIds().contains(channelId)) continue;
            updateTags = true;
            existingTag.getChannelIds().remove(channelId);
        }
        for (ChannelTag tag : channelTags) {
            updateTags = true;
            serverChannelTags.add(tag);
        }
        if (updateTags) {
            this.configurationController.setChannelTags(serverChannelTags);
        }
    }

    @Override
    public synchronized void removeChannel(Channel channel, ServerEventContext context) throws ControllerException {
        this.logger.debug("removing channel");
        if (channel != null && ControllerFactory.getFactory().createEngineController().isDeployed(channel.getId())) {
            this.logger.warn("Cannot remove deployed channel.");
            return;
        }
        StatementLock.getInstance(VACUUM_LOCK_CHANNEL_STATEMENT_ID).writeLock();
        try {
            Map<String, ChannelMetadata> metadataMap;
            Iterator<Serializable> it;
            com.mirth.connect.donkey.server.controllers.ChannelController.getInstance().removeChannel(channel.getId());
            SqlConfig.getInstance().getSqlSessionManager().delete("Channel.deleteChannel", (Object)channel.getId());
            if (DatabaseUtil.statementExists(VACUUM_LOCK_CHANNEL_STATEMENT_ID)) {
                this.vacuumChannelTable();
            }
            HashSet<ChannelGroup> groups = new HashSet<ChannelGroup>(this.channelGroupCache.getAllItems().values());
            boolean groupsChanged = false;
            for (ChannelGroup group : groups) {
                it = group.getChannels().iterator();
                while (it.hasNext()) {
                    if (!channel.getId().equals(((Channel)it.next()).getId())) continue;
                    it.remove();
                    groupsChanged = true;
                }
            }
            if (groupsChanged) {
                this.updateChannelGroups(groups, new HashSet<String>(), true);
            }
            Set<ChannelDependency> dependencies = this.configurationController.getChannelDependencies();
            boolean dependenciesChanged = false;
            it = dependencies.iterator();
            while (it.hasNext()) {
                ChannelDependency dependency = (ChannelDependency)it.next();
                if (!channel.getId().equals(dependency.getDependentId()) && !channel.getId().equals(dependency.getDependencyId())) continue;
                it.remove();
                dependenciesChanged = true;
            }
            if (dependenciesChanged) {
                this.configurationController.setChannelDependencies(dependencies);
            }
            if ((metadataMap = this.configurationController.getChannelMetadata()).remove(channel.getId()) != null) {
                this.configurationController.setChannelMetadata(metadataMap);
            }
            boolean tagsRemoved = false;
            Set<ChannelTag> tags = this.configurationController.getChannelTags();
            for (ChannelTag tag : tags) {
                if (!tag.getChannelIds().contains(channel.getId())) continue;
                tagsRemoved = true;
                tag.getChannelIds().remove(channel.getId());
            }
            if (tagsRemoved) {
                this.configurationController.setChannelTags(tags);
            }
            for (ChannelPlugin channelPlugin : this.extensionController.getChannelPlugins().values()) {
                channelPlugin.remove(channel, context);
            }
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_CHANNEL_STATEMENT_ID).writeUnlock();
        }
    }

    public void vacuumChannelTable() {
        try (SqlSession session = null;){
            session = SqlConfig.getInstance().getSqlSessionManager().openSession(false);
            if (DatabaseUtil.statementExists("Channel.lockChannelTable")) {
                session.update("Channel.lockChannelTable");
            }
            session.update(VACUUM_LOCK_CHANNEL_STATEMENT_ID);
            session.commit();
        }
    }

    public void vacuumChannelGroupTable() {
        try (SqlSession session = null;){
            session = SqlConfig.getInstance().getSqlSessionManager().openSession(false);
            if (DatabaseUtil.statementExists("Channel.lockChannelGroupTable")) {
                session.update("Channel.lockChannelGroupTable");
            }
            session.update(VACUUM_LOCK_CHANNEL_GROUP_STATEMENT_ID);
            session.commit();
        }
    }

    @Override
    public Map<String, Integer> getChannelRevisions() throws ControllerException {
        StatementLock.getInstance(VACUUM_LOCK_CHANNEL_STATEMENT_ID).readLock();
        try {
            List results = SqlConfig.getInstance().getReadOnlySqlSessionManager().selectList("Channel.getChannelRevision");
            HashMap<String, Integer> channelRevisions = new HashMap<String, Integer>();
            for (Map result : results) {
                channelRevisions.put((String)result.get("id"), (Integer)result.get("revision"));
            }
            HashMap<String, Integer> hashMap = channelRevisions;
            return hashMap;
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_CHANNEL_STATEMENT_ID).readUnlock();
        }
    }

    @Override
    public Map<Integer, String> getConnectorNames(String channelId) {
        this.logger.debug("getting connector names");
        Channel channel = this.getChannelById(channelId);
        if (channel == null || channel instanceof InvalidChannel) {
            return null;
        }
        LinkedHashMap<Integer, String> connectorNames = new LinkedHashMap<Integer, String>();
        connectorNames.put(0, "Source");
        for (Connector connector : channel.getDestinationConnectors()) {
            connectorNames.put(connector.getMetaDataId(), connector.getName());
        }
        return connectorNames;
    }

    @Override
    public List<MetaDataColumn> getMetaDataColumns(String channelId) {
        this.logger.debug("getting metadata columns");
        Channel channel = this.getChannelById(channelId);
        if (channel == null || channel instanceof InvalidChannel) {
            return null;
        }
        return channel.getProperties().getMetaDataColumns();
    }

    @Override
    public void putDeployedChannelInCache(Channel channel) {
        this.deployedChannelCache.putDeployedChannelInCache(channel);
    }

    @Override
    public void removeDeployedChannelFromCache(String channelId) {
        this.deployedChannelCache.removeDeployedChannelFromCache(channelId);
    }

    @Override
    public Channel getDeployedChannelById(String channelId) {
        return this.deployedChannelCache.getDeployedChannelById(channelId);
    }

    @Override
    public Channel getDeployedChannelByName(String channelName) {
        return this.deployedChannelCache.getDeployedChannelByName(channelName);
    }

    @Override
    public DeployedChannelInfo getDeployedChannelInfoById(String channelId) {
        return this.deployedChannelCache.getDeployedChannelInfoById(channelId);
    }

    @Override
    public String getDeployedDestinationName(String channelId, int metaDataId) {
        return this.deployedChannelCache.getDeployedDestinationName(channelId, metaDataId);
    }

    @Override
    public Statistics getStatistics() {
        return com.mirth.connect.donkey.server.controllers.ChannelController.getInstance().getStatistics();
    }

    @Override
    public Statistics getTotalStatistics() {
        return com.mirth.connect.donkey.server.controllers.ChannelController.getInstance().getTotalStatistics();
    }

    @Override
    public Statistics getStatisticsFromStorage(String serverId) {
        return com.mirth.connect.donkey.server.controllers.ChannelController.getInstance().getStatisticsFromStorage(serverId);
    }

    @Override
    public Statistics getTotalStatisticsFromStorage(String serverId) {
        return com.mirth.connect.donkey.server.controllers.ChannelController.getInstance().getTotalStatisticsFromStorage(serverId);
    }

    @Override
    public int getConnectorMessageCount(String channelId, String serverId, int metaDataId, Status status) {
        return com.mirth.connect.donkey.server.controllers.ChannelController.getInstance().getConnectorMessageCount(channelId, serverId, metaDataId, status);
    }

    @Override
    public void resetStatistics(Map<String, List<Integer>> channelConnectorMap, Set<Status> statuses) {
        com.mirth.connect.donkey.server.controllers.ChannelController.getInstance().resetStatistics(channelConnectorMap, statuses);
    }

    @Override
    public void resetAllStatistics() {
        com.mirth.connect.donkey.server.controllers.ChannelController.getInstance().resetAllStatistics();
    }

    @Override
    public List<Channel> getDeployedChannels(Set<String> channelIds) {
        return this.deployedChannelCache.getDeployedChannels(channelIds);
    }

    @Override
    public List<ChannelGroup> getChannelGroups(Set<String> channelGroupIds) {
        Map<String, ChannelGroup> channelGroupMap = this.channelGroupCache.getAllItems();
        ArrayList<ChannelGroup> channelGroups = new ArrayList<ChannelGroup>();
        if (channelGroupIds == null) {
            channelGroups.addAll(channelGroupMap.values());
        } else {
            for (String groupId : channelGroupIds) {
                if (channelGroupMap.containsKey(groupId)) {
                    channelGroups.add(channelGroupMap.get(groupId));
                    continue;
                }
                this.logger.error("Cannot find channel group, it may have been removed: " + groupId);
            }
        }
        return channelGroups;
    }

    @Override
    public synchronized boolean updateChannelGroups(Set<ChannelGroup> channelGroups, Set<String> removedChannelGroupIds, boolean override) throws ControllerException {
        Map<String, ChannelGroup> channelGroupMap;
        if (!override) {
            channelGroupMap = this.channelGroupCache.getAllItems();
            for (ChannelGroup group : channelGroups) {
                ChannelGroup matchingGroup = channelGroupMap.get(group.getId());
                if (matchingGroup == null) continue;
                if (!EqualsBuilder.reflectionEquals((Object)group, (Object)matchingGroup, (String[])new String[]{"lastModified", "revision"}) && !group.getRevision().equals(matchingGroup.getRevision())) {
                    return false;
                }
                channelGroupMap.remove(group.getId());
            }
            for (String removedChannelGroupId : removedChannelGroupIds) {
                channelGroupMap.remove(removedChannelGroupId);
            }
            if (!channelGroupMap.isEmpty()) {
                return false;
            }
        }
        channelGroupMap = this.channelGroupCache.getAllItems();
        HashMap<String, String> channelIdMap = new HashMap<String, String>();
        ArrayList<ChannelGroup> groupsToRemove = new ArrayList<ChannelGroup>(channelGroupMap.values());
        HashSet<String> groupNames = new HashSet<String>();
        HashSet<String> unchangedGroupIds = new HashSet<String>();
        for (ChannelGroup group : channelGroups) {
            Object errorMessage;
            if (StringUtils.equals((CharSequence)group.getId(), (CharSequence)"Default Group") || StringUtils.equals((CharSequence)group.getName(), (CharSequence)"[Default Group]")) {
                errorMessage = "Channel groups cannot have the same ID or name as the default group.";
                this.logger.error((String)errorMessage);
                throw new ControllerException((String)errorMessage);
            }
            for (Channel channel : group.getChannels()) {
                if (channelIdMap.put(channel.getId(), group.getId()) == null) continue;
                String errorMessage2 = "Channel \"" + channel.getId() + "\" belongs to more than one group.";
                this.logger.error(errorMessage2);
                throw new ControllerException(errorMessage2);
            }
            group.replaceChannelsWithIds();
            if (!groupNames.add(group.getName())) {
                errorMessage = "There is already a channel group with the name " + group.getName();
                this.logger.error((String)errorMessage);
                throw new ControllerException((String)errorMessage);
            }
            ChannelGroup matchingGroup = channelGroupMap.get(group.getId());
            if (matchingGroup != null) {
                if (EqualsBuilder.reflectionEquals((Object)group, (Object)matchingGroup, (String[])new String[]{"lastModified", "revision"})) {
                    unchangedGroupIds.add(group.getId());
                } else {
                    if (!group.getRevision().equals(matchingGroup.getRevision()) && !override) {
                        return false;
                    }
                    group.setRevision(matchingGroup.getRevision() + 1);
                }
                groupsToRemove.remove(matchingGroup);
                continue;
            }
            group.setRevision(1);
        }
        StatementLock.getInstance(VACUUM_LOCK_CHANNEL_GROUP_STATEMENT_ID).readLock();
        try {
            for (ChannelGroup group : groupsToRemove) {
                SqlConfig.getInstance().getSqlSessionManager().delete("Channel.deleteChannelGroup", (Object)group.getId());
            }
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_CHANNEL_GROUP_STATEMENT_ID).readUnlock();
        }
        StatementLock.getInstance(VACUUM_LOCK_CHANNEL_GROUP_STATEMENT_ID).writeLock();
        try {
            if (DatabaseUtil.statementExists(VACUUM_LOCK_CHANNEL_GROUP_STATEMENT_ID)) {
                this.vacuumChannelGroupTable();
            }
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_CHANNEL_GROUP_STATEMENT_ID).writeUnlock();
        }
        StatementLock.getInstance(VACUUM_LOCK_CHANNEL_GROUP_STATEMENT_ID).readLock();
        try {
            for (ChannelGroup group : channelGroups) {
                if (unchangedGroupIds.contains(group.getId())) continue;
                group.setLastModified(Calendar.getInstance());
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", group.getId());
                params.put("name", group.getName());
                params.put("revision", group.getRevision());
                params.put("channelGroup", group);
                if (this.channelGroupCache.getCachedItemById(group.getId()) == null) {
                    this.logger.debug("Inserting channel group");
                    SqlConfig.getInstance().getSqlSessionManager().insert("Channel.insertChannelGroup", params);
                    continue;
                }
                this.logger.debug("Updating channel group");
                SqlConfig.getInstance().getSqlSessionManager().update("Channel.updateChannelGroup", params);
            }
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_CHANNEL_GROUP_STATEMENT_ID).readUnlock();
        }
        return true;
    }

    @Override
    public List<Ports> getPortsInUse() {
        this.logger.debug("getting ports in use");
        try {
            TemplateValueReplacer replacer = new TemplateValueReplacer();
            List portsList = com.mirth.connect.donkey.server.controllers.ChannelController.getInstance().getPortsInUse();
            for (Ports portsItem : portsList) {
                portsItem.setPort(replacer.replaceValues(portsItem.getPort(), portsItem.getId(), portsItem.getName()));
            }
            return portsList;
        }
        catch (Exception ex) {
            this.logger.error("getting ports in use: " + ex.toString());
            return null;
        }
    }

    private class ChannelCache
    extends Cache<Channel> {
        public ChannelCache() {
            super("Channel", "Channel.getChannelRevision", "Channel.getChannel");
        }

        private String getCachedDestinationName(String channelId, int metaDataId) {
            this.refreshCache();
            Channel channel = (Channel)this.cacheById.get(channelId);
            if (channel != null) {
                for (Connector connector : channel.getDestinationConnectors()) {
                    if (connector.getMetaDataId() != metaDataId) continue;
                    return connector.getName();
                }
            }
            return null;
        }
    }

    private class DeployedChannelCache {
        private Map<String, Channel> deployedChannelCacheById = new ConcurrentHashMap<String, Channel>();
        private Map<String, Channel> deployedChannelCacheByName = new ConcurrentHashMap<String, Channel>();
        private Map<String, DeployedChannelInfo> deployedChannelInfoCache = new ConcurrentHashMap<String, DeployedChannelInfo>();
        private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
        private Lock readLock = this.readWriteLock.readLock();
        private Lock writeLock = this.readWriteLock.writeLock();

        private DeployedChannelCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void putDeployedChannelInCache(Channel channel) {
            Map<String, Integer> codeTemplateRevisions = null;
            try {
                codeTemplateRevisions = DefaultChannelController.this.codeTemplateController.getCodeTemplateRevisionsForChannel(channel.getId());
            }
            catch (ControllerException controllerException) {
                // empty catch block
            }
            try {
                this.writeLock.lock();
                Channel oldDeployedChannel = (Channel)DefaultChannelController.this.channelCache.getCachedItemById(channel.getId());
                DeployedChannelInfo deployedChannelInfo = new DeployedChannelInfo();
                deployedChannelInfo.setDeployedDate(Calendar.getInstance());
                deployedChannelInfo.setDeployedRevision(channel.getRevision());
                deployedChannelInfo.setCodeTemplateRevisions(codeTemplateRevisions);
                this.deployedChannelInfoCache.put(channel.getId(), deployedChannelInfo);
                this.deployedChannelCacheById.put(channel.getId(), channel);
                this.deployedChannelCacheByName.put(channel.getName(), channel);
                if (oldDeployedChannel != null && !oldDeployedChannel.getName().equals(channel.getName())) {
                    this.deployedChannelCacheByName.remove(oldDeployedChannel.getName());
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }

        private void removeDeployedChannelFromCache(String channelId) {
            try {
                this.writeLock.lock();
                this.deployedChannelInfoCache.remove(channelId);
                String channelName = this.getDeployedChannelById(channelId).getName();
                this.deployedChannelCacheById.remove(channelId);
                this.deployedChannelCacheByName.remove(channelName);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        private Channel getDeployedChannelById(String channelId) {
            try {
                this.readLock.lock();
                Channel channel = this.deployedChannelCacheById.get(channelId);
                return channel;
            }
            finally {
                this.readLock.unlock();
            }
        }

        private Channel getDeployedChannelByName(String channelName) {
            try {
                this.readLock.lock();
                Channel channel = this.deployedChannelCacheByName.get(channelName);
                return channel;
            }
            finally {
                this.readLock.unlock();
            }
        }

        private DeployedChannelInfo getDeployedChannelInfoById(String channelId) {
            try {
                this.readLock.lock();
                DeployedChannelInfo deployedChannelInfo = this.deployedChannelInfoCache.get(channelId);
                return deployedChannelInfo;
            }
            finally {
                this.readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDeployedDestinationName(String channelId, int metaDataId) {
            try {
                this.readLock.lock();
                Channel channel = this.getDeployedChannelById(channelId);
                if (channel != null) {
                    for (Connector connector : channel.getDestinationConnectors()) {
                        if (connector.getMetaDataId() != metaDataId) continue;
                        String string = connector.getName();
                        return string;
                    }
                }
                Iterator<Connector> iterator = null;
                return iterator;
            }
            finally {
                this.readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Channel> getDeployedChannels(Set<String> channelIds) {
            try {
                this.readLock.lock();
                ArrayList<Channel> channels = new ArrayList<Channel>();
                if (channelIds == null) {
                    channels.addAll(this.deployedChannelCacheById.values());
                } else {
                    for (String channelId : channelIds) {
                        if (!this.deployedChannelCacheById.containsKey(channelId)) continue;
                        channels.add(this.deployedChannelCacheById.get(channelId));
                    }
                }
                ArrayList<Channel> arrayList = channels;
                return arrayList;
            }
            finally {
                this.readLock.unlock();
            }
        }
    }
}

