/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.model.ServerEventContext;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrarySaveResult;
import com.mirth.connect.model.codetemplates.CodeTemplateSummary;
import com.mirth.connect.plugins.CodeTemplateServerPlugin;
import com.mirth.connect.server.ExtensionLoader;
import com.mirth.connect.server.controllers.Cache;
import com.mirth.connect.server.controllers.CodeTemplateController;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.util.DatabaseUtil;
import com.mirth.connect.server.util.SqlConfig;
import com.mirth.connect.server.util.StatementLock;
import com.mirth.connect.util.JavaScriptSharedUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.ibatis.session.SqlSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;

public class DefaultCodeTemplateController
extends CodeTemplateController {
    private static CodeTemplateController instance = null;
    private static final String VACUUM_LOCK_CODE_TEMPLATE_STATEMENT_ID = "CodeTemplate.vacuumCodeTemplateTable";
    private static final String VACUUM_LOCK_LIBRARY_STATEMENT_ID = "CodeTemplate.vacuumLibraryTable";
    private Logger logger = LogManager.getLogger(this.getClass());
    private ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();
    private ScriptController scriptController = ControllerFactory.getFactory().createScriptController();
    private ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private Cache<CodeTemplateLibrary> libraryCache = new Cache("Code Template Library", "CodeTemplate.getLibraryRevision", "CodeTemplate.getLibrary");
    private Cache<CodeTemplate> codeTemplateCache = new Cache("Code Template", "CodeTemplate.getCodeTemplateRevision", "CodeTemplate.getCodeTemplate", false);

    private DefaultCodeTemplateController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeTemplateController create() {
        Class<DefaultCodeTemplateController> clazz = DefaultCodeTemplateController.class;
        synchronized (DefaultCodeTemplateController.class) {
            if (instance == null && (instance = ExtensionLoader.getInstance().getControllerInstance(CodeTemplateController.class)) == null) {
                instance = new DefaultCodeTemplateController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public List<CodeTemplateLibrary> getLibraries(Set<String> libraryIds, boolean includeCodeTemplates) throws ControllerException {
        this.logger.debug("Getting code template libraries, libraryIds=" + String.valueOf(libraryIds));
        libraryIds = CollectionUtils.isEmpty(libraryIds) ? null : new HashSet<String>(libraryIds);
        Map<String, CodeTemplateLibrary> libraryMap = this.libraryCache.getAllItems();
        ArrayList<CodeTemplateLibrary> libraries = new ArrayList<CodeTemplateLibrary>();
        Map<String, CodeTemplate> codeTemplateMap = this.codeTemplateCache.getAllItems();
        for (CodeTemplateLibrary library : libraryMap.values()) {
            if (libraryIds == null || libraryIds.contains(library.getId())) {
                this.addCodeTemplatesToLibrary(library, codeTemplateMap);
                if (!includeCodeTemplates) {
                    library.replaceCodeTemplatesWithIds();
                }
                libraries.add(library);
                if (libraryIds != null) {
                    libraryIds.remove(library.getId());
                }
            }
            for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                codeTemplateMap.remove(codeTemplate.getId());
            }
        }
        if (libraryIds != null) {
            for (String libraryId : libraryIds) {
                this.logger.warn("Cannot find code template library, it may have been removed: " + libraryId);
            }
        }
        return libraries;
    }

    private void addCodeTemplatesToLibrary(CodeTemplateLibrary library, Map<String, CodeTemplate> codeTemplateMap) {
        ArrayList<CodeTemplate> codeTemplates = new ArrayList<CodeTemplate>();
        for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
            if (codeTemplateMap.containsKey(codeTemplate.getId())) {
                codeTemplates.add(codeTemplateMap.get(codeTemplate.getId()));
                continue;
            }
            this.logger.warn("Cannot find code template, it may have been removed: " + codeTemplate.getId());
        }
        library.setCodeTemplates(codeTemplates);
        library.sortCodeTemplates();
    }

    @Override
    public CodeTemplateLibrary getLibraryById(String libraryId) throws ControllerException {
        return this.libraryCache.getCachedItemById(libraryId);
    }

    @Override
    public CodeTemplateLibrary getLibraryByName(String libraryName) throws ControllerException {
        return this.libraryCache.getCachedItemByName(libraryName);
    }

    @Override
    public synchronized boolean updateLibraries(List<CodeTemplateLibrary> libraries, ServerEventContext context, boolean override) throws ControllerException {
        Map<String, CodeTemplateLibrary> libraryMap = this.libraryCache.getAllItems();
        ArrayList<CodeTemplateLibrary> librariesToRemove = new ArrayList<CodeTemplateLibrary>(libraryMap.values());
        HashMap<String, String> codeTemplateMap = new HashMap<String, String>();
        HashSet<String> libraryNames = new HashSet<String>();
        HashSet<String> unchangedLibraryIds = new HashSet<String>();
        for (CodeTemplateLibrary library : libraries) {
            for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                if (codeTemplateMap.put(codeTemplate.getId(), library.getId()) == null) continue;
                String errorMessage = "Code Template \"" + codeTemplate.getName() + "\" belongs to more than one library.";
                this.logger.error(errorMessage);
                throw new ControllerException(errorMessage);
            }
            library.replaceCodeTemplatesWithIds();
            if (!libraryNames.add(library.getName())) {
                String errorMessage = "There is already a code template library with the name " + library.getName();
                this.logger.error(errorMessage);
                throw new ControllerException(errorMessage);
            }
            CodeTemplateLibrary matchingLibrary = libraryMap.get(library.getId());
            if (matchingLibrary != null) {
                if (EqualsBuilder.reflectionEquals((Object)library, (Object)matchingLibrary, (String[])new String[]{"lastModified", "revision"})) {
                    unchangedLibraryIds.add(library.getId());
                } else {
                    if (!library.getRevision().equals(matchingLibrary.getRevision()) && !override) {
                        return false;
                    }
                    library.setRevision(matchingLibrary.getRevision() + 1);
                }
                librariesToRemove.remove(matchingLibrary);
                continue;
            }
            library.setRevision(1);
        }
        StatementLock.getInstance(VACUUM_LOCK_LIBRARY_STATEMENT_ID).readLock();
        try {
            for (CodeTemplateLibrary library : librariesToRemove) {
                SqlConfig.getInstance().getSqlSessionManager().delete("CodeTemplate.deleteLibrary", (Object)library.getId());
                for (CodeTemplateServerPlugin codeTemplateServerPlugin : this.extensionController.getCodeTemplateServerPlugins().values()) {
                    codeTemplateServerPlugin.remove(library, context);
                }
            }
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_LIBRARY_STATEMENT_ID).readUnlock();
        }
        StatementLock.getInstance(VACUUM_LOCK_LIBRARY_STATEMENT_ID).writeLock();
        try {
            if (DatabaseUtil.statementExists(VACUUM_LOCK_LIBRARY_STATEMENT_ID)) {
                this.vacuumLibraryTable();
            }
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_LIBRARY_STATEMENT_ID).writeUnlock();
        }
        StatementLock.getInstance(VACUUM_LOCK_LIBRARY_STATEMENT_ID).readLock();
        try {
            for (CodeTemplateLibrary library : libraries) {
                if (unchangedLibraryIds.contains(library.getId())) continue;
                library.setLastModified(Calendar.getInstance());
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", library.getId());
                params.put("name", library.getName());
                params.put("revision", library.getRevision());
                params.put("library", library);
                if (this.getLibraryById(library.getId()) == null) {
                    this.logger.debug("Inserting code template library");
                    SqlConfig.getInstance().getSqlSessionManager().insert("CodeTemplate.insertLibrary", params);
                } else {
                    this.logger.debug("Updating code template library");
                    SqlConfig.getInstance().getSqlSessionManager().update("CodeTemplate.updateLibrary", params);
                }
                for (CodeTemplateServerPlugin codeTemplateServerPlugin : this.extensionController.getCodeTemplateServerPlugins().values()) {
                    codeTemplateServerPlugin.save(library, context);
                }
            }
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_LIBRARY_STATEMENT_ID).readUnlock();
        }
        return true;
    }

    public void vacuumLibraryTable() {
        try (SqlSession session = null;){
            session = SqlConfig.getInstance().getSqlSessionManager().openSession(false);
            if (DatabaseUtil.statementExists("CodeTemplate.lockLibraryTable")) {
                session.update("CodeTemplate.lockLibraryTable");
            }
            session.update(VACUUM_LOCK_LIBRARY_STATEMENT_ID);
            session.commit();
        }
    }

    public void vacuumCodeTemplateTable() {
        try (SqlSession session = null;){
            session = SqlConfig.getInstance().getSqlSessionManager().openSession(false);
            if (DatabaseUtil.statementExists("CodeTemplate.lockCodeTemplateTable")) {
                session.update("CodeTemplate.lockCodeTemplateTable");
            }
            session.update(VACUUM_LOCK_CODE_TEMPLATE_STATEMENT_ID);
            session.commit();
        }
    }

    @Override
    public List<CodeTemplate> getCodeTemplates(Set<String> codeTemplateIds) throws ControllerException {
        this.logger.debug("Getting code templates, codeTemplateIds=" + String.valueOf(codeTemplateIds));
        if (CollectionUtils.isEmpty(codeTemplateIds)) {
            codeTemplateIds = null;
        }
        Map<String, CodeTemplate> codeTemplateMap = this.codeTemplateCache.getAllItems();
        ArrayList<CodeTemplate> codeTemplates = new ArrayList<CodeTemplate>();
        if (codeTemplateIds == null) {
            codeTemplates.addAll(codeTemplateMap.values());
        } else {
            for (String codeTemplateId : codeTemplateIds) {
                CodeTemplate codeTemplate = codeTemplateMap.get(codeTemplateId);
                if (codeTemplate == null) {
                    this.logger.error("Cannot find code template, it may have been removed: " + codeTemplateId);
                    continue;
                }
                codeTemplates.add(codeTemplate);
            }
        }
        return codeTemplates;
    }

    @Override
    public List<CodeTemplateSummary> getCodeTemplateSummary(Map<String, Integer> clientRevisions) throws ControllerException {
        this.logger.debug("Getting code template summary");
        ArrayList<CodeTemplateSummary> codeTemplateSummaries = new ArrayList<CodeTemplateSummary>();
        try {
            Map<String, CodeTemplate> serverCodeTemplates = this.codeTemplateCache.getAllItems();
            for (Map.Entry<String, Integer> entry : clientRevisions.entrySet()) {
                String cachedCodeTemplateId = entry.getKey();
                CodeTemplateSummary summary = new CodeTemplateSummary(cachedCodeTemplateId);
                boolean addSummary = false;
                if (serverCodeTemplates.containsKey(cachedCodeTemplateId)) {
                    CodeTemplate serverCodeTemplate = serverCodeTemplates.get(cachedCodeTemplateId);
                    Integer serverRevision = serverCodeTemplate.getRevision();
                    if (!serverRevision.equals(entry.getValue())) {
                        summary.setCodeTemplate(serverCodeTemplate);
                        addSummary = true;
                    }
                } else {
                    summary.setDeleted(true);
                    addSummary = true;
                }
                if (!addSummary) continue;
                codeTemplateSummaries.add(summary);
            }
            for (Map.Entry<String, Serializable> entry : serverCodeTemplates.entrySet()) {
                if (clientRevisions.containsKey(entry.getKey())) continue;
                codeTemplateSummaries.add(new CodeTemplateSummary(entry.getKey(), (CodeTemplate)entry.getValue()));
            }
            return codeTemplateSummaries;
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
    }

    @Override
    public CodeTemplate getCodeTemplateById(String codeTemplateId) throws ControllerException {
        return this.codeTemplateCache.getCachedItemById(codeTemplateId);
    }

    @Override
    public Map<String, Integer> getCodeTemplateRevisionsForChannel(String channelId) throws ControllerException {
        return this.getCodeTemplateRevisionsForChannel(channelId, this.getLibraries(null, true));
    }

    @Override
    public Map<String, Integer> getCodeTemplateRevisionsForChannel(String channelId, List<CodeTemplateLibrary> libraries) throws ControllerException {
        HashMap<String, Integer> revisions = new HashMap<String, Integer>();
        if (libraries != null) {
            for (CodeTemplateLibrary library : libraries) {
                if (!library.getEnabledChannelIds().contains(channelId) && (!library.isIncludeNewChannels() || library.getDisabledChannelIds().contains(channelId))) continue;
                for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                    if (!codeTemplate.isAddToScripts()) continue;
                    revisions.put(codeTemplate.getId(), codeTemplate.getRevision());
                }
            }
        }
        return revisions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean updateCodeTemplate(CodeTemplate codeTemplate, ServerEventContext context, boolean override) throws ControllerException {
        CodeTemplate matchingCodeTemplate = this.getCodeTemplateById(codeTemplate.getId());
        int currentRevision = 0;
        if (matchingCodeTemplate != null) {
            if (EqualsBuilder.reflectionEquals((Object)codeTemplate, (Object)matchingCodeTemplate, (String[])new String[]{"lastModified", "revision"})) {
                return true;
            }
            currentRevision = matchingCodeTemplate.getRevision();
        }
        if (currentRevision > 0 && currentRevision != codeTemplate.getRevision() && !override) {
            return false;
        }
        codeTemplate.setRevision(currentRevision + 1);
        StatementLock.getInstance(VACUUM_LOCK_CODE_TEMPLATE_STATEMENT_ID).readLock();
        try {
            for (CodeTemplateLibrary library : this.getLibraries(null, true)) {
                HashSet<String> codeTemplateNames = new HashSet<String>();
                boolean found = false;
                for (CodeTemplate template : library.getCodeTemplates()) {
                    if (template.getId().equals(codeTemplate.getId())) {
                        found = true;
                        continue;
                    }
                    codeTemplateNames.add(template.getName());
                }
                if (!found || !codeTemplateNames.contains(codeTemplate.getName())) continue;
                String errorMessage = "There is already a code template with the name " + codeTemplate.getName();
                this.logger.error(errorMessage);
                throw new ControllerException(errorMessage);
            }
            Object validationMessage = null;
            Throwable validationCause = null;
            try {
                JavaScriptSharedUtil.getGlobalContextForValidation().compileString("function rhinoWrapper() {" + codeTemplate.getCode() + "\n}", UUID.randomUUID().toString(), 1, null);
            }
            catch (EvaluatorException e) {
                validationMessage = "Error on line " + e.lineNumber() + ": " + e.getMessage() + ".";
                validationCause = e;
            }
            catch (Exception e) {
                validationMessage = "Unknown error occurred during validation.";
                validationCause = e;
            }
            finally {
                Context.exit();
            }
            if (validationMessage != null) {
                String errorMessage = "Unable to save code template \"" + codeTemplate.getName() + "\": " + (String)validationMessage;
                this.logger.error(errorMessage, validationCause);
                throw new ControllerException(errorMessage, validationCause);
            }
            codeTemplate.setLastModified(Calendar.getInstance());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", codeTemplate.getId());
            params.put("name", codeTemplate.getName());
            params.put("revision", codeTemplate.getRevision());
            params.put("codeTemplate", codeTemplate);
            if (this.getCodeTemplateById(codeTemplate.getId()) == null) {
                this.logger.debug("Inserting code template");
                SqlConfig.getInstance().getSqlSessionManager().insert("CodeTemplate.insertCodeTemplate", params);
            } else {
                this.logger.debug("Updating code template");
                SqlConfig.getInstance().getSqlSessionManager().update("CodeTemplate.updateCodeTemplate", params);
            }
            for (CodeTemplateServerPlugin codeTemplateServerPlugin : this.extensionController.getCodeTemplateServerPlugins().values()) {
                codeTemplateServerPlugin.save(codeTemplate, context);
            }
            this.scriptController.compileGlobalScripts(this.contextFactoryController.getGlobalScriptContextFactory(), true);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (e instanceof ControllerException) {
                throw (ControllerException)((Object)e);
            }
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_CODE_TEMPLATE_STATEMENT_ID).readUnlock();
        }
    }

    @Override
    public synchronized void removeCodeTemplate(String codeTemplateId, ServerEventContext context) throws ControllerException {
        CodeTemplate codeTemplate = this.getCodeTemplateById(codeTemplateId);
        if (codeTemplate == null) {
            return;
        }
        StatementLock.getInstance(VACUUM_LOCK_CODE_TEMPLATE_STATEMENT_ID).writeLock();
        try {
            SqlConfig.getInstance().getSqlSessionManager().delete("CodeTemplate.deleteCodeTemplate", (Object)codeTemplate.getId());
            if (DatabaseUtil.statementExists(VACUUM_LOCK_CODE_TEMPLATE_STATEMENT_ID)) {
                this.vacuumCodeTemplateTable();
            }
            for (CodeTemplateServerPlugin codeTemplateServerPlugin : this.extensionController.getCodeTemplateServerPlugins().values()) {
                codeTemplateServerPlugin.remove(codeTemplate, context);
            }
            this.scriptController.compileGlobalScripts(this.contextFactoryController.getGlobalScriptContextFactory(), true);
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_CODE_TEMPLATE_STATEMENT_ID).writeUnlock();
        }
        ArrayList<CodeTemplateLibrary> libraries = new ArrayList<CodeTemplateLibrary>(this.libraryCache.getAllItems().values());
        boolean changed = false;
        for (CodeTemplateLibrary library : libraries) {
            Iterator<CodeTemplate> it = library.getCodeTemplates().iterator();
            while (it.hasNext()) {
                if (!it.next().getId().equals(codeTemplate.getId())) continue;
                it.remove();
                changed = true;
            }
        }
        if (changed) {
            this.updateLibraries(libraries, context, true);
        }
    }

    @Override
    public synchronized CodeTemplateLibrarySaveResult updateLibrariesAndTemplates(List<CodeTemplateLibrary> libraries, Set<String> removedLibraryIds, List<CodeTemplate> updatedCodeTemplates, Set<String> removedCodeTemplateIds, ServerEventContext context, boolean override) {
        Serializable result;
        if (!override) {
            Map<String, CodeTemplateLibrary> libraryMap = this.libraryCache.getAllItems();
            for (CodeTemplateLibrary codeTemplateLibrary : libraries) {
                CodeTemplateLibrary matchingLibrary = libraryMap.get(codeTemplateLibrary.getId());
                if (matchingLibrary == null) continue;
                if (!EqualsBuilder.reflectionEquals((Object)codeTemplateLibrary, (Object)matchingLibrary, (String[])new String[]{"lastModified", "revision"}) && !codeTemplateLibrary.getRevision().equals(matchingLibrary.getRevision())) {
                    return new CodeTemplateLibrarySaveResult(true);
                }
                libraryMap.remove(codeTemplateLibrary.getId());
            }
            for (String string : removedLibraryIds) {
                libraryMap.remove(string);
            }
            if (!libraryMap.isEmpty()) {
                return new CodeTemplateLibrarySaveResult(true);
            }
            Map<String, CodeTemplate> codeTemplateMap = this.codeTemplateCache.getAllItems();
            for (CodeTemplate codeTemplate : updatedCodeTemplates) {
                CodeTemplate matchingCodeTemplate = (CodeTemplate)codeTemplateMap.get(codeTemplate.getId());
                if (matchingCodeTemplate == null || EqualsBuilder.reflectionEquals((Object)codeTemplate, (Object)matchingCodeTemplate, (String[])new String[]{"lastModified", "revision"}) || matchingCodeTemplate.getRevision().equals(codeTemplate.getRevision())) continue;
                return new CodeTemplateLibrarySaveResult(true);
            }
        }
        CodeTemplateLibrarySaveResult updateSummary = new CodeTemplateLibrarySaveResult();
        try {
            updateSummary.setLibrariesSuccess(this.updateLibraries(libraries, context, override));
            for (CodeTemplateLibrary codeTemplateLibrary : libraries) {
                result = new CodeTemplateLibrarySaveResult.LibraryUpdateResult();
                ((CodeTemplateLibrarySaveResult.LibraryUpdateResult)result).setNewRevision(codeTemplateLibrary.getRevision());
                ((CodeTemplateLibrarySaveResult.LibraryUpdateResult)result).setNewLastModified(codeTemplateLibrary.getLastModified());
                updateSummary.getLibraryResults().put(codeTemplateLibrary.getId(), (CodeTemplateLibrarySaveResult.LibraryUpdateResult)result);
            }
        }
        catch (Throwable t) {
            updateSummary.setLibrariesSuccess(false);
            updateSummary.setLibrariesCause(this.convertUpdateCause(t));
            return updateSummary;
        }
        for (CodeTemplate codeTemplate : updatedCodeTemplates) {
            result = new CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult();
            try {
                ((CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult)result).setSuccess(this.updateCodeTemplate(codeTemplate, context, override));
                ((CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult)result).setNewRevision(codeTemplate.getRevision());
                ((CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult)result).setNewLastModified(codeTemplate.getLastModified());
            }
            catch (Throwable t) {
                ((CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult)result).setSuccess(false);
                ((CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult)result).setCause(this.convertUpdateCause(t));
            }
            updateSummary.getCodeTemplateResults().put(codeTemplate.getId(), (CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult)result);
        }
        for (String string : removedCodeTemplateIds) {
            result = new CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult();
            try {
                this.removeCodeTemplate(string, context);
                ((CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult)result).setSuccess(true);
            }
            catch (Throwable t) {
                ((CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult)result).setSuccess(false);
                ((CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult)result).setCause(this.convertUpdateCause(t));
            }
            updateSummary.getCodeTemplateResults().put(string, (CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult)result);
        }
        return updateSummary;
    }

    private Throwable convertUpdateCause(Throwable t) {
        if (t instanceof ControllerException) {
            if (t.getCause() != null) {
                t = t.getCause();
            } else {
                StackTraceElement[] stackTrace = t.getStackTrace();
                t = new Exception(t.getMessage());
                t.setStackTrace(stackTrace);
            }
        }
        return t;
    }
}

