/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.connect.model.LibraryProperties;
import com.mirth.connect.plugins.LibraryPlugin;
import com.mirth.connect.server.ExtensionLoader;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.ContextFactory;

public class DefaultContextFactoryController
extends ContextFactoryController {
    private Logger logger = LogManager.getLogger(this.getClass());
    private ExtensionController extensionController;
    private Map<String, LibraryProperties> libraryResources = new ConcurrentHashMap<String, LibraryProperties>();
    private Map<String, List<URL>> libraryCache = new ConcurrentHashMap<String, List<URL>>();
    private volatile Set<String> globalScriptResourceIds = new LinkedHashSet<String>();
    private Map<Set<String>, MirthContextFactory> contextFactoryMap = new ConcurrentHashMap<Set<String>, MirthContextFactory>();
    private Map<Set<String>, MirthContextFactory> debugContextFactoryMap = new ConcurrentHashMap<Set<String>, MirthContextFactory>();
    private static ContextFactoryController instance = null;

    public DefaultContextFactoryController() {
        this.extensionController = ControllerFactory.getFactory().createExtensionController();
    }

    protected DefaultContextFactoryController(ExtensionController extensionController) {
        this.extensionController = extensionController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContextFactoryController create() {
        Class<DefaultContextFactoryController> clazz = DefaultContextFactoryController.class;
        synchronized (DefaultContextFactoryController.class) {
            if (instance == null && (instance = ExtensionLoader.getInstance().getControllerInstance(ContextFactoryController.class)) == null) {
                instance = new DefaultContextFactoryController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContextFactoryController create(ExtensionController extensionController) {
        Class<DefaultContextFactoryController> clazz = DefaultContextFactoryController.class;
        synchronized (DefaultContextFactoryController.class) {
            if (instance == null) {
                instance = new DefaultContextFactoryController(extensionController);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public synchronized void initGlobalContextFactory() {
        this.logger.debug("Initializing global context factory.");
        ContextFactory.initGlobal((ContextFactory)new MirthContextFactory(new URL[0], new HashSet<String>(), false));
    }

    @Override
    public synchronized void updateResources(List<LibraryProperties> resources, boolean startup) throws Exception {
        this.logger.debug("Updating resources: " + String.valueOf(resources));
        HashSet<String> resourceIds = new HashSet<String>();
        HashSet<String> resourceIdsToReload = new HashSet<String>();
        HashSet<String> globalScriptResourceIds = new HashSet<String>();
        for (LibraryProperties resource : resources) {
            resourceIds.add(resource.getId());
            LibraryProperties currentResource = this.libraryResources.get(resource.getId());
            if (!resource.equals(currentResource)) {
                if (!EqualsBuilder.reflectionEquals((Object)resource, (Object)currentResource, (String[])new String[]{"name", "description", "includeWithGlobalScripts"})) {
                    this.logger.debug("Resource " + String.valueOf(resource) + " has changed (besides name / description / global scripts).");
                    resourceIdsToReload.add(resource.getId());
                } else {
                    this.logger.debug("Resource " + String.valueOf(resource) + " has changed.");
                }
                LibraryPlugin plugin = (LibraryPlugin)this.extensionController.getResourcePlugins().get(resource.getPluginPointName());
                if (plugin != null) {
                    try {
                        plugin.update(resource, startup);
                    }
                    catch (Exception e) {
                        this.logger.warn("Unable to update libraries: " + e.getMessage(), (Throwable)e);
                    }
                } else {
                    this.logger.error("Unable to update libraries: Plugin \"" + resource.getPluginPointName() + "\" not found.");
                }
                this.libraryResources.put(resource.getId(), resource);
            }
            if (!resource.isIncludeWithGlobalScripts()) continue;
            globalScriptResourceIds.add(resource.getId());
        }
        for (LibraryProperties resource : this.libraryResources.values().toArray(new LibraryProperties[this.libraryResources.size()])) {
            if (resourceIds.contains(resource.getId())) continue;
            this.logger.debug("Removing resource " + String.valueOf(resource) + ".");
            resourceIdsToReload.add(resource.getId());
            this.libraryResources.remove(resource.getId());
            LibraryPlugin plugin = (LibraryPlugin)this.extensionController.getResourcePlugins().get(resource.getPluginPointName());
            if (plugin != null) {
                try {
                    plugin.remove(resource);
                }
                catch (Exception e) {
                    this.logger.warn("Unable to remove library resource: " + e.getMessage(), (Throwable)e);
                }
                continue;
            }
            this.logger.error("Unable to remove library resource: Plugin \"" + resource.getPluginPointName() + "\" not found.");
        }
        if (!this.globalScriptResourceIds.equals(globalScriptResourceIds)) {
            this.logger.debug("Global script resource IDs have changed: " + String.valueOf(globalScriptResourceIds));
            this.globalScriptResourceIds = globalScriptResourceIds;
        }
        this.reloadResources(resourceIdsToReload, startup);
    }

    @Override
    public MirthContextFactory getGlobalContextFactory() {
        return (MirthContextFactory)ContextFactory.getGlobal();
    }

    @Override
    public MirthContextFactory getGlobalScriptContextFactory() throws Exception {
        return this.getContextFactory(this.globalScriptResourceIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MirthContextFactory getContextFactory(Set<String> libraryResourceIds) throws Exception {
        if (CollectionUtils.isNotEmpty(libraryResourceIds)) {
            libraryResourceIds = new LinkedHashSet<String>(libraryResourceIds);
            this.redactResourceIds(libraryResourceIds);
            MirthContextFactory contextFactory = this.contextFactoryMap.get(libraryResourceIds);
            if (contextFactory == null) {
                Map<Set<String>, MirthContextFactory> map = this.contextFactoryMap;
                synchronized (map) {
                    contextFactory = this.contextFactoryMap.get(libraryResourceIds);
                    if (contextFactory == null) {
                        this.resetContextFactory(libraryResourceIds, false);
                        contextFactory = this.contextFactoryMap.get(libraryResourceIds);
                    }
                }
            }
            return contextFactory;
        }
        return this.getGlobalContextFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MirthContextFactory getDebugContextFactory(Set<String> libraryResourceIds, String channelId, String scriptId) throws Exception {
        Set<String> key = this.getDebugContextFactoryMapKey(libraryResourceIds, channelId, scriptId);
        MirthContextFactory contextFactory = this.debugContextFactoryMap.get(key);
        if (contextFactory == null) {
            Map<Set<String>, MirthContextFactory> map = this.debugContextFactoryMap;
            synchronized (map) {
                contextFactory = this.debugContextFactoryMap.get(key);
                if (contextFactory == null) {
                    libraryResourceIds = new LinkedHashSet<String>(libraryResourceIds);
                    this.redactResourceIds(libraryResourceIds);
                    List<URL> libraries = this.getLibraries(libraryResourceIds, false, false);
                    contextFactory = new MirthContextFactory(libraries.toArray(new URL[libraries.size()]), new HashSet<String>(), this.loadParentFirst(libraryResourceIds));
                    this.debugContextFactoryMap.put(key, contextFactory);
                }
            }
        }
        return contextFactory;
    }

    @Override
    public void removeDebugContextFactory(Set<String> libraryResourceIds, String channelId, String scriptId) {
        Set<String> key = this.getDebugContextFactoryMapKey(libraryResourceIds, channelId, scriptId);
        this.debugContextFactoryMap.remove(key);
    }

    private Set<String> getDebugContextFactoryMapKey(Set<String> libraryResourceIds, String channelId, String scriptId) {
        Objects.requireNonNull(channelId);
        if (libraryResourceIds == null) {
            libraryResourceIds = new HashSet<String>();
        }
        HashSet<String> key = new HashSet<String>(libraryResourceIds);
        key.add(channelId);
        key.add(scriptId);
        return key;
    }

    @Override
    public void reloadResource(String resourceId) throws Exception {
        this.reloadResources(new HashSet<String>(Collections.singleton(resourceId)), false);
    }

    @Override
    public List<URL> getLibraries(String resourceId) throws Exception {
        return this.getLibraries(new HashSet<String>(Collections.singleton(resourceId)), false, false);
    }

    private void reloadResources(Set<String> resourceIds, boolean startup) throws Exception {
        for (String resourceId : resourceIds) {
            this.getLibraries(new HashSet<String>(Collections.singleton(resourceId)), true, startup);
        }
        for (Set libraryResourceIds : this.contextFactoryMap.keySet().toArray(new Set[this.contextFactoryMap.size()])) {
            MirthContextFactory contextFactory;
            LinkedHashSet intersection = new LinkedHashSet(libraryResourceIds);
            if (resourceIds != null) {
                intersection.retainAll(resourceIds);
            }
            if (!CollectionUtils.isNotEmpty(intersection) || (contextFactory = this.contextFactoryMap.get(libraryResourceIds)) == null) continue;
            this.resetContextFactory(libraryResourceIds, startup);
        }
    }

    private void resetContextFactory(Set<String> libraryResourceIds, boolean startup) throws Exception {
        this.logger.debug("Resetting context factory: libraryResourceIds=" + String.valueOf(libraryResourceIds));
        List<URL> libraries = this.getLibraries(libraryResourceIds, false, startup);
        MirthContextFactory contextFactory = CollectionUtils.isNotEmpty(libraries) ? new MirthContextFactory(libraries.toArray(new URL[libraries.size()]), libraryResourceIds, this.loadParentFirst(libraryResourceIds)) : this.getGlobalContextFactory();
        this.contextFactoryMap.put(libraryResourceIds, contextFactory);
    }

    private boolean loadParentFirst(Set<String> libraryResourceIds) {
        if (CollectionUtils.isNotEmpty(libraryResourceIds)) {
            for (String resourceId : libraryResourceIds) {
                LibraryProperties resourceProperties = this.libraryResources.get(resourceId);
                if (resourceProperties == null || !resourceProperties.isLoadParentFirst()) continue;
                return true;
            }
        }
        return false;
    }

    private void redactResourceIds(Set<String> libraryResourceIds) {
        Iterator<String> it = libraryResourceIds.iterator();
        while (it.hasNext()) {
            if (this.libraryResources.containsKey(it.next())) continue;
            it.remove();
        }
    }

    private List<URL> getLibraries(Set<String> libraryResourceIds, boolean reload, boolean startup) throws Exception {
        ArrayList<URL> libraries = new ArrayList<URL>();
        Iterator<String> it = libraryResourceIds.iterator();
        while (it.hasNext()) {
            String resourceId = it.next();
            LibraryProperties properties = this.libraryResources.get(resourceId);
            if (properties != null) {
                List<URL> cachedLibraries = null;
                if (!reload) {
                    cachedLibraries = this.libraryCache.get(resourceId);
                }
                if (cachedLibraries != null) {
                    libraries.addAll(cachedLibraries);
                    continue;
                }
                this.logger.debug("Reloading libraries for resource " + String.valueOf(properties) + ".");
                LibraryPlugin plugin = (LibraryPlugin)this.extensionController.getResourcePlugins().get(properties.getPluginPointName());
                if (plugin != null) {
                    List<URL> loadedLibraries = plugin.getLibraries(properties, startup);
                    this.libraryCache.put(resourceId, loadedLibraries);
                    libraries.addAll(loadedLibraries);
                    this.logger.debug("Libraries reloaded for resource " + String.valueOf(properties) + ": " + String.valueOf(loadedLibraries));
                    continue;
                }
                this.logger.error("Unable to load libraries: Plugin \"" + properties.getPluginPointName() + "\" not found.");
                it.remove();
                continue;
            }
            this.logger.warn("Unable to load libraries: Resource ID " + resourceId + " not found.");
            it.remove();
        }
        return libraries;
    }
}

