/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.server.Donkey;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.data.DonkeyDaoFactory;
import com.mirth.connect.donkey.server.data.jdbc.JdbcDaoFactory;
import com.mirth.connect.donkey.server.data.jdbc.QuerySource;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.DatabaseTask;
import com.mirth.connect.server.ExtensionLoader;
import com.mirth.connect.server.channel.ChannelFuture;
import com.mirth.connect.server.channel.ChannelTask;
import com.mirth.connect.server.channel.ChannelTaskHandler;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.DatabaseTaskController;
import com.mirth.connect.server.controllers.EngineController;
import com.mirth.connect.server.util.DatabaseUtil;
import com.mirth.connect.server.util.SqlConfig;
import edu.emory.mathcs.backport.java.util.Collections;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.MapUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultDatabaseTaskController
implements DatabaseTaskController {
    private static final String TASK_REMOVE_OLD_CHANNEL = "removeOldChannelTable";
    private static final String TASK_REMOVE_OLD_MESSAGE = "removeOldMessageTable";
    private static final String TASK_REMOVE_OLD_ATTACHMENT = "removeOldAttachmentTable";
    private static final String TASK_REMOVE_OLD_CODE_TEMPLATE = "removeOldCodeTemplateTable";
    private static final String TASK_ADD_D_MM_INDEX3 = "addMetadataIndex3";
    private static DatabaseTaskController instance = null;
    private Logger logger = LogManager.getLogger(this.getClass());
    private EngineController engineController = ControllerFactory.getFactory().createEngineController();
    private ChannelController channelController = ControllerFactory.getFactory().createChannelController();
    private DatabaseTask currentTask;
    private AtomicBoolean cancelled = new AtomicBoolean(false);
    private ReadWriteLock taskReadWriteLock = new ReentrantReadWriteLock(true);
    private Lock taskRunLock = new ReentrantLock(true);

    private DefaultDatabaseTaskController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseTaskController create() {
        Class<DefaultDatabaseTaskController> clazz = DefaultDatabaseTaskController.class;
        synchronized (DefaultDatabaseTaskController.class) {
            if (instance == null && (instance = ExtensionLoader.getInstance().getControllerInstance(DatabaseTaskController.class)) == null) {
                instance = new DefaultDatabaseTaskController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, DatabaseTask> getDatabaseTasks() throws Exception {
        HashMap<String, DatabaseTask> tasks = new HashMap<String, DatabaseTask>();
        try (SqlSession session = SqlConfig.getInstance().getReadOnlySqlSessionManager().openSession();){
            DatabaseTask task;
            Connection connection = session.getConnection();
            if (DatabaseUtil.tableExists(connection, "OLD_MESSAGE")) {
                task = this.populateTask(new DatabaseTask(TASK_REMOVE_OLD_MESSAGE));
                this.logger.debug("Adding database task: " + task.getName());
                tasks.put(task.getId(), task);
            } else if (DatabaseUtil.tableExists(connection, "OLD_CHANNEL")) {
                task = this.populateTask(new DatabaseTask(TASK_REMOVE_OLD_CHANNEL));
                this.logger.debug("Adding database task: " + task.getName());
                tasks.put(task.getId(), task);
            }
            if (DatabaseUtil.tableExists(connection, "OLD_ATTACHMENT")) {
                task = this.populateTask(new DatabaseTask(TASK_REMOVE_OLD_ATTACHMENT));
                this.logger.debug("Adding database task: " + task.getName());
                tasks.put(task.getId(), task);
            }
            if (DatabaseUtil.tableExists(connection, "OLD_CODE_TEMPLATE")) {
                task = this.populateTask(new DatabaseTask(TASK_REMOVE_OLD_CODE_TEMPLATE));
                this.logger.debug("Adding database task: " + task.getName());
                tasks.put(task.getId(), task);
            }
            try (DonkeyDao dao = Donkey.getInstance().getReadOnlyDaoFactory().getDao();){
                Map localChannelIdMap = dao.getLocalChannelIds();
                HashMap<String, String> affectedChannels = new HashMap<String, String>();
                for (String channelId : localChannelIdMap.keySet()) {
                    long localChannelId = (Long)localChannelIdMap.get(channelId);
                    String tableName = "D_MM" + localChannelId;
                    if (DatabaseUtil.indexExists(connection, tableName, tableName + "_INDEX3")) continue;
                    affectedChannels.put(channelId, this.getChannelName(channelId));
                }
                if (MapUtils.isNotEmpty(affectedChannels)) {
                    DatabaseTask task2 = this.populateTask(new DatabaseTask(TASK_ADD_D_MM_INDEX3));
                    task2.setAffectedChannels(affectedChannels);
                    this.logger.debug("Adding migration task: " + task2.getName());
                    tasks.put(task2.getId(), task2);
                }
            }
        }
        DatabaseTask currentTask = this.getCurrentTask();
        if (currentTask != null) {
            tasks.put(currentTask.getId(), currentTask);
        }
        return tasks;
    }

    private DatabaseTask populateTask(DatabaseTask task) {
        if (task.getId().equals(TASK_REMOVE_OLD_MESSAGE)) {
            task.setName("Remove Old 2.x Message Table");
            task.setDescription("Remove the OLD_MESSAGE table which was renamed as part of the upgrade from 2.x to 3.x.");
            task.setConfirmationMessage("<html>This will remove all messages that existed prior to upgrading to 3.x.<br/>Are you sure you wish to continue?</html>");
        } else if (task.getId().equals(TASK_REMOVE_OLD_CHANNEL)) {
            task.setName("Remove Old 2.x Channel Table");
            task.setDescription("Remove the OLD_CHANNEL table which was renamed as part of the upgrade from 2.x to 3.x.");
            task.setConfirmationMessage("<html>This will remove the channel backups that were saved as part of migration to 3.x.<br/>Are you sure you wish to continue?</html>");
        } else if (task.getId().equals(TASK_REMOVE_OLD_ATTACHMENT)) {
            task.setName("Remove Old 2.x Attachment Table");
            task.setDescription("Remove the OLD_ATTACHMENT table which was renamed as part of the upgrade from 2.x to 3.x.");
            task.setConfirmationMessage("<html>This will remove all attachments that existed prior to upgrading to 3.x.<br/>Are you sure you wish to continue?</html>");
        } else if (task.getId().equals(TASK_REMOVE_OLD_CODE_TEMPLATE)) {
            task.setName("Remove Old Pre-3.3 Code Template Table");
            task.setDescription("Remove the OLD_CODE_TEMPLATE table which was renamed as part of the upgrade to 3.3.");
            task.setConfirmationMessage("<html>This will remove all code templates that existed prior to upgrading to 3.3.<br/>Are you sure you wish to continue?</html>");
        } else if (task.getId().equals(TASK_ADD_D_MM_INDEX3)) {
            task.setName("Add Metadata Index");
            task.setDescription("Add index (ID, STATUS, SERVER_ID) on the message metadata table to improve queue performance.");
            task.setConfirmationMessage("<html>This index will only be created on channels that are stopped. Make<br/>sure there is enough disk space on the server running the database.<br/>Are you sure you wish to continue?</html>");
        }
        return task;
    }

    private DatabaseTask getCurrentTask() throws Exception {
        this.taskReadWriteLock.readLock().lock();
        try {
            DatabaseTask databaseTask = this.currentTask;
            return databaseTask;
        }
        finally {
            this.taskReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String runDatabaseTask(String taskId) throws Exception {
        DatabaseTask databaseTask = this.getCurrentTask();
        if (databaseTask == null && this.taskRunLock.tryLock()) {
            try {
                this.startTask(this.populateTask(new DatabaseTask(taskId)));
                if (taskId.equals(TASK_REMOVE_OLD_CHANNEL)) {
                    this.executeUpdate("DROP TABLE OLD_CHANNEL");
                    String string = "Table OLD_CHANNEL successfully dropped.";
                    return string;
                }
                if (taskId.equals(TASK_REMOVE_OLD_MESSAGE)) {
                    this.executeUpdate("DROP TABLE OLD_MESSAGE");
                    String string = "Table OLD_MESSAGE successfully dropped.";
                    return string;
                }
                if (taskId.equals(TASK_REMOVE_OLD_ATTACHMENT)) {
                    this.executeUpdate("DROP TABLE OLD_ATTACHMENT");
                    String string = "Table OLD_ATTACHMENT successfully dropped.";
                    return string;
                }
                if (taskId.equals(TASK_REMOVE_OLD_CODE_TEMPLATE)) {
                    this.executeUpdate("DROP TABLE OLD_CODE_TEMPLATE");
                    String string = "Table OLD_CODE_TEMPLATE successfully dropped.";
                    return string;
                }
                if (taskId.equals(TASK_ADD_D_MM_INDEX3)) {
                    DonkeyDaoFactory daoFactory = Donkey.getInstance().getDaoFactory();
                    if (daoFactory instanceof JdbcDaoFactory) {
                        Map localChannelIds = new HashMap();
                        try (DonkeyDao dao = daoFactory.getDao();){
                            localChannelIds = dao.getLocalChannelIds();
                        }
                        HashMap<String, Long> channelsToIndex = new HashMap<String, Long>();
                        HashMap<String, String> affectedChannels = new HashMap<String, String>();
                        try (SqlSession session = SqlConfig.getInstance().getSqlSessionManager().openSession();){
                            Connection connection = session.getConnection();
                            for (Map.Entry entry : localChannelIds.entrySet()) {
                                String indexName;
                                String string = (String)entry.getKey();
                                long localChannelId = (Long)entry.getValue();
                                String tableName = "D_MM" + localChannelId;
                                if (DatabaseUtil.indexExists(connection, tableName, indexName = tableName + "_INDEX3")) continue;
                                channelsToIndex.put(string, localChannelId);
                                affectedChannels.put(string, this.getChannelName(string));
                            }
                        }
                        this.taskReadWriteLock.writeLock().lock();
                        try {
                            this.currentTask.setAffectedChannels(new HashMap<String, String>(affectedChannels));
                        }
                        finally {
                            this.taskReadWriteLock.writeLock().unlock();
                        }
                        class AddIndexChannelTaskHandler
                        extends ChannelTaskHandler {
                            private Map<String, String> affectedChannels;

                            public AddIndexChannelTaskHandler(Map<String, String> affectedChannels) {
                                this.affectedChannels = affectedChannels;
                            }

                            @Override
                            public void taskCompleted(String channelId, Integer metaDataId) {
                                this.affectedChannels.remove(channelId);
                                DefaultDatabaseTaskController.this.taskReadWriteLock.writeLock().lock();
                                try {
                                    DefaultDatabaseTaskController.this.currentTask.setAffectedChannels(new HashMap<String, String>(this.affectedChannels));
                                }
                                finally {
                                    DefaultDatabaseTaskController.this.taskReadWriteLock.writeLock().unlock();
                                }
                            }

                            @Override
                            public void taskErrored(String channelId, Integer metaDataId, Exception e) {
                                class ChannelStoppedException
                                extends Exception {
                                    ChannelStoppedException() {
                                    }
                                }
                                if (!(e instanceof ChannelStoppedException)) {
                                    DefaultDatabaseTaskController.this.logger.error("Unable to add index to channel " + channelId + ".", (Throwable)e);
                                }
                            }

                            @Override
                            public void taskCancelled(String channelId, Integer metaDataId, CancellationException e) {
                                DefaultDatabaseTaskController.this.logger.error("Unable to add index to channel " + channelId + ".", (Throwable)e);
                            }
                        }
                        AddIndexChannelTaskHandler taskHandler = new AddIndexChannelTaskHandler(affectedChannels);
                        QuerySource querySource = ((JdbcDaoFactory)daoFactory).getQuerySource();
                        for (Map.Entry entry : channelsToIndex.entrySet()) {
                            String tableName;
                            String indexName;
                            long localChannelId;
                            if (this.isCancelled()) break;
                            String channelId = (String)entry.getKey();
                            ChannelTask addIndexTask = new ChannelTask(channelId, localChannelId = ((Long)entry.getValue()).longValue(), querySource, indexName = (tableName = "D_MM" + localChannelId) + "_INDEX3", tableName){
                                final /* synthetic */ long val$localChannelId;
                                final /* synthetic */ QuerySource val$querySource;
                                final /* synthetic */ String val$indexName;
                                final /* synthetic */ String val$tableName;
                                {
                                    this.val$localChannelId = l;
                                    this.val$querySource = querySource;
                                    this.val$indexName = string;
                                    this.val$tableName = string2;
                                    super(channelId);
                                }

                                @Override
                                public Void execute() throws Exception {
                                    com.mirth.connect.donkey.server.channel.Channel channel = DefaultDatabaseTaskController.this.engineController.getDeployedChannel(this.channelId);
                                    if (channel != null && channel.getCurrentState() != DeployedState.STOPPED) {
                                        throw new ChannelStoppedException();
                                    }
                                    HashMap<String, Long> values = new HashMap<String, Long>();
                                    values.put("localChannelId", this.val$localChannelId);
                                    String query = this.val$querySource.getQuery("createConnectorMessageTableIndex3", values);
                                    if (query == null) {
                                        throw new Exception("Error adding index: Update statement not found for database type: " + Donkey.getInstance().getConfiguration().getDonkeyProperties().getProperty("database"));
                                    }
                                    DefaultDatabaseTaskController.this.logger.debug("Adding index " + this.val$indexName + " on table " + this.val$tableName + ".");
                                    DefaultDatabaseTaskController.this.executeUpdate(query);
                                    return null;
                                }
                            };
                            List<ChannelFuture> futures = this.engineController.submitTasks(Collections.singletonList((Object)addIndexTask), taskHandler);
                            if (futures.size() <= 0) continue;
                            futures.get(0).get();
                        }
                        int n = channelsToIndex.size();
                        int n2 = n - affectedChannels.size();
                        String string = "<html>" + n2 + " out of " + channelsToIndex.size() + " indices successfully added.</html>";
                        return string;
                    }
                    throw new Exception("Unable to perform task: DAO type is not JDBC.");
                }
                throw new Exception("Unknown task ID: " + taskId);
            }
            finally {
                this.stopTask();
            }
        }
        throw new Exception("Another database task is already running: " + databaseTask.getName());
    }

    @Override
    public void cancelDatabaseTask(String taskId) throws Exception {
        DatabaseTask databaseTask = this.getCurrentTask();
        if (databaseTask == null || !databaseTask.getId().equals(taskId)) {
            throw new Exception("Task \"" + this.populateTask(new DatabaseTask(taskId)).getName() + "\" is not currently running.");
        }
        this.taskReadWriteLock.writeLock().lock();
        try {
            this.cancelled.set(true);
        }
        finally {
            this.taskReadWriteLock.writeLock().unlock();
        }
    }

    private void startTask(DatabaseTask task) {
        this.taskReadWriteLock.writeLock().lock();
        try {
            this.currentTask = task;
            this.currentTask.setStatus(DatabaseTask.Status.RUNNING);
            this.currentTask.setStartDateTime(Calendar.getInstance());
            this.cancelled.set(false);
        }
        finally {
            this.taskReadWriteLock.writeLock().unlock();
        }
    }

    private void stopTask() {
        try {
            this.taskReadWriteLock.writeLock().lock();
            try {
                this.currentTask = null;
                this.cancelled.set(false);
            }
            finally {
                this.taskReadWriteLock.writeLock().unlock();
            }
        }
        finally {
            this.taskRunLock.unlock();
        }
    }

    private boolean isCancelled() {
        this.taskReadWriteLock.readLock().lock();
        try {
            boolean bl = this.cancelled.get();
            return bl;
        }
        finally {
            this.taskReadWriteLock.readLock().unlock();
        }
    }

    private void executeUpdate(String sql) throws SQLException {
        try (SqlSession session = SqlConfig.getInstance().getSqlSessionManager().openSession();){
            session.getConnection().createStatement().executeUpdate(sql);
        }
    }

    private String getChannelName(String channelId) {
        Channel model = this.channelController.getDeployedChannelById(channelId);
        if (model == null) {
            model = this.channelController.getChannelById(channelId);
        }
        return model != null ? model.getName() : null;
    }
}

