/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.DeployedStateEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.server.event.EventType;
import com.mirth.connect.donkey.server.event.MessageEvent;
import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.model.filters.EventFilter;
import com.mirth.connect.server.ExtensionLoader;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.event.AuditableEventListener;
import com.mirth.connect.server.event.EventListener;
import com.mirth.connect.server.util.DatabaseUtil;
import com.mirth.connect.server.util.ResourceUtil;
import com.mirth.connect.server.util.SqlConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultEventController
extends EventController {
    private Logger logger = LogManager.getLogger(this.getClass());
    private static EventController instance = null;
    private static Map<Object, BlockingQueue<Event>> messageEventQueues = new ConcurrentHashMap<Object, BlockingQueue<Event>>();
    private static Map<Object, BlockingQueue<Event>> errorEventQueues = new ConcurrentHashMap<Object, BlockingQueue<Event>>();
    private static Map<Object, BlockingQueue<Event>> deployedStateEventQueues = new ConcurrentHashMap<Object, BlockingQueue<Event>>();
    private static Map<Object, BlockingQueue<Event>> connectionStatusEventQueues = new ConcurrentHashMap<Object, BlockingQueue<Event>>();
    private static Map<Object, BlockingQueue<Event>> serverEventQueues = new ConcurrentHashMap<Object, BlockingQueue<Event>>();
    private static Map<Object, BlockingQueue<Event>> genericEventQueues = new ConcurrentHashMap<Object, BlockingQueue<Event>>();

    protected DefaultEventController() {
        this.addListener(new AuditableEventListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventController create() {
        Class<DefaultEventController> clazz = DefaultEventController.class;
        synchronized (DefaultEventController.class) {
            if (instance == null && (instance = ExtensionLoader.getInstance().getControllerInstance(EventController.class)) == null) {
                instance = new DefaultEventController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void addListener(EventListener listener) {
        Set<EventType> types = listener.getEventTypes();
        BlockingQueue<Event> queue = listener.getQueue();
        if (types.contains(EventType.MESSAGE)) {
            messageEventQueues.put(listener, queue);
        }
        if (types.contains(EventType.ERROR)) {
            errorEventQueues.put(listener, queue);
        }
        if (types.contains(EventType.DEPLOY_STATE)) {
            deployedStateEventQueues.put(listener, queue);
        }
        if (types.contains(EventType.CONNECTION_STATUS)) {
            connectionStatusEventQueues.put(listener, queue);
        }
        if (types.contains(EventType.SERVER)) {
            serverEventQueues.put(listener, queue);
        }
        if (types.contains(EventType.GENERIC)) {
            genericEventQueues.put(listener, queue);
        }
    }

    @Override
    public void removeListener(EventListener listener) {
        messageEventQueues.remove(listener);
        errorEventQueues.remove(listener);
        deployedStateEventQueues.remove(listener);
        connectionStatusEventQueues.remove(listener);
        serverEventQueues.remove(listener);
        genericEventQueues.remove(listener);
        listener.shutdown();
    }

    @Override
    public void dispatchEvent(Event event) {
        try {
            Map<Object, BlockingQueue<Event>> queues = null;
            queues = event instanceof MessageEvent ? messageEventQueues : (event instanceof ErrorEvent ? errorEventQueues : (event instanceof DeployedStateEvent ? deployedStateEventQueues : (event instanceof ConnectionStatusEvent ? connectionStatusEventQueues : (event instanceof ServerEvent ? serverEventQueues : genericEventQueues))));
            for (BlockingQueue<Event> queue : queues.values()) {
                queue.put(event);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void insertEvent(ServerEvent serverEvent) {
        this.logger.debug("adding event: " + String.valueOf(serverEvent));
        try {
            SqlConfig.getInstance().getSqlSessionManager().insert("Event.insertEvent", (Object)serverEvent);
        }
        catch (Exception e) {
            this.logger.error("Error adding event.", (Throwable)e);
        }
    }

    @Override
    public Integer getMaxEventId() throws ControllerException {
        try {
            return (Integer)SqlConfig.getInstance().getReadOnlySqlSessionManager().selectOne("Event.getMaxEventId");
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
    }

    @Override
    public List<ServerEvent> getEvents(EventFilter filter, Integer offset, Integer limit) throws ControllerException {
        try {
            return SqlConfig.getInstance().getReadOnlySqlSessionManager().selectList("Event.searchEvents", this.getParameters(filter, offset, limit));
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
    }

    @Override
    public List<ServerEvent> getEventsByAsc(EventFilter filter, Integer offset, Integer limit) throws ControllerException {
        try {
            return SqlConfig.getInstance().getReadOnlySqlSessionManager().selectList("Event.searchEventsByAsc", this.getParameters(filter, offset, limit));
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
    }

    @Override
    public Long getEventCount(EventFilter filter) throws ControllerException {
        return (Long)SqlConfig.getInstance().getReadOnlySqlSessionManager().selectOne("Event.searchEventsCount", this.getParameters(filter, null, null));
    }

    @Override
    public void removeAllEvents() throws ControllerException {
        this.logger.debug("removing all events");
        try {
            SqlConfig.getInstance().getSqlSessionManager().delete("Event.deleteAllEvents");
            if (DatabaseUtil.statementExists("Event.vacuumEventTable")) {
                SqlConfig.getInstance().getSqlSessionManager().update("Event.vacuumEventTable");
            }
        }
        catch (PersistenceException e) {
            throw new ControllerException("Error removing all events.", (Throwable)e);
        }
    }

    private Map<String, Object> getParameters(EventFilter filter, Integer offset, Integer limit) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("maxEventId", filter.getMaxEventId());
        params.put("minEventId", filter.getMinEventId());
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("id", filter.getId());
        params.put("name", filter.getName());
        params.put("levels", filter.getLevels());
        if (filter.getStartDate() != null) {
            params.put("startDate", filter.getStartDate());
        }
        if (filter.getEndDate() != null) {
            params.put("endDate", filter.getEndDate());
        }
        params.put("outcome", (Object)filter.getOutcome());
        params.put("userId", filter.getUserId());
        params.put("attributeSearch", filter.getAttributeSearch());
        params.put("ipAddress", filter.getIpAddress());
        params.put("serverId", filter.getServerId());
        return params;
    }

    @Override
    public String exportAllEvents() throws ControllerException {
        this.logger.debug("exporting events");
        long currentTimeMillis = System.currentTimeMillis();
        String currentDateTime = new SimpleDateFormat("yyyy-MM-dd-HHmmss").format(currentTimeMillis);
        String appDataDir = ControllerFactory.getFactory().createConfigurationController().getApplicationDataDir();
        File exportDir = new File(appDataDir, "exports");
        exportDir.mkdir();
        File exportFile = new File(exportDir, currentDateTime + "-events.txt");
        FileWriter writer = null;
        try {
            writer = new FileWriter(exportFile, true);
            writer.write(ServerEvent.getExportHeader());
            writer.write(System.getProperty("line.separator"));
            EventFilter filter = new EventFilter();
            int maxEventId = this.getMaxEventId();
            filter.setMaxEventId(maxEventId);
            int interval = 10;
            List<ServerEvent> events = this.getEvents(filter, null, interval);
            while (!events.isEmpty()) {
                for (ServerEvent event : events) {
                    writer.write(event.toExportString());
                    if (event.getId() > maxEventId) continue;
                    maxEventId = event.getId() - 1;
                }
                filter.setMaxEventId(maxEventId);
                events = this.getEvents(filter, null, interval);
            }
            this.logger.debug("events exported to file: " + exportFile.getAbsolutePath());
            ServerEvent event = new ServerEvent(ControllerFactory.getFactory().createConfigurationController().getServerId(), "Successfully exported events");
            event.addAttribute("file", exportFile.getAbsolutePath());
            this.dispatchEvent(event);
        }
        catch (IOException e) {
            try {
                throw new ControllerException("Error exporting events to file.", (Throwable)e);
            }
            catch (Throwable throwable) {
                ResourceUtil.closeResourceQuietly(writer);
                throw throwable;
            }
        }
        ResourceUtil.closeResourceQuietly(writer);
        return exportFile.getAbsolutePath();
    }

    @Override
    public String exportAndRemoveAllEvents() throws ControllerException {
        String exportFilePath = this.exportAllEvents();
        this.removeAllEvents();
        return exportFilePath;
    }
}

