/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mirth.connect.client.core.ConnectServiceUtil;
import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.donkey.util.purge.Purgable;
import com.mirth.connect.donkey.util.purge.PurgeUtil;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ConnectorMetaData;
import com.mirth.connect.model.DebugUsage;
import com.mirth.connect.model.InvalidChannel;
import com.mirth.connect.model.PluginMetaData;
import com.mirth.connect.model.UpdateSettings;
import com.mirth.connect.model.User;
import com.mirth.connect.model.alert.AlertModel;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.model.purged.PurgedDocument;
import com.mirth.connect.plugins.ServerPlugin;
import com.mirth.connect.server.ExtensionLoader;
import com.mirth.connect.server.controllers.AlertController;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.CodeTemplateController;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.DebugUsageController;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.controllers.UsageController;
import com.mirth.connect.server.controllers.UserController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultUsageController
extends UsageController {
    private ConfigurationController configurationController = ControllerFactory.getFactory().createConfigurationController();
    private Map<String, Object> lastClientStats = new HashMap<String, Object>();
    private static UsageController instance = null;

    private DefaultUsageController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsageController create() {
        Class<DefaultUsageController> clazz = DefaultUsageController.class;
        synchronized (DefaultUsageController.class) {
            if (instance == null && (instance = ExtensionLoader.getInstance().getControllerInstance(UsageController.class)) == null) {
                instance = new DefaultUsageController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private boolean canSendStats() throws ControllerException {
        Long lastUpdate;
        long now = System.currentTimeMillis();
        UpdateSettings updateSettings = this.configurationController.getUpdateSettings();
        return updateSettings.getStatsEnabled() != false && ((lastUpdate = updateSettings.getLastStatsTime()) == null || now - lastUpdate > (long)ConnectServiceUtil.MILLIS_PER_DAY.intValue());
    }

    @Override
    public String createUsageStats(Map<String, Object> clientStats) {
        PurgedDocument purgedDocument = new PurgedDocument();
        String usageData = null;
        if (clientStats != null) {
            this.lastClientStats = clientStats;
        }
        try {
            if (this.canSendStats()) {
                this.getClientSpecs(purgedDocument);
                this.getServerSpecs(purgedDocument);
                this.getConfigurationData(purgedDocument);
                this.getChannelData(purgedDocument);
                this.getExtensionData(purgedDocument);
                this.getCodeTemplateData(purgedDocument);
                this.getScriptData(purgedDocument);
                this.getAlertData(purgedDocument);
                this.getUserData(purgedDocument);
                this.getDebugData(purgedDocument);
                ObjectMapper mapper = new ObjectMapper();
                mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
                usageData = mapper.writeValueAsString((Object)purgedDocument);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return usageData;
    }

    private void getConfigurationData(PurgedDocument purgedDocument) throws ControllerException {
        purgedDocument.setServerId(this.configurationController.getServerId());
        purgedDocument.setMirthVersion(this.configurationController.getServerVersion());
        purgedDocument.setUpdateSettings(this.configurationController.getUpdateSettings().getPurgedProperties());
        purgedDocument.setServerSettings(this.configurationController.getServerSettings().getPurgedProperties());
        purgedDocument.setDatabaseType(this.configurationController.getDatabaseType());
    }

    private void getDatabaseVersion() {
    }

    private void getClientSpecs(PurgedDocument purgedDocument) {
        purgedDocument.setClientSpecs(this.lastClientStats);
    }

    private void getServerSpecs(PurgedDocument purgedDocument) {
        HashMap<String, Object> serverSpecs = new HashMap<String, Object>();
        serverSpecs.put("osName", System.getProperty("os.name"));
        serverSpecs.put("osVersion", System.getProperty("os.version"));
        serverSpecs.put("javaVersion", System.getProperty("java.version"));
        serverSpecs.put("maxMemory", Runtime.getRuntime().maxMemory());
        serverSpecs.put("availableProcessors", Runtime.getRuntime().availableProcessors());
        purgedDocument.setServerSpecs(serverSpecs);
    }

    private void getChannelData(PurgedDocument purgedDocument) throws ControllerException {
        ChannelController channelController = ControllerFactory.getFactory().createChannelController();
        ArrayList<Map<String, Object>> purgedChannels = new ArrayList<Map<String, Object>>();
        int invalidChannels = 0;
        for (Channel channel : channelController.getChannels(null)) {
            if (!(channel instanceof InvalidChannel)) {
                purgedChannels.add(channel.getPurgedProperties());
                continue;
            }
            ++invalidChannels;
        }
        purgedDocument.setChannels(purgedChannels);
        purgedDocument.setInvalidChannels(invalidChannels);
    }

    private void getCodeTemplateData(PurgedDocument purgedDocument) throws ControllerException {
        CodeTemplateController codeTemplateController = ControllerFactory.getFactory().createCodeTemplateController();
        ArrayList<Map<String, Object>> purgedLibraries = new ArrayList<Map<String, Object>>();
        for (CodeTemplateLibrary library : codeTemplateController.getLibraries(null, true)) {
            purgedLibraries.add(library.getPurgedProperties());
        }
        purgedDocument.setCodeTemplateLibraries(purgedLibraries);
    }

    private void getScriptData(PurgedDocument purgedDocument) throws ControllerException {
        ScriptController scriptController = ControllerFactory.getFactory().createScriptController();
        HashMap<String, Integer> purgedGlobalScripts = new HashMap<String, Integer>();
        for (Map.Entry<String, String> entry : scriptController.getGlobalScripts().entrySet()) {
            Object key = entry.getKey().toLowerCase();
            key = (String)key + "Lines";
            purgedGlobalScripts.put((String)key, PurgeUtil.countLines((String)entry.getValue()));
        }
        purgedDocument.setGlobalScripts(purgedGlobalScripts);
    }

    private void getAlertData(PurgedDocument purgedDocument) throws ControllerException {
        AlertController alertController = ControllerFactory.getFactory().createAlertController();
        ArrayList<Map<String, Object>> purgedAlerts = new ArrayList<Map<String, Object>>();
        List<AlertModel> alerts = alertController.getAlerts();
        for (AlertModel alert : alerts) {
            purgedAlerts.add(alert.getPurgedProperties());
        }
        purgedDocument.setAlerts(purgedAlerts);
    }

    private void getUserData(PurgedDocument purgedDocument) throws ControllerException {
        UserController userController = ControllerFactory.getFactory().createUserController();
        List<User> users = userController.getAllUsers();
        purgedDocument.setUsers(users.size());
    }

    private void getExtensionData(PurgedDocument purgedDocument) throws ControllerException {
        ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();
        ArrayList<Map<String, Object>> purgedPlugins = new ArrayList<Map<String, Object>>();
        for (ServerPlugin serverPlugin : extensionController.getServerPlugins()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("pluginPoint", serverPlugin.getPluginPointName());
            if (serverPlugin instanceof Purgable) {
                hashMap.put("properties", ((Purgable)serverPlugin).getPurgedProperties());
            }
            purgedPlugins.add(hashMap);
        }
        purgedDocument.setPlugins(purgedPlugins);
        ArrayList<Map<String, Object>> purgedPluginMetaData = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, PluginMetaData> entry : extensionController.getPluginMetaData().entrySet()) {
            HashMap<String, String> pluginMetaData = new HashMap<String, String>();
            pluginMetaData.put("name", entry.getKey());
            if (!(entry.getValue() instanceof Purgable)) continue;
            pluginMetaData.putAll(((Purgable)entry.getValue()).getPurgedProperties());
            purgedPluginMetaData.add(pluginMetaData);
        }
        purgedDocument.setPluginMetaData(purgedPluginMetaData);
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, ConnectorMetaData> entry : extensionController.getConnectorMetaData().entrySet()) {
            HashMap<String, String> connectorMetaData = new HashMap<String, String>();
            connectorMetaData.put("name", entry.getKey());
            if (!(entry.getValue() instanceof Purgable)) continue;
            connectorMetaData.putAll(((Purgable)entry.getValue()).getPurgedProperties());
            arrayList.add(connectorMetaData);
        }
        purgedDocument.setConnectorMetaData(arrayList);
    }

    private void getDebugData(PurgedDocument purgedDocument) throws ControllerException {
        DebugUsageController debugUsageController = ControllerFactory.getFactory().createDebugUsageController();
        ArrayList<Map<String, Object>> purgedDebugUsages = new ArrayList<Map<String, Object>>();
        List<DebugUsage> debugUsages = debugUsageController.getDebugUsages();
        for (DebugUsage debugUsage : debugUsages) {
            try {
                purgedDebugUsages.add(debugUsageController.getDebugUsageMap(debugUsage));
                debugUsageController.deleteDebugUsage(debugUsage.getServerId());
            }
            catch (Exception exception) {}
        }
        purgedDocument.setDebugStatistics(purgedDebugUsages);
    }
}

