/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.commons.encryption.Digester;
import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.model.Credentials;
import com.mirth.connect.model.LoginStatus;
import com.mirth.connect.model.LoginStrike;
import com.mirth.connect.model.PasswordRequirements;
import com.mirth.connect.model.User;
import com.mirth.connect.server.ExtensionLoader;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.controllers.UserController;
import com.mirth.connect.server.mybatis.KeyValuePair;
import com.mirth.connect.server.util.DatabaseUtil;
import com.mirth.connect.server.util.LoginRequirementsChecker;
import com.mirth.connect.server.util.PasswordRequirementsChecker;
import com.mirth.connect.server.util.Pre22PasswordChecker;
import com.mirth.connect.server.util.SqlConfig;
import com.mirth.connect.server.util.StatementLock;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultUserController
extends UserController {
    public static final String VACUUM_LOCK_PERSON_STATEMENT_ID = "User.vacuumPersonTable";
    public static final String VACUUM_LOCK_PREFERENCES_STATEMENT_ID = "User.vacuumPersonPreferencesTable";
    private Logger logger = LogManager.getLogger(this.getClass());
    private ExtensionController extensionController = null;
    private static UserController instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserController create() {
        Class<DefaultUserController> clazz = DefaultUserController.class;
        synchronized (DefaultUserController.class) {
            if (instance == null && (instance = ExtensionLoader.getInstance().getControllerInstance(UserController.class)) == null) {
                instance = new DefaultUserController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void resetUserStatus() {
        StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readLock();
        try {
            SqlConfig.getInstance().getSqlSessionManager().update("User.resetUserStatus");
        }
        catch (PersistenceException e) {
            this.logger.error("Could not reset user status.");
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readUnlock();
        }
    }

    @Override
    public List<User> getAllUsers() throws ControllerException {
        this.logger.debug("getting all users");
        StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readLock();
        try {
            List list = SqlConfig.getInstance().getReadOnlySqlSessionManager().selectList("User.getUser");
            return list;
        }
        catch (PersistenceException e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readUnlock();
        }
    }

    @Override
    public User getUser(Integer userId, String userName) throws ControllerException {
        this.logger.debug("getting user: " + userId);
        if (userId == null && userName == null) {
            throw new ControllerException("Error getting user: Both user ID and user name cannot be null.");
        }
        StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readLock();
        try {
            User user = new User();
            user.setId(userId);
            user.setUsername(userName);
            User user2 = (User)SqlConfig.getInstance().getReadOnlySqlSessionManager().selectOne("User.getUser", (Object)user);
            return user2;
        }
        catch (PersistenceException e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readUnlock();
        }
    }

    @Override
    public synchronized void updateUser(User user) throws ControllerException {
        StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readLock();
        try {
            User existingUserByName = this.getUser(null, user.getUsername());
            if (user.getId() == null) {
                if (existingUserByName != null) {
                    throw new ControllerException("Error adding user: username must be unique");
                }
                this.logger.debug("adding user: " + String.valueOf(user));
                SqlConfig.getInstance().getSqlSessionManager().insert("User.insertUser", this.getUserMap(user));
            } else {
                if (existingUserByName != null && !user.getId().equals(existingUserByName.getId())) {
                    throw new ControllerException("Error updating user: username must be unique");
                }
                User existingUserById = this.getUser(user.getId(), null);
                if (existingUserById == null) {
                    throw new ControllerException("Error updating user: No user found with ID " + user.getId());
                }
                String currentUsername = existingUserById.getUsername();
                this.logger.debug("updating user: " + String.valueOf(user));
                SqlConfig.getInstance().getSqlSessionManager().update("User.updateUser", this.getUserMap(user));
                if (!StringUtils.equals((CharSequence)currentUsername, (CharSequence)user.getUsername())) {
                    ControllerFactory.getFactory().createAuthorizationController().usernameChanged(currentUsername, user.getUsername());
                }
            }
        }
        catch (PersistenceException e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readUnlock();
        }
    }

    @Override
    public List<String> checkOrUpdateUserPassword(Integer userId, String plainPassword) throws ControllerException {
        StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readLock();
        try {
            Digester digester = ControllerFactory.getFactory().createConfigurationController().getDigester();
            PasswordRequirements passwordRequirements = ControllerFactory.getFactory().createConfigurationController().getPasswordRequirements();
            List<String> responses = PasswordRequirementsChecker.getInstance().doesPasswordMeetRequirements(userId, plainPassword, passwordRequirements);
            if (responses != null) {
                List<String> list = responses;
                return list;
            }
            if (userId == null) {
                List<String> list = null;
                return list;
            }
            this.logger.debug("updating password for user id: " + userId);
            Calendar pruneDate = PasswordRequirementsChecker.getInstance().getLastExpirationDate(passwordRequirements);
            if (pruneDate != null) {
                HashMap<String, Comparable<Integer>> userDateMap = new HashMap<String, Comparable<Integer>>();
                userDateMap.put("id", userId);
                userDateMap.put("pruneDate", pruneDate);
                try {
                    SqlConfig.getInstance().getSqlSessionManager().delete("User.prunePasswords", userDateMap);
                }
                catch (Exception e) {
                    this.logger.error("There was an error pruning passwords for user id: " + userId, (Throwable)e);
                }
            }
            HashMap<String, Object> userPasswordMap = new HashMap<String, Object>();
            userPasswordMap.put("id", userId);
            userPasswordMap.put("password", digester.digest(plainPassword));
            userPasswordMap.put("passwordDate", Calendar.getInstance());
            SqlConfig.getInstance().getSqlSessionManager().insert("User.updateUserPassword", userPasswordMap);
            SqlConfig.getInstance().getSqlSessionManager().update("User.clearGracePeriod", (Object)userId);
            List<String> list = null;
            return list;
        }
        catch (PersistenceException e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readUnlock();
        }
    }

    @Override
    public synchronized void removeUser(Integer userId, Integer currentUserId) throws ControllerException {
        this.logger.debug("removing user: " + userId);
        if (userId == null) {
            throw new ControllerException("Error removing user: User Id cannot be null");
        }
        if (userId.equals(currentUserId)) {
            throw new ControllerException("Error removing user: You cannot remove yourself");
        }
        StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).writeLock();
        try {
            User user = new User();
            user.setId(userId);
            SqlConfig.getInstance().getSqlSessionManager().delete("User.deleteUser", (Object)user);
            if (DatabaseUtil.statementExists(VACUUM_LOCK_PERSON_STATEMENT_ID)) {
                this.vacuumPersonTable();
            }
        }
        catch (PersistenceException e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).writeUnlock();
        }
    }

    public void vacuumPersonTable() {
        try (SqlSession session = null;){
            session = SqlConfig.getInstance().getSqlSessionManager().openSession(false);
            if (DatabaseUtil.statementExists("User.lockPersonTable")) {
                session.update("User.lockPersonTable");
            }
            session.update(VACUUM_LOCK_PERSON_STATEMENT_ID);
            session.commit();
        }
    }

    public void vacuumPersonPreferencesTable() {
        try (SqlSession session = null;){
            session = SqlConfig.getInstance().getSqlSessionManager().openSession(false);
            if (DatabaseUtil.statementExists("User.lockPersonPreferencesTable")) {
                session.update("User.lockPersonPreferencesTable");
            }
            session.update(VACUUM_LOCK_PREFERENCES_STATEMENT_ID);
            session.commit();
        }
    }

    @Override
    public LoginStatus authorizeUser(String username, String plainPassword, String serverURL) throws ControllerException {
        StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readLock();
        try {
            LoginStatus loginStatus;
            if (this.extensionController == null) {
                this.extensionController = ControllerFactory.getFactory().createExtensionController();
            }
            if (this.extensionController.getAuthorizationPlugin() != null && (loginStatus = this.extensionController.getAuthorizationPlugin().authorizeUser(username, plainPassword)) != null) {
                LoginStatus loginStatus2 = this.handleSecondaryAuthentication(StringUtils.defaultString((String)loginStatus.getUpdatedUsername(), (String)username), loginStatus, null, serverURL);
                return loginStatus2;
            }
            boolean authorized = false;
            Credentials credentials = null;
            LoginRequirementsChecker loginRequirementsChecker = null;
            User validUser = this.getUser(null, username);
            if (validUser != null) {
                Digester digester = ControllerFactory.getFactory().createConfigurationController().getDigester();
                loginRequirementsChecker = new LoginRequirementsChecker(validUser);
                if (loginRequirementsChecker.isUserLockedOut()) {
                    LoginStatus loginStatus3 = new LoginStatus(LoginStatus.Status.FAIL_LOCKED_OUT, "User account \"" + username + "\" has been locked. You may attempt to login again in " + loginRequirementsChecker.getPrintableStrikeTimeRemaining() + ".");
                    return loginStatus3;
                }
                loginRequirementsChecker.resetExpiredStrikes();
                credentials = (Credentials)SqlConfig.getInstance().getReadOnlySqlSessionManager().selectOne("User.getLatestUserCredentials", (Object)validUser.getId());
                if (credentials != null) {
                    if (Pre22PasswordChecker.isPre22Hash(credentials.getPassword())) {
                        if (Pre22PasswordChecker.checkPassword(plainPassword, credentials.getPassword())) {
                            this.checkOrUpdateUserPassword(validUser.getId(), plainPassword);
                            authorized = true;
                        }
                    } else {
                        authorized = digester.matches(plainPassword, credentials.getPassword());
                    }
                }
            }
            PasswordRequirements passwordRequirements = ControllerFactory.getFactory().createConfigurationController().getPasswordRequirements();
            LoginStatus loginStatus4 = null;
            if (authorized) {
                long currentTime;
                long passwordTime;
                if (passwordRequirements.getExpiration() > 0 && loginRequirementsChecker.isPasswordExpired(passwordTime = credentials.getPasswordDate().getTimeInMillis(), currentTime = System.currentTimeMillis())) {
                    if (passwordRequirements.getGracePeriod() == 0) {
                        loginStatus4 = new LoginStatus(LoginStatus.Status.SUCCESS_GRACE_PERIOD, "Your password has expired. Please change your password now.");
                    } else if (passwordRequirements.getGracePeriod() > 0) {
                        long gracePeriodStartTime;
                        if (validUser.getGracePeriodStart() == null) {
                            gracePeriodStartTime = currentTime;
                            HashMap<String, Comparable<Integer>> gracePeriodMap = new HashMap<String, Comparable<Integer>>();
                            gracePeriodMap.put("id", validUser.getId());
                            gracePeriodMap.put("gracePeriodStart", Calendar.getInstance());
                            SqlConfig.getInstance().getSqlSessionManager().update("User.startGracePeriod", gracePeriodMap);
                        } else {
                            gracePeriodStartTime = validUser.getGracePeriodStart().getTimeInMillis();
                        }
                        long graceTimeRemaining = loginRequirementsChecker.getGraceTimeRemaining(gracePeriodStartTime, currentTime);
                        if (graceTimeRemaining > 0L) {
                            loginStatus4 = new LoginStatus(LoginStatus.Status.SUCCESS_GRACE_PERIOD, "Your password has expired. You are required to change your password in the next " + loginRequirementsChecker.getPrintableGraceTimeRemaining(graceTimeRemaining) + ".");
                        }
                    }
                    if (loginStatus4 == null) {
                        loginStatus4 = new LoginStatus(LoginStatus.Status.FAIL_EXPIRED, "Your password has expired. Please contact an administrator to have your password reset.");
                    }
                    if (passwordRequirements.getGracePeriod() <= 0 && validUser.getGracePeriodStart() != null) {
                        SqlConfig.getInstance().getSqlSessionManager().update("User.clearGracePeriod", (Object)validUser.getId());
                    }
                }
                if (loginStatus4 == null) {
                    loginStatus4 = new LoginStatus(LoginStatus.Status.SUCCESS, "");
                    if (validUser.getGracePeriodStart() != null) {
                        SqlConfig.getInstance().getSqlSessionManager().update("User.clearGracePeriod", (Object)validUser.getId());
                    }
                }
            } else {
                LoginStatus.Status status = LoginStatus.Status.FAIL;
                Object failMessage = "Incorrect username or password.";
                if (loginRequirementsChecker != null) {
                    loginRequirementsChecker.incrementStrikes();
                    if (loginRequirementsChecker.isLockoutEnabled()) {
                        if (loginRequirementsChecker.isUserLockedOut()) {
                            status = LoginStatus.Status.FAIL_LOCKED_OUT;
                            failMessage = (String)failMessage + " User account \"" + username + "\" has been locked. You may attempt to login again in " + loginRequirementsChecker.getPrintableStrikeTimeRemaining() + ".";
                        } else {
                            failMessage = (String)failMessage + " " + loginRequirementsChecker.getAttemptsRemaining() + " login attempt(s) remaining for \"" + username + "\" until the account is locked for " + loginRequirementsChecker.getPrintableLockoutPeriod() + ".";
                        }
                    }
                }
                loginStatus4 = new LoginStatus(status, (String)failMessage);
            }
            LoginStatus loginStatus5 = this.handleSecondaryAuthentication(username, loginStatus4, loginRequirementsChecker, serverURL);
            return loginStatus5;
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readUnlock();
        }
    }

    @Override
    public boolean checkPassword(String plainPassword, String encryptedPassword) {
        Digester digester = ControllerFactory.getFactory().createConfigurationController().getDigester();
        return digester.matches(plainPassword, encryptedPassword);
    }

    @Override
    public void loginUser(User user) throws ControllerException {
        StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readLock();
        try {
            HashMap<String, Comparable<Integer>> params = new HashMap<String, Comparable<Integer>>();
            params.put("id", user.getId());
            params.put("lastLogin", Calendar.getInstance());
            SqlConfig.getInstance().getSqlSessionManager().update("User.loginUser", params);
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readUnlock();
        }
    }

    @Override
    public void logoutUser(User user) throws ControllerException {
        StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readLock();
        try {
            SqlConfig.getInstance().getSqlSessionManager().update("User.logoutUser", (Object)user.getId());
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readUnlock();
        }
    }

    @Override
    public boolean isUserLoggedIn(Integer userId) throws ControllerException {
        StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readLock();
        try {
            boolean bl = (Boolean)SqlConfig.getInstance().getReadOnlySqlSessionManager().selectOne("User.isUserLoggedIn", (Object)userId);
            return bl;
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_PERSON_STATEMENT_ID).readUnlock();
        }
    }

    private Map<String, Object> getUserMap(User user) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        if (user.getId() != null) {
            parameterMap.put("id", user.getId());
        }
        parameterMap.put("username", user.getUsername());
        parameterMap.put("firstName", user.getFirstName());
        parameterMap.put("lastName", user.getLastName());
        parameterMap.put("organization", user.getOrganization());
        parameterMap.put("industry", user.getIndustry());
        parameterMap.put("email", user.getEmail());
        parameterMap.put("phoneNumber", user.getPhoneNumber());
        parameterMap.put("description", user.getDescription());
        parameterMap.put("country", user.getCountry());
        parameterMap.put("stateTerritory", user.getStateTerritory());
        parameterMap.put("role", user.getRole());
        parameterMap.put("userConsent", user.getUserConsent());
        return parameterMap;
    }

    @Override
    public List<Credentials> getUserCredentials(Integer userId) throws ControllerException {
        try {
            return SqlConfig.getInstance().getReadOnlySqlSessionManager().selectList("User.getUserCredentials", (Object)userId);
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
    }

    @Override
    public LoginStrike incrementStrikes(Integer userId) throws ControllerException {
        try {
            SqlConfig.getInstance().getSqlSessionManager().update("User.incrementStrikes", (Object)userId);
            User updatedUser = this.getUser(userId, null);
            if (updatedUser != null) {
                return new LoginStrike(updatedUser.getStrikeCount() != null ? updatedUser.getStrikeCount() : 0, updatedUser.getLastStrikeTime());
            }
            return null;
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
    }

    @Override
    public LoginStrike resetStrikes(Integer userId) throws ControllerException {
        try {
            SqlConfig.getInstance().getSqlSessionManager().update("User.resetStrikes", (Object)userId);
            User updatedUser = this.getUser(userId, null);
            if (updatedUser != null) {
                return new LoginStrike(updatedUser.getStrikeCount() != null ? updatedUser.getStrikeCount() : 0, updatedUser.getLastStrikeTime());
            }
            return null;
        }
        catch (Exception e) {
            throw new ControllerException((Throwable)e);
        }
    }

    @Override
    public void setUserPreferences(Integer userId, Properties properties) throws ControllerException {
        for (String property : properties.stringPropertyNames()) {
            this.setUserPreference(userId, property, properties.getProperty(property));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserPreference(Integer userId, String name, String value) {
        this.logger.debug("storing preference: user id=" + userId + ", name=" + name);
        StatementLock.getInstance(VACUUM_LOCK_PREFERENCES_STATEMENT_ID).writeLock();
        try {
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            parameterMap.put("person_id", userId);
            parameterMap.put("name", name);
            parameterMap.put("value", value);
            if (this.getUserPreference(userId, name) == null) {
                SqlConfig.getInstance().getSqlSessionManager().insert("User.insertPreference", parameterMap);
            } else {
                SqlConfig.getInstance().getSqlSessionManager().insert("User.updatePreference", parameterMap);
            }
            if (DatabaseUtil.statementExists(VACUUM_LOCK_PREFERENCES_STATEMENT_ID)) {
                this.vacuumPersonPreferencesTable();
            }
        }
        catch (Exception e) {
            this.logger.error("Could not store preference: user id=" + userId + ", name=" + name, (Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_PREFERENCES_STATEMENT_ID).writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getUserPreferences(Integer userId, Set<String> names) {
        this.logger.debug("retrieving preferences: user id=" + userId);
        Properties properties = new Properties();
        StatementLock.getInstance(VACUUM_LOCK_PREFERENCES_STATEMENT_ID).readLock();
        try {
            List result = SqlConfig.getInstance().getReadOnlySqlSessionManager().selectList("User.selectPreferencesForUser", (Object)userId);
            for (KeyValuePair pair : result) {
                if (!CollectionUtils.isEmpty(names) && !names.contains(pair.getKey())) continue;
                properties.setProperty(pair.getKey(), StringUtils.defaultString((String)pair.getValue()));
            }
        }
        catch (Exception e) {
            this.logger.error("Could not retrieve preferences: user id=" + userId, (Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_PREFERENCES_STATEMENT_ID).readUnlock();
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserPreference(Integer userId, String name) {
        this.logger.debug("retrieving preference: user id=" + userId + ", name=" + name);
        StatementLock.getInstance(VACUUM_LOCK_PREFERENCES_STATEMENT_ID).readLock();
        try {
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            parameterMap.put("person_id", userId);
            parameterMap.put("name", name);
            String string = (String)SqlConfig.getInstance().getReadOnlySqlSessionManager().selectOne("User.selectPreference", parameterMap);
            return string;
        }
        catch (Exception e) {
            this.logger.warn("Could not retrieve preference: user id=" + userId + ", name=" + name, (Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_PREFERENCES_STATEMENT_ID).readUnlock();
        }
        return null;
    }

    @Override
    public void removePreferencesForUser(int id) {
        this.logger.debug("deleting all preferences: user id=" + id);
        StatementLock.getInstance(VACUUM_LOCK_PREFERENCES_STATEMENT_ID).readLock();
        try {
            HashMap<String, Integer> parameterMap = new HashMap<String, Integer>();
            parameterMap.put("person_id", id);
            SqlConfig.getInstance().getSqlSessionManager().delete("User.deletePreference", parameterMap);
        }
        catch (Exception e) {
            this.logger.error("Could not delete preferences: user id=" + id);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_PREFERENCES_STATEMENT_ID).readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePreference(int id, String name) {
        this.logger.debug("deleting preference: user id=" + id + ", name=" + name);
        StatementLock.getInstance(VACUUM_LOCK_PREFERENCES_STATEMENT_ID).readLock();
        try {
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            parameterMap.put("category", id);
            parameterMap.put("name", name);
            SqlConfig.getInstance().getSqlSessionManager().delete("User.deletePreference", parameterMap);
        }
        catch (Exception e) {
            this.logger.error("Could not delete preference: user id=" + id + ", name=" + name, (Throwable)e);
        }
        finally {
            StatementLock.getInstance(VACUUM_LOCK_PREFERENCES_STATEMENT_ID).readUnlock();
        }
    }

    private LoginStatus handleSecondaryAuthentication(String username, LoginStatus loginStatus, LoginRequirementsChecker loginRequirementsChecker, String serverURL) {
        if (loginStatus != null && this.extensionController.getMultiFactorAuthenticationPlugin() != null && (loginStatus.getStatus() == LoginStatus.Status.SUCCESS || loginStatus.getStatus() == LoginStatus.Status.SUCCESS_GRACE_PERIOD)) {
            loginStatus = this.extensionController.getMultiFactorAuthenticationPlugin().authenticate(username, loginStatus, serverURL);
        }
        if (loginStatus.getStatus() == LoginStatus.Status.SUCCESS || loginStatus.getStatus() == LoginStatus.Status.SUCCESS_GRACE_PERIOD) {
            if (loginRequirementsChecker == null) {
                try {
                    loginRequirementsChecker = new LoginRequirementsChecker(this.getUser(null, username));
                }
                catch (ControllerException e) {
                    this.logger.warn("Unable to reset strikes for user \"" + username + "\": Could not find user.", (Throwable)e);
                }
            }
            if (loginRequirementsChecker != null) {
                loginRequirementsChecker.resetStrikes();
            }
        }
        return loginStatus;
    }
}

