/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.model.ConnectorMetaData;
import com.mirth.connect.model.MetaData;
import com.mirth.connect.model.PluginMetaData;
import com.mirth.connect.plugins.AuthorizationPlugin;
import com.mirth.connect.plugins.ChannelPlugin;
import com.mirth.connect.plugins.CodeTemplateServerPlugin;
import com.mirth.connect.plugins.DataTypeServerPlugin;
import com.mirth.connect.plugins.MultiFactorAuthenticationPlugin;
import com.mirth.connect.plugins.ResourcePlugin;
import com.mirth.connect.plugins.ServerPlugin;
import com.mirth.connect.plugins.ServicePlugin;
import com.mirth.connect.plugins.TransmissionModeProvider;
import com.mirth.connect.server.controllers.Controller;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.tools.ClassPathResource;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class ExtensionController
extends Controller {
    public static final String EXTENSIONS_UNINSTALL_FILE = "uninstall";
    public static final String EXTENSIONS_UNINSTALL_PROPERTIES_FILE = "uninstallProperties";
    public static final String EXTENSIONS_UNINSTALL_SCRIPTS_FILE = "uninstallScripts";

    public static String getExtensionsPath() {
        if (ClassPathResource.getResourceURI("extensions") != null) {
            return ClassPathResource.getResourceURI("extensions").getPath() + File.separator;
        }
        return ControllerFactory.getFactory().createConfigurationController().getBaseDir() + File.separator + "extensions" + File.separator;
    }

    public static ExtensionController getInstance() {
        return ControllerFactory.getFactory().createExtensionController();
    }

    public abstract List<String> getClientLibraries();

    public abstract void setDefaultExtensionStatus();

    public abstract void initPlugins();

    public abstract void setExtensionEnabled(String var1, boolean var2) throws ControllerException;

    public abstract boolean isExtensionEnabled(String var1);

    public abstract void startPlugins();

    public abstract void stopPlugins();

    public abstract Map<String, PluginMetaData> getPluginMetaData();

    public abstract void updatePluginProperties(String var1, Properties var2);

    public void setPluginProperties(String name, Properties properties) throws ControllerException {
        this.setPluginProperties(name, properties, false);
    }

    public abstract void setPluginProperties(String var1, Properties var2, boolean var3) throws ControllerException;

    public Properties getPluginProperties(String name) throws ControllerException {
        return this.getPluginProperties(name, null);
    }

    public abstract Properties getPluginProperties(String var1, Set<String> var2) throws ControllerException;

    public abstract Map<String, MetaData> getInvalidMetaData();

    public abstract Map<String, ConnectorMetaData> getConnectorMetaData();

    public abstract ConnectorMetaData getConnectorMetaDataByProtocol(String var1);

    public abstract ConnectorMetaData getConnectorMetaDataByTransportName(String var1);

    public abstract InstallationResult extractExtension(InputStream var1);

    public abstract void prepareExtensionForUninstallation(String var1) throws ControllerException;

    public abstract void uninstallExtensions();

    public abstract void removePropertiesForUninstalledExtensions();

    public abstract Map<String, ServicePlugin> getServicePlugins();

    public abstract Map<String, ChannelPlugin> getChannelPlugins();

    public abstract Map<String, CodeTemplateServerPlugin> getCodeTemplateServerPlugins();

    public abstract Map<String, DataTypeServerPlugin> getDataTypePlugins();

    public abstract Map<String, ResourcePlugin> getResourcePlugins();

    public abstract Map<String, TransmissionModeProvider> getTransmissionModeProviders();

    public abstract AuthorizationPlugin getAuthorizationPlugin();

    public abstract MultiFactorAuthenticationPlugin getMultiFactorAuthenticationPlugin();

    public abstract List<ServerPlugin> getServerPlugins();

    public class InstallationResult {
        private Throwable cause;
        private Set<MetaData> metaData;

        public InstallationResult(Throwable cause, Set<MetaData> metaData) {
            this.cause = cause;
            this.metaData = metaData;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public Set<MetaData> getMetaData() {
            return this.metaData;
        }
    }
}

