/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.server.MirthScopeProvider;
import com.mirth.connect.server.controllers.Controller;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ScriptCompileException;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import java.util.Map;

public abstract class ScriptController
extends Controller {
    public static final String GLOBAL_GROUP_ID = "Global";
    public static final String ATTACHMENT_SCRIPT_KEY = "Attachment";
    public static final String BATCH_SCRIPT_KEY = "Batch";
    public static final String POSTPROCESSOR_SCRIPT_KEY = "Postprocessor";
    public static final String PREPROCESSOR_SCRIPT_KEY = "Preprocessor";
    public static final String UNDEPLOY_SCRIPT_KEY = "Undeploy";
    public static final String DEPLOY_SCRIPT_KEY = "Deploy";
    public static final String RESPONSE_TRANSFORMER = "Response_Transformer";
    public static final String DELIMITER = "_";

    public static String getScriptId(String scriptKey) {
        return ScriptController.getScriptId(scriptKey, GLOBAL_GROUP_ID);
    }

    public static String getScriptId(String scriptKey, String groupId) {
        if (groupId != null && !groupId.equals(GLOBAL_GROUP_ID)) {
            return groupId + DELIMITER + scriptKey;
        }
        return scriptKey;
    }

    public static String getGroupId(String scriptId) {
        if (scriptId.contains(DELIMITER)) {
            return scriptId.substring(0, scriptId.indexOf(DELIMITER));
        }
        return GLOBAL_GROUP_ID;
    }

    public static String getScriptKey(String scriptId) {
        if (scriptId.contains(DELIMITER)) {
            return scriptId.substring(scriptId.indexOf(DELIMITER) + 1);
        }
        return scriptId;
    }

    public static boolean isScriptGlobal(String scriptId) {
        return ScriptController.getGroupId(scriptId).equals(GLOBAL_GROUP_ID);
    }

    public static ContextType getContextType(String scriptId) {
        boolean global = ScriptController.isScriptGlobal(scriptId);
        String scriptKey = ScriptController.getScriptKey(scriptId);
        if (scriptKey.equals(ATTACHMENT_SCRIPT_KEY)) {
            return ContextType.CHANNEL_ATTACHMENT;
        }
        if (scriptKey.equals(BATCH_SCRIPT_KEY)) {
            return ContextType.CHANNEL_BATCH;
        }
        if (scriptKey.equalsIgnoreCase(DEPLOY_SCRIPT_KEY)) {
            return global ? ContextType.GLOBAL_DEPLOY : ContextType.CHANNEL_DEPLOY;
        }
        if (scriptKey.equalsIgnoreCase(UNDEPLOY_SCRIPT_KEY)) {
            return global ? ContextType.GLOBAL_UNDEPLOY : ContextType.CHANNEL_UNDEPLOY;
        }
        if (scriptKey.equalsIgnoreCase(PREPROCESSOR_SCRIPT_KEY)) {
            return global ? ContextType.GLOBAL_PREPROCESSOR : ContextType.CHANNEL_PREPROCESSOR;
        }
        if (scriptKey.equalsIgnoreCase(POSTPROCESSOR_SCRIPT_KEY)) {
            return global ? ContextType.GLOBAL_POSTPROCESSOR : ContextType.CHANNEL_POSTPROCESSOR;
        }
        return null;
    }

    public static ScriptController getInstance() {
        return ControllerFactory.getFactory().createScriptController();
    }

    public abstract void putScript(String var1, String var2, String var3) throws ControllerException;

    public abstract String getScript(String var1, String var2) throws ControllerException;

    public abstract void removeScripts(String var1) throws ControllerException;

    public abstract Map<String, String> getGlobalScripts() throws ControllerException;

    public abstract void setGlobalScripts(Map<String, String> var1) throws ControllerException;

    public abstract void compileGlobalScripts(MirthContextFactory var1, boolean var2);

    public abstract void compileChannelScripts(MirthContextFactory var1, Channel var2) throws ScriptCompileException;

    public abstract void compileChannelScripts(Map<String, MirthContextFactory> var1, Channel var2) throws ScriptCompileException;

    public abstract void removeChannelScriptsFromCache(String var1);

    public abstract void executeGlobalDeployScript() throws Exception;

    public abstract void executeChannelDebugDeployScript(MirthContextFactory var1, String var2, String var3, MirthScopeProvider var4) throws Exception;

    public abstract void executeChannelDeployScript(MirthContextFactory var1, String var2, String var3) throws Exception;

    public abstract void executeGlobalUndeployScript() throws Exception;

    public abstract void executeChannelUndeployScript(MirthContextFactory var1, String var2, String var3) throws Exception;

    public abstract void executeChannelDebugUndeployScript(MirthContextFactory var1, String var2, String var3) throws Exception;
}

