/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.controllers;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelDependency;
import com.mirth.connect.model.ChannelGroup;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.LibraryProperties;
import com.mirth.connect.model.ResourceProperties;
import com.mirth.connect.model.ServerConfiguration;
import com.mirth.connect.model.ServerEventContext;
import com.mirth.connect.model.ServerSettings;
import com.mirth.connect.model.alert.AlertModel;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.plugins.MergePropertiesInterface;
import com.mirth.connect.plugins.ServicePlugin;
import com.mirth.connect.server.controllers.AlertController;
import com.mirth.connect.server.controllers.ChannelController;
import com.mirth.connect.server.controllers.CodeTemplateController;
import com.mirth.connect.server.controllers.ConfigurationController;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.EngineController;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.util.ConfigurationProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.util.MultiException;

public class ServerConfigurationRestorer {
    private Logger logger = LogManager.getLogger(this.getClass());
    private ConfigurationController configurationController;
    private ChannelController channelController;
    private AlertController alertController;
    private CodeTemplateController codeTemplateController;
    private EngineController engineController;
    private ScriptController scriptController;
    private ExtensionController extensionController;
    private ContextFactoryController contextFactoryController;

    public ServerConfigurationRestorer(ConfigurationController configurationController, ChannelController channelController, AlertController alertController, CodeTemplateController codeTemplateController, EngineController engineController, ScriptController scriptController, ExtensionController extensionController, ContextFactoryController contextFactoryController) {
        this.configurationController = configurationController;
        this.channelController = channelController;
        this.alertController = alertController;
        this.codeTemplateController = codeTemplateController;
        this.engineController = engineController;
        this.scriptController = scriptController;
        this.extensionController = extensionController;
        this.contextFactoryController = contextFactoryController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreServerConfiguration(ServerConfiguration serverConfiguration, boolean deploy, boolean overwriteConfigMap) throws ControllerException {
        MultiException multiException = new MultiException();
        EngineController engineController = this.engineController;
        synchronized (engineController) {
            this.restoreChannelGroups(serverConfiguration, multiException);
            this.restoreChannels(serverConfiguration, multiException);
            this.restoreAlerts(serverConfiguration, multiException);
            this.restoreCodeTemplateLibraries(serverConfiguration, multiException);
            this.restoreConfigurationMap(serverConfiguration, overwriteConfigMap, multiException);
            this.restoreServerSettings(serverConfiguration, multiException);
            this.restoreUpdateSettings(serverConfiguration, multiException);
            this.restorePluginProperties(serverConfiguration, multiException);
            this.restoreResourceProperties(serverConfiguration, multiException);
            this.restoreChannelDependencies(serverConfiguration, multiException);
            this.restoreChannelTags(serverConfiguration, multiException);
            this.restoreGlobalScripts(serverConfiguration, multiException);
            this.deployAllChannels(deploy, multiException);
        }
        if (multiException.size() > 0) {
            this.logger.error("Error restoring server configuration. ", (Throwable)multiException);
            for (Throwable throwable : multiException.getThrowables()) {
                if (throwable == null) continue;
                if (throwable.getCause() != null) {
                    this.logger.error(throwable.toString() + ", " + throwable.getCause().toString());
                    continue;
                }
                this.logger.error(throwable.toString());
            }
            throw new ControllerException("Restoring server configuration did not successfully complete. Partially restored server configuration. Please see the Server Log for more information.", (Throwable)multiException);
        }
    }

    void restoreChannelGroups(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            HashSet<ChannelGroup> channelGroups = new HashSet<ChannelGroup>();
            if (serverConfiguration.getChannelGroups() != null) {
                channelGroups.addAll(serverConfiguration.getChannelGroups());
            }
            this.channelController.updateChannelGroups(channelGroups, new HashSet<String>(), true);
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error restoring channel groups.", t));
        }
    }

    void restoreChannels(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            if (serverConfiguration.getChannels() != null) {
                MultiException subMultiException = new MultiException();
                this.undeployChannels(subMultiException);
                this.removeChannels(serverConfiguration, subMultiException);
                this.updateChannels(serverConfiguration, subMultiException);
                subMultiException.ifExceptionThrowMulti();
            }
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error restoring channels."));
            multiException.add(t);
        }
    }

    void undeployChannels(MultiException multiException) {
        try {
            this.engineController.undeployChannels(this.engineController.getDeployedIds(), ServerEventContext.SYSTEM_USER_EVENT_CONTEXT, null);
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error undeploying before restoring channels.", t));
        }
    }

    void removeChannels(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            MultiException subMultiException = new MultiException();
            for (Channel channel : this.channelController.getChannels(null)) {
                boolean found = false;
                for (Channel newChannel : serverConfiguration.getChannels()) {
                    if (!newChannel.getId().equals(channel.getId())) continue;
                    found = true;
                }
                if (found) continue;
                this.removeChannel(channel, subMultiException);
            }
            subMultiException.ifExceptionThrowMulti();
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error removing channels that no longer exist in the new server configuration."));
            multiException.add(t);
        }
    }

    void removeChannel(Channel channel, MultiException multiException) {
        try {
            this.channelController.removeChannel(channel, ServerEventContext.SYSTEM_USER_EVENT_CONTEXT);
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error removing channel that no longer exists in the new server configuration.\nName: " + channel.getName() + "\nId: " + channel.getId(), t));
        }
    }

    void updateChannels(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            MultiException subMultiException = new MultiException();
            for (Channel channel : serverConfiguration.getChannels()) {
                this.updateChannel(channel, subMultiException);
            }
            subMultiException.ifExceptionThrowMulti();
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error updating channels from the new server configuration."));
            multiException.add(t);
        }
    }

    void updateChannel(Channel channel, MultiException multiException) {
        try {
            this.channelController.updateChannel(channel, ServerEventContext.SYSTEM_USER_EVENT_CONTEXT, true, null);
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error updating channel from the new server configuration.\nName: " + channel.getName() + "\nId: " + channel.getId(), t));
        }
    }

    void restoreAlerts(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            if (serverConfiguration.getAlerts() != null) {
                MultiException subMultiException = new MultiException();
                this.removeExistingAlerts(subMultiException);
                this.updateNewAlerts(serverConfiguration, subMultiException);
                subMultiException.ifExceptionThrowMulti();
            }
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error restoring alerts from the new server configuration."));
            multiException.add(t);
        }
    }

    void removeExistingAlerts(MultiException multiException) {
        try {
            MultiException subMultiException = new MultiException();
            for (AlertModel alert : this.alertController.getAlerts()) {
                this.removeExistingAlert(alert, subMultiException);
            }
            subMultiException.ifExceptionThrowMulti();
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error removing existing alerts before restoring from the new server configuration."));
            multiException.add(t);
        }
    }

    void removeExistingAlert(AlertModel alert, MultiException multiException) {
        try {
            this.alertController.removeAlert(alert.getId());
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error removing existing alert before restoring from the new server configuration.\nName: " + alert.getName() + "\nId: " + alert.getId(), t));
        }
    }

    void updateNewAlerts(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            MultiException subMultiException = new MultiException();
            for (AlertModel alert : serverConfiguration.getAlerts()) {
                this.updateNewAlert(alert, subMultiException);
            }
            subMultiException.ifExceptionThrowMulti();
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error restoring new alerts from the new server configuration."));
            multiException.add(t);
        }
    }

    void updateNewAlert(AlertModel alert, MultiException multiException) {
        try {
            this.alertController.updateAlert(alert);
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error restoring new alert from the new server configuration.\nName: " + alert.getName() + "\nId: " + alert.getId(), t));
        }
    }

    void restoreCodeTemplateLibraries(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            if (serverConfiguration.getCodeTemplateLibraries() != null) {
                MultiException subMultiException = new MultiException();
                this.updateCodeTemplateLibraries(serverConfiguration, subMultiException);
                this.removeCodeTemplates(serverConfiguration, subMultiException);
                this.updateNewCodeTemplates(serverConfiguration, subMultiException);
                subMultiException.ifExceptionThrowMulti();
            }
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error restoring code template libraries from the new server configuration."));
            multiException.add(t);
        }
    }

    void updateCodeTemplateLibraries(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            if (serverConfiguration.getCodeTemplateLibraries() != null) {
                ArrayList<CodeTemplateLibrary> clonedLibraries = new ArrayList<CodeTemplateLibrary>();
                for (CodeTemplateLibrary library : serverConfiguration.getCodeTemplateLibraries()) {
                    clonedLibraries.add(new CodeTemplateLibrary(library));
                }
                this.codeTemplateController.updateLibraries(clonedLibraries, ServerEventContext.SYSTEM_USER_EVENT_CONTEXT, true);
            }
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error updating code template libraries from the new server configuration.", t));
        }
    }

    void removeCodeTemplates(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            MultiException subMultiException = new MultiException();
            for (CodeTemplate codeTemplate : this.codeTemplateController.getCodeTemplates(null)) {
                boolean found = false;
                for (CodeTemplateLibrary newLibrary : serverConfiguration.getCodeTemplateLibraries()) {
                    if (newLibrary.getCodeTemplates() != null) {
                        for (CodeTemplate newCodeTemplate : newLibrary.getCodeTemplates()) {
                            if (!newCodeTemplate.getId().equals(codeTemplate.getId())) continue;
                            found = true;
                            break;
                        }
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                this.removeCodeTemplate(codeTemplate, subMultiException);
            }
            subMultiException.ifExceptionThrowMulti();
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error removing code templates that no longer exist in the new server configuration."));
            multiException.add(t);
        }
    }

    void removeCodeTemplate(CodeTemplate codeTemplate, MultiException multiException) {
        try {
            this.codeTemplateController.removeCodeTemplate(codeTemplate.getId(), ServerEventContext.SYSTEM_USER_EVENT_CONTEXT);
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error removing code template that no longer exists in the new server configuration.\nName: " + codeTemplate.getName() + "\nId: " + codeTemplate.getId(), t));
        }
    }

    void updateNewCodeTemplates(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            MultiException subMultiException = new MultiException();
            for (CodeTemplateLibrary library : serverConfiguration.getCodeTemplateLibraries()) {
                if (library.getCodeTemplates() == null) continue;
                for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                    this.updateNewCodeTemplate(codeTemplate, subMultiException);
                }
            }
            subMultiException.ifExceptionThrowMulti();
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error updating new code templates from the new server configuration."));
            multiException.add(t);
        }
    }

    void updateNewCodeTemplate(CodeTemplate codeTemplate, MultiException multiException) {
        try {
            this.codeTemplateController.updateCodeTemplate(codeTemplate, ServerEventContext.SYSTEM_USER_EVENT_CONTEXT, true);
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error updating new code template from the new server configuration.\nName: " + codeTemplate.getName() + "\nId: " + codeTemplate.getId(), t));
        }
    }

    void restoreConfigurationMap(ServerConfiguration serverConfiguration, boolean overwriteConfigMap, MultiException multiException) {
        try {
            if (overwriteConfigMap) {
                if (serverConfiguration.getConfigurationMap() != null) {
                    this.configurationController.setConfigurationProperties(serverConfiguration.getConfigurationMap(), true);
                } else {
                    this.configurationController.setConfigurationProperties(new HashMap<String, ConfigurationProperty>(), true);
                }
            }
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error restoring configuration map.", t));
        }
    }

    void restoreServerSettings(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            if (serverConfiguration.getServerSettings() != null) {
                ServerSettings serverSettings = serverConfiguration.getServerSettings();
                serverSettings.setServerName(null);
                this.configurationController.setServerSettings(serverSettings);
            }
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error restoring server settings.", t));
        }
    }

    void restoreUpdateSettings(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            if (serverConfiguration.getUpdateSettings() != null) {
                this.configurationController.setUpdateSettings(serverConfiguration.getUpdateSettings());
            }
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error restoring update settings.", t));
        }
    }

    void restorePluginProperties(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            if (serverConfiguration.getPluginProperties() != null) {
                MultiException subMultiException = new MultiException();
                for (Map.Entry<String, Properties> pluginEntry : serverConfiguration.getPluginProperties().entrySet()) {
                    this.restorePluginProperties(pluginEntry.getKey(), pluginEntry.getValue(), subMultiException);
                }
                subMultiException.ifExceptionThrowMulti();
            }
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error restoring plugin properties."));
            multiException.add(t);
        }
    }

    void restorePluginProperties(String pluginName, Properties properties, MultiException multiException) {
        try {
            ServicePlugin servicePlugin = this.extensionController.getServicePlugins().get(pluginName);
            if (servicePlugin instanceof MergePropertiesInterface) {
                ((MergePropertiesInterface)((Object)servicePlugin)).modifyPropertiesOnRestore(properties);
            }
            this.extensionController.setPluginProperties(pluginName, properties);
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error restoring properties for plugin: " + pluginName, t));
        }
    }

    void restoreResourceProperties(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            if (serverConfiguration.getResourceProperties() != null) {
                this.configurationController.setResources(ObjectXMLSerializer.getInstance().serialize(serverConfiguration.getResourceProperties()));
                ArrayList<LibraryProperties> libraryResources = new ArrayList<LibraryProperties>();
                for (ResourceProperties resource : serverConfiguration.getResourceProperties().getList()) {
                    if (!(resource instanceof LibraryProperties)) continue;
                    libraryResources.add((LibraryProperties)resource);
                }
                this.contextFactoryController.updateResources(libraryResources, false);
            }
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error restoring resource properties.", t));
        }
    }

    void restoreChannelDependencies(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            if (serverConfiguration.getChannelDependencies() != null) {
                this.configurationController.setChannelDependencies(serverConfiguration.getChannelDependencies());
            } else {
                this.configurationController.setChannelDependencies(new HashSet<ChannelDependency>());
            }
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error restoring channel dependencies.", t));
        }
    }

    void restoreChannelTags(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            if (serverConfiguration.getChannelTags() != null) {
                this.configurationController.setChannelTags(serverConfiguration.getChannelTags());
            } else {
                this.configurationController.setChannelTags(new HashSet<ChannelTag>());
            }
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error restoring channel tags.", t));
        }
    }

    void restoreGlobalScripts(ServerConfiguration serverConfiguration, MultiException multiException) {
        try {
            if (serverConfiguration.getGlobalScripts() != null) {
                this.scriptController.setGlobalScripts(serverConfiguration.getGlobalScripts());
            }
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error restoring global scripts.", t));
        }
    }

    void deployAllChannels(boolean deploy, MultiException multiException) {
        try {
            if (deploy) {
                this.engineController.deployChannels(this.channelController.getChannelIds(), ServerEventContext.SYSTEM_USER_EVENT_CONTEXT, null, new DebugOptions());
            }
        }
        catch (Throwable t) {
            multiException.add((Throwable)new ControllerException("Error deploying channels after restoring server configuration.", t));
        }
    }

    ConfigurationController getConfigurationController() {
        return this.configurationController;
    }

    ChannelController getChannelController() {
        return this.channelController;
    }

    AlertController getAlertController() {
        return this.alertController;
    }

    CodeTemplateController getCodeTemplateController() {
        return this.codeTemplateController;
    }

    EngineController getEngineController() {
        return this.engineController;
    }

    ScriptController getScriptController() {
        return this.scriptController;
    }

    ExtensionController getExtensionController() {
        return this.extensionController;
    }

    ContextFactoryController getContextFactoryController() {
        return this.contextFactoryController;
    }
}

