/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.event;

import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.server.event.EventType;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class EventListener
implements Runnable {
    private Thread workerThread = new Thread((Runnable)this, this.getClass().getSimpleName() + " Consumer Thread");
    protected BlockingQueue<Event> queue = new LinkedBlockingQueue<Event>();

    public EventListener() {
        this.workerThread.start();
    }

    public BlockingQueue<Event> getQueue() {
        return this.queue;
    }

    public void shutdown() {
        this.workerThread.interrupt();
        this.onShutdown();
    }

    protected abstract void onShutdown();

    public abstract Set<EventType> getEventTypes();

    protected abstract void processEvent(Event var1);

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Event event = this.queue.take();
                this.processEvent(event);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable throwable) {}
        }
    }
}

