/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.extprops;

import com.mirth.connect.server.extprops.ExtensionStatusFile;
import com.mirth.connect.server.extprops.ExtensionStatusInterface;
import com.mirth.connect.server.extprops.ExtensionStatusProvider;
import com.mirth.connect.server.extprops.LoggerWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class ExtensionStatuses
implements ExtensionStatusInterface {
    private static ExtensionStatuses instance = null;
    private LoggerWrapper logger;
    private Properties mirthProperties = new Properties();
    private ExtensionStatusProvider provider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExtensionStatuses getInstance() {
        ExtensionStatuses provider = instance;
        if (provider != null) return provider;
        Class<ExtensionStatuses> clazz = ExtensionStatuses.class;
        synchronized (ExtensionStatuses.class) {
            provider = instance;
            if (provider != null) return provider;
            instance = provider = new ExtensionStatuses();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return provider;
        }
    }

    private ExtensionStatuses() {
        try {
            this.logger = new LoggerWrapper(Thread.currentThread().getContextClassLoader().loadClass("org.apache.log4j.Logger").getMethod("getLogger", Class.class).invoke(null, ExtensionStatuses.class));
        }
        catch (Throwable t) {
            this.logger = new LoggerWrapper(null);
        }
        try {
            FileInputStream is = new FileInputStream(new File("./conf/mirth.properties"));
            try {
                this.mirthProperties.load(is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to read mirth.properties.", e);
        }
        String providerClass = this.mirthProperties.getProperty("extension.properties.provider");
        if (providerClass != null && !providerClass.isEmpty() && !"file".equalsIgnoreCase(providerClass)) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(providerClass);
                this.provider = (ExtensionStatusProvider)clazz.getConstructor(Properties.class).newInstance(this.mirthProperties);
            }
            catch (Throwable t) {
                this.logger.error("Unable to instantiate provider class: " + providerClass, t);
            }
        }
        if (this.provider == null) {
            this.provider = new ExtensionStatusFile(this.mirthProperties);
        }
    }

    @Override
    public void reload() {
        if (this.provider != null) {
            this.provider.reload();
        }
    }

    @Override
    public Set<String> keySet() {
        if (this.provider != null) {
            return this.provider.keySet();
        }
        return new HashSet<String>();
    }

    @Override
    public boolean containsKey(String pluginName) {
        if (this.provider != null) {
            return this.provider.containsKey(pluginName);
        }
        return false;
    }

    @Override
    public boolean isEnabled(String pluginName) {
        if (this.provider != null) {
            return this.provider.isEnabled(pluginName);
        }
        return true;
    }

    @Override
    public void setEnabled(String pluginName, boolean enabled) {
        if (this.provider != null) {
            this.provider.setEnabled(pluginName, enabled);
        }
    }

    @Override
    public void remove(String pluginName) {
        if (this.provider != null) {
            this.provider.remove(pluginName);
        }
    }

    @Override
    public void save() {
        if (this.provider != null) {
            this.provider.save();
        }
    }
}

