/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.extprops;

public class LoggerWrapper {
    private Object logger;

    public LoggerWrapper(Object logger) {
        this.logger = logger;
    }

    public void error(Object message) {
        this.error(message, null);
    }

    public void error(Object message, Throwable t) {
        this.call("error", message, t);
    }

    public void warn(Object message) {
        this.warn(message, null);
    }

    public void warn(Object message, Throwable t) {
        this.call("warn", message, t);
    }

    public void debug(Object message) {
        this.debug(message, null);
    }

    public void debug(Object message, Throwable t) {
        this.call("debug", message, t);
    }

    public void trace(Object message) {
        this.trace(message, null);
    }

    public void trace(Object message, Throwable t) {
        this.call("trace", message, t);
    }

    private void call(String methodName, Object message, Throwable t) {
        if (this.logger != null) {
            try {
                this.logger.getClass().getMethod(methodName, Object.class, Throwable.class).invoke(this.logger, message, t);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
        } else {
            if (message != null) {
                System.err.println(message.toString());
            }
            if (t != null) {
                t.printStackTrace();
            }
        }
    }
}

