/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.logging;

import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JuliToLog4jHandler
extends Handler {
    @Override
    public void publish(LogRecord record) {
        Logger log4j = JuliToLog4jHandler.getTargetLogger(record.getLoggerName());
        Level priority = JuliToLog4jHandler.toLog4j(record.getLevel());
        log4j.log(priority, this.toLog4jMessage(record), record.getThrown());
    }

    static Logger getTargetLogger(String loggerName) {
        return LogManager.getLogger((String)loggerName);
    }

    public static Logger getTargetLogger(Class<?> clazz) {
        return JuliToLog4jHandler.getTargetLogger(clazz.getName());
    }

    private String toLog4jMessage(LogRecord record) {
        String message = record.getMessage();
        try {
            Object[] parameters = record.getParameters();
            if (parameters != null && parameters.length != 0 && (message.indexOf("{0}") >= 0 || message.indexOf("{1}") >= 0 || message.indexOf("{2}") >= 0 || message.indexOf("{3}") >= 0)) {
                message = MessageFormat.format(message, parameters);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return message;
    }

    private static Level toLog4j(java.util.logging.Level level) {
        if (java.util.logging.Level.OFF == level) {
            return Level.OFF;
        }
        if (java.util.logging.Level.SEVERE == level) {
            return Level.ERROR;
        }
        if (java.util.logging.Level.WARNING == level) {
            return Level.WARN;
        }
        if (java.util.logging.Level.INFO == level) {
            return Level.INFO;
        }
        if (java.util.logging.Level.CONFIG == level) {
            return Level.DEBUG;
        }
        if (java.util.logging.Level.FINE == level) {
            return Level.TRACE;
        }
        if (java.util.logging.Level.FINER == level) {
            return Level.TRACE;
        }
        if (java.util.logging.Level.FINEST == level) {
            return Level.TRACE;
        }
        if (java.util.logging.Level.ALL == level) {
            return Level.ALL;
        }
        return Level.INFO;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

