/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.mbeans;

import com.mirth.connect.client.core.ControllerException;
import com.mirth.connect.server.Command;
import com.mirth.connect.server.CommandQueue;
import com.mirth.connect.server.Mirth;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.mbeans.MirthServiceMBean;
import java.util.Properties;

public class MirthService
implements MirthServiceMBean {
    private Mirth mirthServer = null;
    private final String EXTENSION_NAME = "Extension Manager";

    @Override
    public void start() {
        if (this.mirthServer == null || !this.mirthServer.isAlive()) {
            this.createProperties();
            this.mirthServer = new Mirth();
            this.mirthServer.start();
        }
    }

    @Override
    public void stop() {
        CommandQueue queue = CommandQueue.getInstance();
        queue.addCommand(new Command(Command.Operation.SHUTDOWN_SERVER));
    }

    private void createProperties() {
        ExtensionController extensionController = ControllerFactory.getFactory().createExtensionController();
        Properties props = null;
        try {
            props = extensionController.getPluginProperties("Extension Manager");
        }
        catch (ControllerException controllerException) {
            // empty catch block
        }
        if (props == null) {
            props = new Properties();
        }
        props.setProperty("disableInstall", "true");
        try {
            extensionController.setPluginProperties("Extension Manager", props);
        }
        catch (ControllerException controllerException) {
            // empty catch block
        }
    }
}

