/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.message;

import com.mirth.connect.donkey.model.message.MessageSerializer;
import com.mirth.connect.donkey.model.message.SerializationType;
import com.mirth.connect.donkey.server.message.AutoResponder;
import com.mirth.connect.donkey.server.message.DataType;
import com.mirth.connect.model.converters.IMessageSerializer;
import com.mirth.connect.model.datatype.DataTypeProperties;
import com.mirth.connect.model.datatype.SerializerProperties;
import com.mirth.connect.plugins.DataTypeServerPlugin;
import com.mirth.connect.server.controllers.ExtensionController;
import com.mirth.connect.server.message.DefaultAutoResponder;

public class DataTypeFactory {
    public static DataType getDataType(String dataType, DataTypeProperties dataTypeProperties, boolean inbound) {
        DataTypeServerPlugin dataTypePlugin = ExtensionController.getInstance().getDataTypePlugins().get(dataType);
        SerializerProperties serializerProperties = dataTypeProperties.getSerializerProperties();
        IMessageSerializer serializer = dataTypePlugin.getSerializer(serializerProperties);
        AutoResponder autoResponder = dataTypePlugin.getAutoResponder(serializerProperties.getSerializationProperties(), dataTypeProperties.getResponseGenerationProperties());
        if (autoResponder == null) {
            autoResponder = new DefaultAutoResponder();
        }
        SerializationType serializationType = DataTypeFactory.getSerializationType(dataTypePlugin, dataTypeProperties, inbound);
        SerializationType templateSerializationType = DataTypeFactory.getSerializationType(dataTypePlugin, dataTypeProperties, true);
        return new DataType(dataType, (MessageSerializer)serializer, autoResponder, serializationType, templateSerializationType);
    }

    public static SerializationType getSerializationType(String dataType, DataTypeProperties dataTypeProperties, boolean useSerializationProperties) {
        DataTypeServerPlugin dataTypePlugin = ExtensionController.getInstance().getDataTypePlugins().get(dataType);
        return DataTypeFactory.getSerializationType(dataTypePlugin, dataTypeProperties, useSerializationProperties);
    }

    public static SerializationType getSerializationType(DataTypeServerPlugin dataTypePlugin, DataTypeProperties dataTypeProperties, boolean useSerializationProperties) {
        SerializationType serializationType = null;
        if (dataTypeProperties != null) {
            if (useSerializationProperties) {
                if (dataTypeProperties.getSerializationProperties() != null) {
                    serializationType = dataTypeProperties.getSerializationProperties().getSerializationType();
                }
            } else if (dataTypeProperties.getDeserializationProperties() != null) {
                serializationType = dataTypeProperties.getDeserializationProperties().getSerializationType();
            }
        }
        if (serializationType == null) {
            serializationType = dataTypePlugin.getDefaultSerializationType();
        }
        return serializationType;
    }
}

