/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.message;

import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.message.batch.BatchAdaptor;
import com.mirth.connect.donkey.server.message.batch.BatchAdaptorFactory;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.model.datatype.BatchProperties;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.message.DebuggableBatchAdaptorFactory;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import org.mozilla.javascript.tools.debugger.MirthMain;

public abstract class DebuggableBatchAdaptor
extends BatchAdaptor {
    private BatchProperties batchProperties;

    public DebuggableBatchAdaptor(BatchAdaptorFactory factory, SourceConnector sourceConnector, BatchRawMessage batchRawMessage) {
        super(factory, sourceConnector, batchRawMessage);
    }

    public BatchProperties getBatchProperties() {
        return this.batchProperties;
    }

    public void setBatchProperties(BatchProperties batchProperties) {
        this.batchProperties = batchProperties;
    }

    protected void triggerDebug(boolean debug) {
        DebuggableBatchAdaptorFactory factory;
        MirthMain debugger;
        if (debug && (debugger = (factory = (DebuggableBatchAdaptorFactory)this.getFactory()).getDebugger()) != null && !factory.isIgnoreBreakpoints()) {
            debugger.doBreak();
            if (!debugger.isVisible()) {
                debugger.setVisible(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MirthContextFactory getContextFactoryAndRecompile(ContextFactoryController contextFactoryController, boolean debug, String batchScriptId, String batchScript) throws Exception {
        MirthContextFactory contextFactory = JavaScriptUtil.generateContextFactory(debug, this.sourceConnector.getChannel().getResourceIds(), this.sourceConnector.getChannelId(), batchScriptId, batchScript, ContextType.CHANNEL_BATCH);
        DebuggableBatchAdaptorFactory factory = (DebuggableBatchAdaptorFactory)this.getFactory();
        if (!factory.getContextFactoryId().equals(contextFactory.getId())) {
            DebuggableBatchAdaptorFactory debuggableBatchAdaptorFactory = factory;
            synchronized (debuggableBatchAdaptorFactory) {
                contextFactory = contextFactoryController.getContextFactory(this.sourceConnector.getChannel().getResourceIds());
                if (!factory.getContextFactoryId().equals(contextFactory.getId())) {
                    JavaScriptUtil.recompileGeneratedScript(contextFactory, batchScriptId);
                    factory.setContextFactoryId(contextFactory.getId());
                }
            }
        }
        return contextFactory;
    }
}

