/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.message;

import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.DeployException;
import com.mirth.connect.donkey.server.UndeployException;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.message.batch.BatchAdaptorFactory;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.model.datatype.BatchProperties;
import com.mirth.connect.model.datatype.SerializerProperties;
import com.mirth.connect.server.MirthScopeProvider;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.tools.debugger.MirthMain;

public abstract class DebuggableBatchAdaptorFactory
extends BatchAdaptorFactory {
    protected ContextFactoryController contextFactoryController = this.getContextFactoryController();
    protected BatchProperties batchProperties;
    protected boolean debug = false;
    protected MirthMain debugger;
    protected MirthScopeProvider scopeProvider = new MirthScopeProvider();
    protected String batchScriptId;
    protected boolean ignoreBreakpoints = false;
    private volatile String contextFactoryId;

    public DebuggableBatchAdaptorFactory(SourceConnector sourceConnector, SerializerProperties serializerProperties) {
        super(sourceConnector);
        this.batchProperties = serializerProperties.getBatchProperties();
    }

    public MirthMain getDebugger() {
        return this.debugger;
    }

    public void setDebugger(MirthMain debugger) {
        this.debugger = debugger;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isIgnoreBreakpoints() {
        return this.ignoreBreakpoints;
    }

    public String getContextFactoryId() {
        return this.contextFactoryId;
    }

    public void setContextFactoryId(String contextFactoryId) {
        this.contextFactoryId = contextFactoryId;
    }

    public void onDeploy() throws DeployException {
        String batchScript = this.batchProperties.getBatchScript();
        boolean bl = this.debug = this.sourceConnector.getChannel().getDebugOptions() != null && this.sourceConnector.getChannel().getDebugOptions().isAttachmentBatchScripts();
        if (StringUtils.isNotEmpty((CharSequence)batchScript)) {
            this.batchScriptId = ScriptController.getScriptId("Batch", this.sourceConnector.getChannelId());
            try {
                MirthContextFactory contextFactory = this.generateContextFactory(this.debug, batchScript);
                this.setContextFactoryId(contextFactory.getId());
                if (this.debug) {
                    this.setDebugger(this.getDebugger(contextFactory, false));
                }
            }
            catch (Exception e) {
                throw new DeployException("Error compiling " + this.sourceConnector.getConnectorProperties().getName() + " script " + this.batchScriptId + ".", (Throwable)e);
            }
        }
    }

    public void onUndeploy() throws UndeployException {
        if (this.debug && this.debugger != null) {
            this.contextFactoryController.removeDebugContextFactory(this.sourceConnector.getChannel().getResourceIds(), this.sourceConnector.getChannelId(), this.batchScriptId);
            this.debugger.dispose();
            this.debugger = null;
        }
    }

    public void start() throws ConnectorTaskException, InterruptedException {
        this.ignoreBreakpoints = false;
        if (this.debug && this.debugger != null) {
            this.debugger.enableDebugging();
        }
        super.start();
    }

    public void stop() throws ConnectorTaskException, InterruptedException {
        this.ignoreBreakpoints = true;
        if (this.debug && this.debugger != null) {
            this.debugger.finishScriptExecution();
        }
        super.stop();
    }

    protected ContextFactoryController getContextFactoryController() {
        return ControllerFactory.getFactory().createContextFactoryController();
    }

    protected MirthMain getDebugger(MirthContextFactory contextFactory, boolean showDebugger) {
        return MirthMain.mirthMainEmbedded(contextFactory, this.scopeProvider, this.sourceConnector.getChannel().getName() + "-" + this.sourceConnector.getChannelId(), this.batchScriptId, showDebugger);
    }

    protected MirthContextFactory generateContextFactory(boolean debug, String script) throws ConnectorTaskException {
        return JavaScriptUtil.generateContextFactory(debug, this.sourceConnector.getChannel().getResourceIds(), this.sourceConnector.getChannelId(), this.batchScriptId, script, ContextType.CHANNEL_BATCH);
    }
}

