/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.migration;

import com.mirth.connect.donkey.util.DonkeyElement;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.util.MigrationException;
import com.mirth.connect.server.migration.ConfigurationMigrator;
import com.mirth.connect.server.migration.Migrator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.swing.text.DateFormatter;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Migrate3_3_0
extends Migrator
implements ConfigurationMigrator {
    private Logger logger = LogManager.getLogger(this.getClass());
    private ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();

    @Override
    public void migrate() throws MigrationException {
        this.executeScript(this.getDatabaseType() + "-3.2.2-3.3.0.sql");
        this.migrateCodeTemplates();
        this.migrateDataPrunerConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateCodeTemplates() {
        block22: {
            PreparedStatement preparedStatement = null;
            ResultSet results = null;
            try {
                PreparedStatement updateStatement;
                ArrayList<String> codeTemplateIds;
                Connection connection;
                block20: {
                    connection = this.getConnection();
                    connection.setAutoCommit(false);
                    codeTemplateIds = new ArrayList<String>();
                    preparedStatement = connection.prepareStatement("SELECT ID, CODE_TEMPLATE FROM OLD_CODE_TEMPLATE");
                    results = preparedStatement.executeQuery();
                    updateStatement = null;
                    updateStatement = connection.prepareStatement("INSERT INTO CODE_TEMPLATE (ID, NAME, REVISION, CODE_TEMPLATE) VALUES (?, ?, ?, ?)");
                    block17: while (true) {
                        while (results.next()) {
                            String codeTemplateId = "";
                            try {
                                codeTemplateId = results.getString(1);
                                String codeTemplate = results.getString(2);
                                String name = new DonkeyElement(codeTemplate).getChildElement("name").getTextContent();
                                Integer revision = 1;
                                updateStatement.setString(1, codeTemplateId);
                                updateStatement.setString(2, name);
                                updateStatement.setInt(3, revision);
                                updateStatement.setString(4, codeTemplate);
                                updateStatement.executeUpdate();
                                codeTemplateIds.add(codeTemplateId);
                                continue block17;
                            }
                            catch (Exception e) {
                                this.logger.error("Error migrating code template " + codeTemplateId + ".", (Throwable)e);
                            }
                        }
                        break block20;
                        {
                            continue block17;
                            break;
                        }
                        break;
                    }
                    finally {
                        DbUtils.closeQuietly((Statement)updateStatement);
                    }
                }
                try {
                    String libraryId = UUID.randomUUID().toString();
                    String name = "Library 1";
                    Integer revision = 1;
                    DonkeyElement libraryElement = new DonkeyElement("<codeTemplateLibrary/>");
                    libraryElement.setAttribute("version", "3.3.0");
                    libraryElement.addChildElement("id", libraryId);
                    libraryElement.addChildElement("name", name);
                    libraryElement.addChildElement("revision", String.valueOf(revision));
                    try {
                        libraryElement.addChildElementFromXml(this.serializer.serialize(Calendar.getInstance())).setNodeName("lastModified");
                    }
                    catch (DonkeyElement.DonkeyElementException e) {
                        throw new SerializerException("Failed to migrate code template library last modified date.", (Throwable)e);
                    }
                    libraryElement.addChildElement("description", "This library was added upon migration to version 3.3.0. It includes all pre-existing\ncode templates, and is set to be included on all pre-existing and new channels.\n\nYou should create your own new libraries and assign code templates to them as you\nsee fit. You should also link libraries to specific channels, so that you're not\nnecessarily including all code templates on all channels all the time.");
                    libraryElement.addChildElement("includeNewChannels", "true");
                    libraryElement.addChildElement("enabledChannelIds");
                    libraryElement.addChildElement("disabledChannelIds");
                    DonkeyElement codeTemplatesElement = libraryElement.addChildElement("codeTemplates");
                    for (String codeTemplateId : codeTemplateIds) {
                        DonkeyElement codeTemplateElement = codeTemplatesElement.addChildElement("codeTemplate");
                        codeTemplateElement.setAttribute("version", "3.3.0");
                        codeTemplateElement.addChildElement("id", codeTemplateId);
                    }
                    String libraryXml = libraryElement.toXml();
                    try {
                        updateStatement = connection.prepareStatement("INSERT INTO CODE_TEMPLATE_LIBRARY (ID, NAME, REVISION, LIBRARY) VALUES (?, ?, ?, ?)");
                        updateStatement.setString(1, libraryId);
                        updateStatement.setString(2, name);
                        updateStatement.setInt(3, revision);
                        updateStatement.setString(4, libraryXml);
                        updateStatement.executeUpdate();
                    }
                    finally {
                        DbUtils.closeQuietly((Statement)updateStatement);
                    }
                }
                catch (Exception e) {
                    this.logger.error("Error creating code template library for migration.", (Throwable)e);
                }
                connection.commit();
                DbUtils.closeQuietly((ResultSet)results);
            }
            catch (SQLException e) {
                this.logger.error("Error migrating code templates.", (Throwable)e);
                break block22;
            }
            finally {
                DbUtils.closeQuietly(results);
                DbUtils.closeQuietly(preparedStatement);
            }
            DbUtils.closeQuietly((Statement)preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateDataPrunerConfiguration() {
        boolean enabled = true;
        String time = "";
        String interval = "";
        String dayOfWeek = "";
        String dayOfMonth = "1";
        ResultSet results = null;
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            try {
                statement = connection.prepareStatement("SELECT NAME, VALUE FROM CONFIGURATION WHERE CATEGORY = 'Data Pruner'");
                results = statement.executeQuery();
                while (results.next()) {
                    String name = results.getString(1);
                    String value = results.getString(2);
                    if (name.equals("interval")) {
                        interval = value;
                        continue;
                    }
                    if (name.equals("time")) {
                        time = value;
                        continue;
                    }
                    if (name.equals("dayOfWeek")) {
                        dayOfWeek = value;
                        continue;
                    }
                    if (!name.equals("dayOfMonth")) continue;
                    dayOfMonth = value;
                }
            }
            catch (SQLException e) {
                try {
                    this.logger.error("Failed to read Data Pruner configuration properties.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly((Statement)statement);
                    DbUtils.closeQuietly(results);
                    throw throwable;
                }
                DbUtils.closeQuietly((Statement)statement);
                DbUtils.closeQuietly((ResultSet)results);
            }
            DbUtils.closeQuietly((Statement)statement);
            DbUtils.closeQuietly((ResultSet)results);
            enabled = !interval.equals("disabled");
            String pollingType = "INTERVAL";
            String pollingHour = "12";
            String pollingMinute = "0";
            boolean weekly = !StringUtils.equals((CharSequence)interval, (CharSequence)"monthly");
            boolean[] activeDays = new boolean[]{true, true, true, true, true, true, true, true};
            if (enabled && !StringUtils.equals((CharSequence)interval, (CharSequence)"hourly")) {
                SimpleDateFormat timeDateFormat = new SimpleDateFormat("hh:mm aa");
                DateFormatter timeFormatter = new DateFormatter(timeDateFormat);
                Date timeDate = null;
                try {
                    timeDate = (Date)timeFormatter.stringToValue(time);
                    Calendar timeCalendar = Calendar.getInstance();
                    timeCalendar.setTime(timeDate);
                    pollingType = "TIME";
                    pollingHour = String.valueOf(timeCalendar.get(11));
                    pollingMinute = String.valueOf(timeCalendar.get(12));
                    if (StringUtils.equals((CharSequence)interval, (CharSequence)"weekly")) {
                        SimpleDateFormat dayDateFormat = new SimpleDateFormat("EEEEEEEE");
                        DateFormatter dayFormatter = new DateFormatter(dayDateFormat);
                        Date dayDate = (Date)dayFormatter.stringToValue(dayOfWeek);
                        Calendar dayCalendar = Calendar.getInstance();
                        dayCalendar.setTime(dayDate);
                        activeDays = new boolean[]{false, false, false, false, false, false, false, false};
                        activeDays[dayCalendar.get((int)7)] = true;
                    }
                }
                catch (Exception e) {
                    this.logger.error("Failed to get Data Pruner time properties", (Throwable)e);
                }
            }
            DonkeyElement pollingProperties = new DonkeyElement("<com.mirth.connect.donkey.model.channel.PollConnectorProperties/>");
            pollingProperties.setAttribute("version", "3.3.0");
            pollingProperties.addChildElementIfNotExists("pollingType", pollingType);
            pollingProperties.addChildElementIfNotExists("pollOnStart", "false");
            pollingProperties.addChildElementIfNotExists("pollingFrequency", "3600000");
            pollingProperties.addChildElementIfNotExists("pollingHour", pollingHour);
            pollingProperties.addChildElementIfNotExists("pollingMinute", pollingMinute);
            pollingProperties.addChildElementIfNotExists("cronJobs");
            DonkeyElement advancedProperties = pollingProperties.addChildElementIfNotExists("pollConnectorPropertiesAdvanced");
            advancedProperties.addChildElementIfNotExists("weekly", weekly ? "true" : "false");
            DonkeyElement inactiveDays = advancedProperties.addChildElementIfNotExists("inactiveDays");
            if (inactiveDays != null) {
                for (int index = 0; index < 8; ++index) {
                    inactiveDays.addChildElement("boolean", activeDays[index] ? "false" : "true");
                }
            }
            advancedProperties.addChildElementIfNotExists("dayOfMonth", dayOfMonth);
            advancedProperties.addChildElementIfNotExists("allDay", "true");
            advancedProperties.addChildElementIfNotExists("startingHour", "8");
            advancedProperties.addChildElementIfNotExists("startingMinute", "0");
            advancedProperties.addChildElementIfNotExists("endingHour", "17");
            advancedProperties.addChildElementIfNotExists("endingMinute", "0");
            PreparedStatement inputStatement = null;
            try {
                inputStatement = connection.prepareStatement("INSERT INTO CONFIGURATION (CATEGORY, NAME, VALUE) VALUES (?, ?, ?)");
                inputStatement.setString(1, "Data Pruner");
                inputStatement.setString(2, "pollingProperties");
                inputStatement.setString(3, pollingProperties.toXml());
                inputStatement.executeUpdate();
            }
            catch (Exception e) {
                this.logger.error("Failed to insert Data Pruner configuration pollingProperties.", (Throwable)e);
            }
            finally {
                DbUtils.closeQuietly((Statement)inputStatement);
            }
            PreparedStatement updateStatement = null;
            try {
                updateStatement = connection.prepareStatement("UPDATE CONFIGURATION SET NAME = ?, VALUE = ? WHERE CATEGORY = ? AND NAME = ?");
                updateStatement.setString(1, "enabled");
                updateStatement.setString(2, enabled ? "true" : "false");
                updateStatement.setString(3, "Data Pruner");
                updateStatement.setString(4, "interval");
                updateStatement.executeUpdate();
            }
            finally {
                DbUtils.closeQuietly((Statement)updateStatement);
            }
            PreparedStatement deleteStatement = null;
            try {
                deleteStatement = connection.prepareStatement("DELETE FROM CONFIGURATION WHERE CATEGORY = ? AND NAME IN (?, ?, ?)");
                deleteStatement.setString(1, "Data Pruner");
                deleteStatement.setString(2, "time");
                deleteStatement.setString(3, "dayOfWeek");
                deleteStatement.setString(4, "dayOfMonth");
                deleteStatement.executeUpdate();
            }
            finally {
                DbUtils.closeQuietly((Statement)deleteStatement);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to modify Data Pruner configuration properties", (Throwable)e);
        }
    }

    @Override
    public void migrateSerializedData() throws MigrationException {
    }

    @Override
    public Map<String, Object> getConfigurationPropertiesToAdd() {
        LinkedHashMap<String, Object> propertiesToAdd = new LinkedHashMap<String, Object>();
        propertiesToAdd.put("server.startupdeploy", new MutablePair((Object)true, (Object)"Determines whether or not channels are deployed on server startup."));
        return propertiesToAdd;
    }

    @Override
    public String[] getConfigurationPropertiesToRemove() {
        return null;
    }

    @Override
    public void updateConfiguration(PropertiesConfiguration configuration) {
    }
}

