/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.migration;

import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.util.MigrationException;
import com.mirth.connect.server.migration.Migrator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;

public class Migrate4_6_0
extends Migrator {
    @Override
    public void migrate() throws MigrationException {
        Connection connection = null;
        Statement selectStatement = null;
        PreparedStatement updateStatement = null;
        ResultSet resultSet = null;
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        try {
            connection = this.getConnection();
            selectStatement = connection.createStatement();
            resultSet = selectStatement.executeQuery("SELECT ID, CHANNEL FROM CHANNEL");
            while (resultSet.next()) {
                Channel obj;
                String id = resultSet.getString(1);
                String serializedData = resultSet.getString(2);
                Channel channel = obj = serializer.deserialize(serializedData, Channel.class);
                boolean changed = false;
                if (channel.getProperties() != null && channel.getProperties().getMetaDataColumns() != null) {
                    for (MetaDataColumn col : channel.getProperties().getMetaDataColumns()) {
                        if ("mirth_type".equals(col.getMappingName())) {
                            col.setMappingName("message_type");
                            changed = true;
                            continue;
                        }
                        if (!"mirth_source".equals(col.getMappingName())) continue;
                        col.setMappingName("message_source");
                        changed = true;
                    }
                }
                if (!changed) continue;
                String migratedData = serializer.serialize(channel);
                updateStatement = connection.prepareStatement("UPDATE CHANNEL SET CHANNEL = ? WHERE ID = ?");
                updateStatement.setString(1, migratedData);
                updateStatement.setString(2, id);
                updateStatement.executeUpdate();
                updateStatement.close();
            }
        }
        catch (Exception e) {
            try {
                throw new MigrationException(e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(resultSet);
                DbUtils.closeQuietly((Statement)selectStatement);
                DbUtils.closeQuietly(updateStatement);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)resultSet);
        DbUtils.closeQuietly((Statement)selectStatement);
        DbUtils.closeQuietly(updateStatement);
    }

    @Override
    public void migrateSerializedData() throws MigrationException {
    }
}

