/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.servlets;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.mirth.connect.client.core.Version;
import com.mirth.connect.connectors.file.FileDispatcherProperties;
import com.mirth.connect.connectors.file.FileReceiverProperties;
import com.mirth.connect.connectors.http.HttpDispatcherProperties;
import com.mirth.connect.connectors.jdbc.Column;
import com.mirth.connect.connectors.jdbc.Table;
import com.mirth.connect.connectors.jms.JmsConnectorProperties;
import com.mirth.connect.connectors.smtp.SmtpDispatcherProperties;
import com.mirth.connect.connectors.tcp.TcpDispatcherProperties;
import com.mirth.connect.connectors.vm.VmDispatcherProperties;
import com.mirth.connect.connectors.vm.VmReceiverProperties;
import com.mirth.connect.connectors.ws.DefinitionServiceMap;
import com.mirth.connect.connectors.ws.WebServiceDispatcherProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.model.channel.MetaDataColumnType;
import com.mirth.connect.donkey.model.channel.Ports;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.RawMessage;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.model.ApiProvider;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelDependency;
import com.mirth.connect.model.ChannelGroup;
import com.mirth.connect.model.ChannelHeader;
import com.mirth.connect.model.ChannelMetadata;
import com.mirth.connect.model.ChannelPruningSettings;
import com.mirth.connect.model.ChannelStatistics;
import com.mirth.connect.model.ChannelStatus;
import com.mirth.connect.model.ChannelSummary;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.ConnectorMetaData;
import com.mirth.connect.model.DashboardChannelInfo;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.model.DatabaseTask;
import com.mirth.connect.model.DriverInfo;
import com.mirth.connect.model.EncryptionSettings;
import com.mirth.connect.model.ExtensionLibrary;
import com.mirth.connect.model.Filter;
import com.mirth.connect.model.LicenseInfo;
import com.mirth.connect.model.LoginStatus;
import com.mirth.connect.model.MessageImportResult;
import com.mirth.connect.model.MetaData;
import com.mirth.connect.model.PasswordRequirements;
import com.mirth.connect.model.PluginClass;
import com.mirth.connect.model.PluginMetaData;
import com.mirth.connect.model.PublicServerSettings;
import com.mirth.connect.model.ResourceProperties;
import com.mirth.connect.model.ServerConfiguration;
import com.mirth.connect.model.ServerEvent;
import com.mirth.connect.model.ServerSettings;
import com.mirth.connect.model.SystemInfo;
import com.mirth.connect.model.SystemStats;
import com.mirth.connect.model.Transformer;
import com.mirth.connect.model.UpdateSettings;
import com.mirth.connect.model.User;
import com.mirth.connect.model.alert.AlertActionGroup;
import com.mirth.connect.model.alert.AlertInfo;
import com.mirth.connect.model.alert.AlertModel;
import com.mirth.connect.model.alert.AlertStatus;
import com.mirth.connect.model.alert.DefaultTrigger;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrarySaveResult;
import com.mirth.connect.model.codetemplates.CodeTemplateSummary;
import com.mirth.connect.model.converters.ObjectJSONSerializer;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.datatype.DataTypeProperties;
import com.mirth.connect.model.filters.EventFilter;
import com.mirth.connect.model.filters.MessageFilter;
import com.mirth.connect.model.filters.elements.ContentSearchElement;
import com.mirth.connect.model.filters.elements.MetaDataSearchElement;
import com.mirth.connect.model.purged.PurgedDocument;
import com.mirth.connect.plugins.ServicePlugin;
import com.mirth.connect.plugins.dashboardstatus.ConnectionLogItem;
import com.mirth.connect.plugins.datatypes.raw.RawDataTypeProperties;
import com.mirth.connect.plugins.directoryresource.DirectoryResourceProperties;
import com.mirth.connect.plugins.serverlog.ServerLogItem;
import com.mirth.connect.server.controllers.DefaultExtensionController;
import com.mirth.connect.util.ConfigurationProperty;
import com.mirth.connect.util.ConnectionTestResponse;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SwaggerExamplesServlet
extends HttpServlet {
    private static Calendar dateNow;
    private static Calendar dateTomorrow;
    private static SimpleDateFormat dateFormat;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        dateNow = Calendar.getInstance();
        dateTomorrow = Calendar.getInstance();
        dateTomorrow.add(5, 1);
        dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String exampleRequested = "";
        boolean isExtension = false;
        try {
            exampleRequested = req.getPathInfo().substring(1, req.getPathInfo().lastIndexOf("_"));
            isExtension = exampleRequested.startsWith("ext_");
        }
        catch (Exception e) {
            resp.setContentType("text/plain");
            resp.getWriter().write("No Example Found");
            return;
        }
        Object requestedObject = null;
        if (isExtension) {
            requestedObject = this.getExtensionExample(exampleRequested);
        } else if (exampleRequested.equals("alert")) {
            requestedObject = this.getAlertExample();
        } else if (exampleRequested.equals("alert_info")) {
            requestedObject = this.getAlertInfoExample();
        } else if (exampleRequested.equals("alert_list")) {
            requestedObject = this.getAlertListExample();
        } else if (exampleRequested.equals("alert_protocol_options")) {
            requestedObject = this.getAlertProtocolOptions();
        } else if (exampleRequested.equals("alert_status_list")) {
            requestedObject = this.getAlertStatusListExample();
        } else if (exampleRequested.equals("attachment")) {
            requestedObject = this.getAttachmentExample();
        } else if (exampleRequested.equals("attachment_list")) {
            requestedObject = this.getAttachmentListExample();
        } else if (exampleRequested.equals("boolean")) {
            requestedObject = new Boolean(true);
        } else if (exampleRequested.equals("calendar")) {
            requestedObject = this.getCalendarExample();
        } else if (exampleRequested.equals("channel")) {
            requestedObject = SwaggerExamplesServlet.getChannelExample();
        } else if (exampleRequested.equals("channel_header_map")) {
            requestedObject = this.getChannelHeaderMapExample();
        } else if (exampleRequested.equals("channel_list")) {
            requestedObject = this.getChannelListExample();
        } else if (exampleRequested.equals("channel_dependency_set")) {
            requestedObject = this.getChannelDependencySetExample();
        } else if (exampleRequested.equals("channel_group_list")) {
            requestedObject = this.getChannelGroupListExample();
        } else if (exampleRequested.equals("channel_metadata_map")) {
            requestedObject = this.getChannelMetadataMapExample();
        } else if (exampleRequested.equals("ports_used")) {
            requestedObject = this.getChannelPortsInUseExample();
        } else if (exampleRequested.equals("channel_statistics")) {
            requestedObject = this.getChannelStatisticsExample();
        } else if (exampleRequested.equals("channel_statistics_list")) {
            requestedObject = this.getChannelStatisticsListExample();
        } else if (exampleRequested.equals("channel_tag_set")) {
            requestedObject = this.getChannelTagSetExample();
        } else if (exampleRequested.equals("charset_encoding_list")) {
            requestedObject = this.getCharsetEncodingListExample();
        } else if (exampleRequested.equals("code_template")) {
            requestedObject = SwaggerExamplesServlet.getCodeTemplateExample(true);
        } else if (exampleRequested.equals("code_template_list")) {
            requestedObject = SwaggerExamplesServlet.getCodeTemplateListExample(true);
        } else if (exampleRequested.equals("code_template_library")) {
            requestedObject = SwaggerExamplesServlet.getCodeTemplateLibraryExample(false);
        } else if (exampleRequested.equals("code_template_library_full_templates")) {
            requestedObject = SwaggerExamplesServlet.getCodeTemplateLibraryExample(true);
        } else if (exampleRequested.equals("code_template_library_list")) {
            requestedObject = this.getCodeTemplateLibraryListExample(false);
        } else if (exampleRequested.equals("code_template_library_list_full_templates")) {
            requestedObject = this.getCodeTemplateLibraryListExample(true);
        } else if (exampleRequested.equals("code_template_library_saved_result")) {
            requestedObject = this.getCodeTemplateLibrarySavedResultExample();
        } else if (exampleRequested.equals("code_template_summary_list_revision_changed")) {
            requestedObject = this.getCodeTemplateSummaryListExample(true);
        } else if (exampleRequested.equals("code_template_summary_list")) {
            requestedObject = this.getCodeTemplateSummaryListExample(false);
        } else if (exampleRequested.equals("connector_map")) {
            requestedObject = this.getConnectorMapExample(true);
        } else if (exampleRequested.equals("connector_message")) {
            requestedObject = this.getConnectorMessageExample();
        } else if (exampleRequested.equals("connector_metadata")) {
            requestedObject = this.getConnectorMetaDataExample();
        } else if (exampleRequested.equals("connector_metadata_map")) {
            requestedObject = this.getConnectorMetaDataMapExample();
        } else if (exampleRequested.equals("start_connector_map")) {
            requestedObject = this.getConnectorMapExample(false);
        } else if (exampleRequested.equals("connection_log_item_linked_list")) {
            requestedObject = this.getConnectionLogItemLinkedListExample();
        } else if (exampleRequested.equals("connection_test_response_file")) {
            requestedObject = this.getFileConnectionTestResponseExample();
        } else if (exampleRequested.equals("connection_test_response_http")) {
            requestedObject = this.getHttpConnectionTestResponseExample();
        } else if (exampleRequested.equals("connection_test_response_smtp")) {
            requestedObject = this.getSmtpConnectionTestResponseExample();
        } else if (exampleRequested.equals("connection_test_response_tcp")) {
            requestedObject = this.getTcpConnectionTestResponseExample();
        } else if (exampleRequested.equals("connection_test_response_ws")) {
            requestedObject = this.getWsConnectionTestResponseExample();
        } else if (exampleRequested.equals("connector_name_map")) {
            requestedObject = this.getConnectorNameMapExample();
        } else if (exampleRequested.equals("channel_summary_list")) {
            requestedObject = this.getChannelSummaryListExample();
        } else if (exampleRequested.equals("configuration_map")) {
            requestedObject = this.getConfigurationMapExample();
        } else if (exampleRequested.equals("connection_test_response")) {
            requestedObject = this.getConnectionTestResponseExample();
        } else if (exampleRequested.equals("dashboard_channel_info")) {
            requestedObject = this.getDashboardChannelInfoExample();
        } else if (exampleRequested.equals("dashboard_status")) {
            requestedObject = this.getDashboardStatusExample();
        } else if (exampleRequested.equals("dashboard_status_list")) {
            requestedObject = this.getDashboardStatusListExample();
        } else if (exampleRequested.equals("dashboard_channel_state_map")) {
            requestedObject = this.getDashboardChannelStateMapExample();
        } else if (exampleRequested.equals("dashboard_connector_state_map")) {
            requestedObject = this.getDashboardConnectorStateMapExample();
        } else if (exampleRequested.equals("data_pruner_status_map")) {
            requestedObject = this.getDataPrunerStatusMapExample();
        } else if (exampleRequested.equals("database_task")) {
            requestedObject = this.getDatabaseTaskExample();
        } else if (exampleRequested.equals("database_task_map")) {
            requestedObject = this.getDatabaseTaskMapExample();
        } else if (exampleRequested.equals("debug_options")) {
            requestedObject = this.getDebugOptionsExample();
        } else if (exampleRequested.equals("definition_service_map")) {
            requestedObject = this.getDefinitionServiceMapExample();
        } else if (exampleRequested.equals("driver_info_list")) {
            requestedObject = this.getDriverInfoListExample();
        } else if (exampleRequested.equals("encryption_settings")) {
            requestedObject = this.getEncryptionSettingsExample();
        } else if (exampleRequested.equals("event_filter")) {
            requestedObject = this.getEventFilterExample();
        } else if (exampleRequested.equals("file_dispatcher_properties")) {
            requestedObject = this.getFileDispatcherPropertiesExample();
        } else if (exampleRequested.equals("file_receiver_properties")) {
            requestedObject = this.getFileReceiverPropertiesExample();
        } else if (exampleRequested.equals("generate_envelope")) {
            requestedObject = this.getGenerateEnvelopeExample();
        } else if (exampleRequested.equals("generic_map")) {
            requestedObject = this.getGenericMapExample();
        } else if (exampleRequested.equals("global_maps")) {
            requestedObject = this.getGlobalMapsExample();
        } else if (exampleRequested.equals("global_scripts")) {
            requestedObject = this.getGlobalScriptsExample();
        } else if (exampleRequested.equals("guid_to_int_map")) {
            requestedObject = this.getGuidToIntMapExample();
        } else if (exampleRequested.equals("guid_to_name_map")) {
            requestedObject = this.getGuidToNameMapExample();
        } else if (exampleRequested.equals("guid_set")) {
            requestedObject = this.getGuidSetExample();
        } else if (exampleRequested.equals("http_dispatcher_properties")) {
            requestedObject = this.getHttpDispatcherPropertiesExample();
        } else if (exampleRequested.equals("integer")) {
            requestedObject = new Integer(1);
        } else if (exampleRequested.equals("jms_template_name_set")) {
            requestedObject = this.getJmsTemplateNameSetExample();
        } else if (exampleRequested.equals("jms_connector_properties")) {
            requestedObject = this.getJmsConnectorPropertiesExample();
        } else if (exampleRequested.equals("jms_connector_properties_map")) {
            requestedObject = this.getJmsConnectorPropertiesMapExample();
        } else if (exampleRequested.equals("library_list")) {
            requestedObject = this.getLibraryListExample();
        } else if (exampleRequested.equals("license_info")) {
            requestedObject = this.getLicenseInfoExample();
        } else if (exampleRequested.equals("login_status")) {
            requestedObject = this.getLoginStatusExample();
        } else if (exampleRequested.equals("long")) {
            requestedObject = this.getLongExample();
        } else if (exampleRequested.equals("message")) {
            requestedObject = this.getMessageExample();
        } else if (exampleRequested.equals("message_list")) {
            requestedObject = this.getMessageListExample();
        } else if (exampleRequested.equals("message_filter")) {
            requestedObject = this.getMessageFilterExample();
        } else if (exampleRequested.equals("message_import_result")) {
            requestedObject = this.getMessageImportResultExample();
        } else if (exampleRequested.equals("metadatacolumn_list")) {
            requestedObject = this.getMetaDataColumnListExample();
        } else if (exampleRequested.equals("new_user")) {
            requestedObject = this.getNewUserExample();
        } else if (exampleRequested.equals("null")) {
            requestedObject = null;
        } else if (exampleRequested.equals("password_requirements")) {
            requestedObject = this.getPasswordRequirementsExample();
        } else if (exampleRequested.equals("password_requirement_list")) {
            requestedObject = this.getPasswordRequirementListExample();
        } else if (exampleRequested.equals("plugin_metadata_map")) {
            requestedObject = this.getPluginMetaDataMapExample();
        } else if (exampleRequested.equals("properties")) {
            requestedObject = this.getPropertiesExample();
        } else if (exampleRequested.equals("protocols_and_cipher_suites_map")) {
            requestedObject = this.getProtocolsAndCipherSuitesMapExample();
        } else if (exampleRequested.equals("purged_document")) {
            requestedObject = this.getPurgedDocumentExample();
        } else if (exampleRequested.equals("raw_message")) {
            requestedObject = this.getRawMessageExample();
        } else if (exampleRequested.equals("resource_properties_list")) {
            requestedObject = this.getResourcePropertiesListExample();
        } else if (exampleRequested.equals("server_configuration")) {
            requestedObject = this.getServerConfigurationExample();
        } else if (exampleRequested.equals("server_event")) {
            requestedObject = this.getServerEventExample();
        } else if (exampleRequested.equals("server_event_list")) {
            requestedObject = this.getServerEventListExample();
        } else if (exampleRequested.equals("server_log_item_list")) {
            requestedObject = this.getServerLogItemListExample();
        } else if (exampleRequested.equals("server_settings")) {
            requestedObject = this.getServerSettingsExample();
        } else if (exampleRequested.equals("public_server_settings")) {
            requestedObject = this.getPublicServerSettingsExample();
        } else if (exampleRequested.equals("smtp_dispatcher_properties")) {
            requestedObject = this.getSmtpDispatcherPropertiesExample("none");
        } else if (exampleRequested.equals("smtp_dispatcher_properties_ssl")) {
            requestedObject = this.getSmtpDispatcherPropertiesExample("SSL");
        } else if (exampleRequested.equals("smtp_dispatcher_properties_tls")) {
            requestedObject = this.getSmtpDispatcherPropertiesExample("TLS");
        } else if (exampleRequested.equals("system_info")) {
            requestedObject = this.getSystemInfoExample();
        } else if (exampleRequested.equals("system_stats")) {
            requestedObject = this.getSystemStatsExample();
        } else if (exampleRequested.equals("table_set")) {
            requestedObject = this.getTableSetExample();
        } else if (exampleRequested.equals("tcp_dispatcher_properties")) {
            requestedObject = this.getTcpDispatcherPropertiesExample();
        } else if (exampleRequested.equals("update_settings")) {
            requestedObject = this.getUpdateSettingsExample();
        } else if (exampleRequested.equals("user")) {
            requestedObject = this.getUserExample();
        } else if (exampleRequested.equals("user_list")) {
            requestedObject = this.getUserListExample();
        } else if (exampleRequested.equals("ws_dispatcher_properties")) {
            requestedObject = this.getWsDispatcherPropertiesExample();
        }
        resp.setContentType("application/json");
        if (req.getPathInfo().endsWith("_json")) {
            String serializedObject = SwaggerExamplesServlet.jsonSerialize(requestedObject);
            String returnString = "{\"summary\": \"" + exampleRequested + "\", \"value\": " + serializedObject + "}";
            resp.getWriter().write(returnString);
        } else if (req.getPathInfo().endsWith("_xml")) {
            String serializedObject = SwaggerExamplesServlet.xmlSerialize(requestedObject);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("summary", exampleRequested);
            params.put("value", serializedObject);
            String oasExample = new ObjectMapper().writeValueAsString(params);
            resp.getWriter().write(oasExample);
        } else if (req.getPathInfo().endsWith("_txt")) {
            String serializedObject = (String)requestedObject;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("summary", exampleRequested);
            params.put("value", serializedObject);
            String oasExample = new ObjectMapper().writeValueAsString(params);
            resp.getWriter().write(oasExample);
        }
    }

    public static String jsonSerialize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectJSONSerializer.getInstance().serialize(object, baos);
        return baos.toString("UTF-8");
    }

    public static String xmlSerialize(Object object) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        ObjectXMLSerializer.getInstance().serialize(object, writer);
        return baos.toString("UTF-8");
    }

    private Object getExtensionExample(String exampleRequested) {
        DefaultExtensionController controller = (DefaultExtensionController)DefaultExtensionController.getInstance();
        Collection<ServicePlugin> servicePlugins = controller.getServicePlugins().values();
        for (ServicePlugin plugin : servicePlugins) {
            Object example;
            Map<String, Object> examples = plugin.getObjectsForSwaggerExamples();
            if (examples == null || (example = examples.get(exampleRequested)) == null) continue;
            return example;
        }
        return null;
    }

    private AlertModel getAlertExample() {
        DefaultTrigger trigger = new DefaultTrigger();
        AlertActionGroup group = new AlertActionGroup();
        AlertModel alert = new AlertModel(trigger, group);
        alert.setName("Alert Name");
        return alert;
    }

    private AlertInfo getAlertInfoExample() {
        AlertInfo info = new AlertInfo();
        info.setChangedChannels(this.getChannelSummaryListExample());
        info.setModel(this.getAlertExample());
        info.setProtocolOptions(this.getAlertProtocolOptions());
        return info;
    }

    private Map<String, Map<String, String>> getAlertProtocolOptions() {
        LinkedHashMap<String, Map<String, String>> protocolOptions = new LinkedHashMap<String, Map<String, String>>();
        HashMap<String, String> protocolEntry = new HashMap<String, String>();
        protocolEntry.put(UUID.randomUUID().toString(), "Channel Name");
        protocolOptions.put("Channel", protocolEntry);
        return protocolOptions;
    }

    private List<AlertModel> getAlertListExample() {
        ArrayList<AlertModel> alertList = new ArrayList<AlertModel>();
        alertList.add(this.getAlertExample());
        return alertList;
    }

    private List<AlertStatus> getAlertStatusListExample() {
        AlertStatus status = new AlertStatus();
        status.setId(UUID.randomUUID().toString());
        status.setName("Alert 1");
        ArrayList<AlertStatus> list = new ArrayList<AlertStatus>();
        list.add(status);
        return list;
    }

    private Attachment getAttachmentExample() {
        Attachment attachment = new Attachment("attachmentId", "Example content".getBytes(Charsets.UTF_8), "text/plain");
        attachment.setEncrypted(false);
        return attachment;
    }

    private List<Attachment> getAttachmentListExample() {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        attachments.add(this.getAttachmentExample());
        return attachments;
    }

    private Calendar getCalendarExample() {
        return dateNow;
    }

    private static Connector getSourceConnectorExample() {
        Transformer transformer = new Transformer();
        transformer.setElements(new ArrayList());
        transformer.setInboundTemplate("");
        transformer.setOutboundTemplate("");
        transformer.setInboundDataType("RAW");
        transformer.setOutboundDataType("RAW");
        transformer.setInboundProperties((DataTypeProperties)new RawDataTypeProperties());
        transformer.setOutboundProperties((DataTypeProperties)new RawDataTypeProperties());
        Connector connector = new Connector();
        connector.setProperties((ConnectorProperties)new VmReceiverProperties());
        connector.setName("sourceConnector");
        connector.setTransformer(transformer);
        connector.setFilter(new Filter());
        connector.setTransportName("Channel Reader");
        connector.setMode(Connector.Mode.SOURCE);
        connector.setEnabled(true);
        connector.setWaitForPrevious(true);
        return connector;
    }

    private static Connector getDestinationConnectorExample() {
        Transformer transformer = new Transformer();
        transformer.setElements(new ArrayList());
        transformer.setInboundTemplate("");
        transformer.setOutboundTemplate("");
        transformer.setInboundDataType("RAW");
        transformer.setOutboundDataType("RAW");
        transformer.setInboundProperties((DataTypeProperties)new RawDataTypeProperties());
        transformer.setOutboundProperties((DataTypeProperties)new RawDataTypeProperties());
        Connector connector = new Connector();
        connector.setProperties((ConnectorProperties)new VmDispatcherProperties());
        connector.setName("Destination 1");
        connector.setTransformer(transformer);
        connector.setResponseTransformer(transformer);
        connector.setFilter(new Filter());
        connector.setTransportName("Channel Writer");
        connector.setMode(Connector.Mode.DESTINATION);
        connector.setEnabled(true);
        connector.setWaitForPrevious(true);
        return connector;
    }

    public static Channel getChannelExample() {
        Channel channel = new Channel();
        channel.setId(UUID.randomUUID().toString());
        channel.setName("Channel 1");
        channel.setDescription("Example description.");
        channel.setSourceConnector(SwaggerExamplesServlet.getSourceConnectorExample());
        channel.addDestination(SwaggerExamplesServlet.getDestinationConnectorExample());
        channel.setPreprocessingScript("");
        channel.setPostprocessingScript("");
        channel.setDeployScript("");
        channel.setUndeployScript("");
        return channel;
    }

    private Map<String, ChannelHeader> getChannelHeaderMapExample() {
        HashMap<String, ChannelHeader> channelHeaders = new HashMap<String, ChannelHeader>();
        channelHeaders.put(UUID.randomUUID().toString(), new ChannelHeader(0, dateNow, false));
        return channelHeaders;
    }

    private List<Channel> getChannelListExample() {
        ArrayList<Channel> channelList = new ArrayList<Channel>();
        channelList.add(SwaggerExamplesServlet.getChannelExample());
        return channelList;
    }

    private List<Channel> getMinimalChannelListExample() {
        ArrayList<Channel> channelList = new ArrayList<Channel>();
        channelList.add(this.getMinimalChannelExample());
        return channelList;
    }

    private Channel getMinimalChannelExample() {
        Channel channel = new Channel(UUID.randomUUID().toString());
        return channel;
    }

    private ChannelDependency getChannelDependencyExample() {
        return new ChannelDependency(UUID.randomUUID().toString(), UUID.randomUUID().toString());
    }

    private Set<ChannelDependency> getChannelDependencySetExample() {
        HashSet<ChannelDependency> channelDependencies = new HashSet<ChannelDependency>();
        channelDependencies.add(this.getChannelDependencyExample());
        return channelDependencies;
    }

    private List<ChannelGroup> getChannelGroupListExample() {
        ArrayList<ChannelGroup> groupList = new ArrayList<ChannelGroup>();
        ChannelGroup group = new ChannelGroup("Group Name", "Group Description");
        group.setChannels(this.getMinimalChannelListExample());
        groupList.add(group);
        return groupList;
    }

    private ChannelMetadata getChannelMetadataExample() {
        ChannelPruningSettings pruningSettings = new ChannelPruningSettings();
        pruningSettings.setArchiveEnabled(true);
        pruningSettings.setPruneContentDays(7);
        pruningSettings.setPruneMetaDataDays(14);
        ChannelMetadata channelMetadata = new ChannelMetadata();
        channelMetadata.setEnabled(true);
        channelMetadata.setLastModified(dateNow);
        channelMetadata.setPruningSettings(pruningSettings);
        return channelMetadata;
    }

    private Map<String, ChannelMetadata> getChannelMetadataMapExample() {
        HashMap<String, ChannelMetadata> channelMetadataMap = new HashMap<String, ChannelMetadata>();
        channelMetadataMap.put(UUID.randomUUID().toString(), this.getChannelMetadataExample());
        return channelMetadataMap;
    }

    private List<Ports> getChannelPortsInUseExample() {
        ArrayList<Ports> portsUsed = new ArrayList<Ports>();
        Ports ports1 = new Ports(UUID.randomUUID().toString(), "Default WebClient Port", "8080");
        Ports ports2 = new Ports(UUID.randomUUID().toString(), "Default Administrator Port", "8443");
        portsUsed.add(ports1);
        portsUsed.add(ports2);
        return portsUsed;
    }

    private List<ChannelSummary> getChannelSummaryListExample() {
        ArrayList<ChannelSummary> channelSummaries = new ArrayList<ChannelSummary>();
        ChannelSummary channelSummary = new ChannelSummary(UUID.randomUUID().toString());
        channelSummary.setChannelStatus(this.getChannelStatusExample());
        channelSummaries.add(channelSummary);
        return channelSummaries;
    }

    private ChannelStatistics getChannelStatisticsExample() {
        ChannelStatistics stats = new ChannelStatistics();
        stats.setServerId(UUID.randomUUID().toString());
        stats.setChannelId(UUID.randomUUID().toString());
        return stats;
    }

    private List<ChannelStatistics> getChannelStatisticsListExample() {
        ArrayList<ChannelStatistics> channelStatisticsList = new ArrayList<ChannelStatistics>();
        channelStatisticsList.add(this.getChannelStatisticsExample());
        return channelStatisticsList;
    }

    private ChannelStatus getChannelStatusExample() {
        ChannelStatus channelStatus = new ChannelStatus();
        channelStatus.setLocalChannelId(1L);
        channelStatus.setDeployedRevisionDelta(0);
        channelStatus.setDeployedDate(dateNow);
        return channelStatus;
    }

    private ChannelTag getChannelTagExample() {
        return new ChannelTag(UUID.randomUUID().toString(), "Tag 1", this.getGuidSetExample(), Color.RED);
    }

    private Set<ChannelTag> getChannelTagSetExample() {
        HashSet<ChannelTag> channelTags = new HashSet<ChannelTag>();
        channelTags.add(this.getChannelTagExample());
        return channelTags;
    }

    private List<String> getCharsetEncodingListExample() {
        ArrayList<String> charsetEncodings = new ArrayList<String>();
        charsetEncodings.add("Big5");
        charsetEncodings.add("ISO-8859-1");
        charsetEncodings.add("US-ASCII");
        charsetEncodings.add("UTF-8");
        return charsetEncodings;
    }

    public static CodeTemplate getCodeTemplateExample(boolean includeFullTemplates) {
        if (includeFullTemplates) {
            return CodeTemplate.getDefaultCodeTemplate("Template 1");
        }
        return new CodeTemplate(UUID.randomUUID().toString());
    }

    private static List<CodeTemplate> getCodeTemplateListExample(boolean includeFullTemplates) {
        ArrayList<CodeTemplate> list = new ArrayList<CodeTemplate>();
        list.add(SwaggerExamplesServlet.getCodeTemplateExample(includeFullTemplates));
        return list;
    }

    public static CodeTemplateLibrary getCodeTemplateLibraryExample(boolean includeFullTemplates) {
        CodeTemplateLibrary library = new CodeTemplateLibrary();
        library.setName("Library Name");
        library.setDescription("Library Description");
        library.setRevision(1);
        library.setLastModified(dateNow);
        HashSet<String> disabledChannelIds = new HashSet<String>();
        disabledChannelIds.add(UUID.randomUUID().toString());
        library.setDisabledChannelIds(disabledChannelIds);
        library.setCodeTemplates(SwaggerExamplesServlet.getCodeTemplateListExample(includeFullTemplates));
        return library;
    }

    private List<CodeTemplateLibrary> getCodeTemplateLibraryListExample(boolean includeFullTemplates) {
        ArrayList<CodeTemplateLibrary> list = new ArrayList<CodeTemplateLibrary>();
        list.add(SwaggerExamplesServlet.getCodeTemplateLibraryExample(includeFullTemplates));
        return list;
    }

    private CodeTemplateLibrarySaveResult getCodeTemplateLibrarySavedResultExample() {
        CodeTemplateLibrarySaveResult savedResult = new CodeTemplateLibrarySaveResult();
        savedResult.setOverrideNeeded(true);
        savedResult.setLibrariesSuccess(true);
        CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult templateUpdateResult = new CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult();
        templateUpdateResult.setNewLastModified(dateNow);
        templateUpdateResult.setNewRevision(2);
        templateUpdateResult.setSuccess(true);
        HashMap<String, CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult> codeTemplateResults = new HashMap<String, CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult>();
        codeTemplateResults.put(UUID.randomUUID().toString(), templateUpdateResult);
        savedResult.setCodeTemplateResults(codeTemplateResults);
        CodeTemplateLibrarySaveResult.LibraryUpdateResult libraryUpdateResult = new CodeTemplateLibrarySaveResult.LibraryUpdateResult();
        libraryUpdateResult.setNewLastModified(dateNow);
        libraryUpdateResult.setNewRevision(2);
        HashMap<String, CodeTemplateLibrarySaveResult.LibraryUpdateResult> libraryResults = new HashMap<String, CodeTemplateLibrarySaveResult.LibraryUpdateResult>();
        libraryResults.put(UUID.randomUUID().toString(), libraryUpdateResult);
        savedResult.setLibraryResults(libraryResults);
        return savedResult;
    }

    private CodeTemplateSummary getCodeTemplateSummary() {
        return new CodeTemplateSummary(UUID.randomUUID().toString(), SwaggerExamplesServlet.getCodeTemplateExample(true));
    }

    private List<CodeTemplateSummary> getCodeTemplateSummaryListExample(boolean revisionChanged) {
        ArrayList<CodeTemplateSummary> list = new ArrayList<CodeTemplateSummary>();
        if (revisionChanged) {
            list.add(this.getCodeTemplateSummary());
        }
        return list;
    }

    private Map<String, ConfigurationProperty> getConfigurationMapExample() {
        HashMap<String, ConfigurationProperty> configurationMap = new HashMap<String, ConfigurationProperty>();
        configurationMap.put("exampleKey1", new ConfigurationProperty("exampleValue1", "Example comment 1"));
        configurationMap.put("exampleKey2", new ConfigurationProperty("exampleValue2", "Example comment 2"));
        return configurationMap;
    }

    private Map<String, List<Integer>> getConnectorMapExample(boolean includeNull) {
        HashMap<String, List<Integer>> connectorMap = new HashMap<String, List<Integer>>();
        ArrayList<Integer> connectorList = new ArrayList<Integer>();
        if (includeNull) {
            connectorList.add(null);
        }
        connectorList.add(0);
        connectorList.add(1);
        connectorMap.put(UUID.randomUUID().toString(), connectorList);
        return connectorMap;
    }

    private ConnectionLogItem getConnectionLogItemExample() {
        ConnectionLogItem logItem = new ConnectionLogItem(Long.valueOf(1L), UUID.randomUUID().toString(), UUID.randomUUID().toString(), Long.valueOf(0L), dateFormat.format(dateNow.getTime()), "Channel 1", "Source: Channel Reader (HL7V2 -> JSON)", "Idle", "");
        return logItem;
    }

    private LinkedList<ConnectionLogItem> getConnectionLogItemLinkedListExample() {
        LinkedList<ConnectionLogItem> logItems = new LinkedList<ConnectionLogItem>();
        logItems.add(this.getConnectionLogItemExample());
        return logItems;
    }

    private ConnectionTestResponse getFileConnectionTestResponseExample() {
        return new ConnectionTestResponse(ConnectionTestResponse.Type.SUCCESS, "Successfully connected to: /some_folder");
    }

    private ConnectionTestResponse getHttpConnectionTestResponseExample() {
        return new ConnectionTestResponse(ConnectionTestResponse.Type.SUCCESS, "Successfully connected to host: 0.0.0.0:54551 -> 1.1.1.1:9000", "0.0.0.0:54551 -> 1.1.1.1:9000");
    }

    private ConnectionTestResponse getSmtpConnectionTestResponseExample() {
        return new ConnectionTestResponse(ConnectionTestResponse.Type.SUCCESS, "Sucessfully sent test email to: test@example.com");
    }

    private ConnectionTestResponse getTcpConnectionTestResponseExample() {
        return new ConnectionTestResponse(ConnectionTestResponse.Type.SUCCESS, "Successfully connected to host: 0.0.0.0:53930 -> 1.1.1.1:6661", "0.0.0.0:53930 -> 1.1.1.1:6661");
    }

    private ConnectionTestResponse getWsConnectionTestResponseExample() {
        return new ConnectionTestResponse(ConnectionTestResponse.Type.SUCCESS, "Successfully connected to host: 0.0.0.0:53930 -> 1.1.1.1:8081", "0.0.0.0:53930 -> 1.1.1.1:8081");
    }

    private ConnectorMetaData getConnectorMetaDataExample() {
        ConnectorMetaData metaData = new ConnectorMetaData();
        this.configureMetaData(metaData);
        metaData.setServerClassName("com.example.package.ServerClass");
        metaData.setSharedClassName("com.example.package.SharedClass");
        metaData.setClientClassName("com.example.package.ClientClass");
        metaData.setTransformers("");
        metaData.setProtocol("protocol");
        metaData.setType(ConnectorMetaData.Type.DESTINATION);
        return metaData;
    }

    private void configureMetaData(MetaData metaData) {
        ArrayList<ApiProvider> apiProviders = new ArrayList<ApiProvider>();
        ApiProvider apiProvider = new ApiProvider();
        apiProvider.setType(ApiProvider.Type.SERVLET_INTERFACE);
        apiProvider.setName("com.example.package.ServletInterface");
        apiProviders.add(apiProvider);
        ArrayList<ExtensionLibrary> extensionLibraries = new ArrayList<ExtensionLibrary>();
        ExtensionLibrary extensionLibrary = new ExtensionLibrary();
        extensionLibrary.setPath("client.jar");
        extensionLibrary.setType(ExtensionLibrary.Type.CLIENT);
        extensionLibraries.add(extensionLibrary);
        metaData.setPath("path");
        metaData.setName("Name");
        metaData.setAuthor("Author");
        metaData.setMirthVersion(Version.getLatest().toString());
        metaData.setPluginVersion(Version.getLatest().toString());
        metaData.setUrl("http://exampleurl.com");
        metaData.setDescription("Example description.");
        metaData.setApiProviders(apiProviders);
        metaData.setLibraries(extensionLibraries);
    }

    private ConnectorMessage getConnectorMessageExample() {
        ConnectorMessage connectorMessage = new ConnectorMessage(UUID.randomUUID().toString(), "Channel 1", 1L, 0, UUID.randomUUID().toString(), dateNow, Status.SENT);
        return connectorMessage;
    }

    private Map<String, ConnectorMetaData> getConnectorMetaDataMapExample() {
        HashMap<String, ConnectorMetaData> connectorMetaDataMap = new HashMap<String, ConnectorMetaData>();
        connectorMetaDataMap.put("Name", this.getConnectorMetaDataExample());
        return connectorMetaDataMap;
    }

    private Map<Integer, String> getConnectorNameMapExample() {
        LinkedHashMap<Integer, String> connectorNameMap = new LinkedHashMap<Integer, String>();
        connectorNameMap.put(0, "Source");
        connectorNameMap.put(1, "Destination 1");
        connectorNameMap.put(2, "Destination 2");
        return connectorNameMap;
    }

    private ConnectionTestResponse getConnectionTestResponseExample() {
        return new ConnectionTestResponse(ConnectionTestResponse.Type.SUCCESS, "Success", "Connection info");
    }

    private DashboardChannelInfo getDashboardChannelInfoExample() {
        DashboardChannelInfo dashboardChannelInfo = new DashboardChannelInfo(this.getDashboardStatusListExample(), this.getGuidSetExample(), 0);
        return dashboardChannelInfo;
    }

    private DashboardStatus getDashboardStatusExample() {
        DashboardStatus status = new DashboardStatus();
        LinkedHashMap<Status, Long> statistics = new LinkedHashMap<Status, Long>();
        for (Status s : Status.values()) {
            statistics.put(s, 0L);
        }
        status.setChannelId(UUID.randomUUID().toString());
        status.setDeployedDate(dateNow);
        status.setDeployedRevisionDelta(0);
        status.setLifetimeStatistics(statistics);
        status.setMetaDataId(0);
        status.setName("Channel Name");
        status.setQueueEnabled(false);
        status.setQueued(0L);
        status.setState(DeployedState.STARTED);
        status.setStatistics(statistics);
        status.setStatusType(DashboardStatus.StatusType.CHANNEL);
        status.setWaitForPrevious(false);
        return status;
    }

    private List<DashboardStatus> getDashboardStatusListExample() {
        ArrayList<DashboardStatus> statusList = new ArrayList<DashboardStatus>();
        statusList.add(this.getDashboardStatusExample());
        return statusList;
    }

    private Map<String, String> getDashboardChannelStateMapExample() {
        HashMap<String, String> stateMap = new HashMap<String, String>();
        stateMap.put(UUID.randomUUID().toString(), "Idle");
        return stateMap;
    }

    private Map<String, Object[]> getDashboardConnectorStateMapExample() {
        HashMap<String, Object[]> stateMap = new HashMap<String, Object[]>();
        String channelId = UUID.randomUUID().toString();
        Object[] states = new Object[]{new Color(255, 255, 0, 255), "Idle"};
        stateMap.put(channelId + "_0", states);
        stateMap.put(channelId + "_1", states);
        return stateMap;
    }

    private Map<String, String> getDataPrunerStatusMapExample() {
        HashMap<String, String> statusMap = new HashMap<String, String>();
        statusMap.put("lastProcess", "-");
        statusMap.put("isRunning", "false");
        statusMap.put("currentState", "Not running");
        statusMap.put("nextProcess", "Scheduled Monday, Jan 1, 1:00:00 AM");
        statusMap.put("currentProcess", "-");
        return statusMap;
    }

    private DatabaseTask getDatabaseTaskExample() {
        DatabaseTask task = new DatabaseTask(UUID.randomUUID().toString(), "DB Task 1", "DB Task Description", "DB Task Confirmation Message");
        return task;
    }

    private Map<String, DatabaseTask> getDatabaseTaskMapExample() {
        HashMap<String, DatabaseTask> taskMap = new HashMap<String, DatabaseTask>();
        DatabaseTask task = this.getDatabaseTaskExample();
        taskMap.put(task.getId(), task);
        return taskMap;
    }

    private DebugOptions getDebugOptionsExample() {
        DebugOptions debugOptions = new DebugOptions();
        debugOptions.setAttachmentBatchScripts(false);
        debugOptions.setDeployUndeployPreAndPostProcessorScripts(false);
        debugOptions.setDestinationConnectorScripts(false);
        debugOptions.setDestinationFilterTransformer(false);
        debugOptions.setDestinationResponseTransformer(false);
        debugOptions.setDestinationResponseTransformer(false);
        debugOptions.setSourceConnectorScripts(false);
        debugOptions.setSourceFilterTransformer(false);
        return debugOptions;
    }

    private DefinitionServiceMap getDefinitionServiceMapExample() {
        DefinitionServiceMap definitionMap = new DefinitionServiceMap();
        Map portMap = definitionMap.getMap();
        DefinitionServiceMap.DefinitionPortMap definitionPortMap = new DefinitionServiceMap.DefinitionPortMap();
        Map portInformationMap = definitionPortMap.getMap();
        ArrayList<String> operationList = new ArrayList<String>();
        operationList.add("acceptMessage");
        ArrayList<String> actionList = new ArrayList<String>();
        actionList.add("SomeAction");
        DefinitionServiceMap.PortInformation portInformation = new DefinitionServiceMap.PortInformation(operationList, actionList, "http://example.com:8081/services/SomeService");
        portInformationMap.put("{http://ws.connectors.connect.mirth.com/}DefaultAcceptMessagePort", portInformation);
        portMap.put("{http://ws.connectors.connect.mirth.com/}DefaultAcceptMessageService", definitionPortMap);
        return definitionMap;
    }

    private DriverInfo getDriverInfoExample() {
        DriverInfo driverInfo = new DriverInfo("PostgreSQL", "org.postgresql.Driver", "jdbc:postgresql://host:port/dbname", "SELECT * FROM ? LIMIT 1", new ArrayList<String>());
        return driverInfo;
    }

    private List<DriverInfo> getDriverInfoListExample() {
        ArrayList<DriverInfo> driverInfoList = new ArrayList<DriverInfo>();
        driverInfoList.add(this.getDriverInfoExample());
        return driverInfoList;
    }

    private EncryptionSettings getEncryptionSettingsExample() {
        EncryptionSettings encryptionSettings = new EncryptionSettings();
        encryptionSettings.setEncryptExport(false);
        encryptionSettings.setEncryptProperties(false);
        encryptionSettings.setEncryptionAlgorithm("AES");
        encryptionSettings.setEncryptionKeyLength(128);
        encryptionSettings.setDigestAlgorithm("SHA256");
        encryptionSettings.setSecurityProvider("org.bouncycastle.jce.provider.BouncyCastleProvider");
        encryptionSettings.setSecretKey("exampleSecretKey".getBytes(Charsets.UTF_8));
        return encryptionSettings;
    }

    private EventFilter getEventFilterExample() {
        EventFilter eventFilter = new EventFilter();
        eventFilter.setMaxEventId(2);
        eventFilter.setMinEventId(1);
        eventFilter.setId(1);
        HashSet<ServerEvent.Level> levels = new HashSet<ServerEvent.Level>();
        levels.add(ServerEvent.Level.INFORMATION);
        eventFilter.setLevels(levels);
        eventFilter.setStartDate(dateNow);
        eventFilter.setEndDate(dateTomorrow);
        eventFilter.setOutcome(ServerEvent.Outcome.SUCCESS);
        eventFilter.setUserId(1);
        eventFilter.setIpAddress("0:0:0:0:0:0:0:1");
        eventFilter.setServerId(UUID.randomUUID().toString());
        return eventFilter;
    }

    private FileReceiverProperties getFileReceiverPropertiesExample() {
        FileReceiverProperties receiverProperties = new FileReceiverProperties();
        receiverProperties.setHost("/some_folder");
        return receiverProperties;
    }

    private FileDispatcherProperties getFileDispatcherPropertiesExample() {
        FileDispatcherProperties dispatcherProperties = new FileDispatcherProperties();
        dispatcherProperties.setHost("/some_folder");
        dispatcherProperties.setOutputPattern("some_file.ext");
        return dispatcherProperties;
    }

    private String getGenerateEnvelopeExample() {
        String envelope = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ws=\"http://ws.connectors.connect.mirth.com/\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <ws:acceptMessage/>\n   </soapenv:Body>\n</soapenv:Envelope>";
        return envelope;
    }

    private Map<String, String> getGenericMapExample() {
        HashMap<String, String> genericMap = new HashMap<String, String>();
        genericMap.put("exampleKey", "exampleValue");
        return genericMap;
    }

    private Map<String, Map<String, Map<String, String>>> getGlobalMapsExample() {
        HashMap<String, Map<String, Map<String, String>>> globalMaps = new HashMap<String, Map<String, Map<String, String>>>();
        HashMap<String, Map<String, String>> serverGlobalMap = new HashMap<String, Map<String, String>>();
        serverGlobalMap.put(UUID.randomUUID().toString(), this.getGenericMapExample());
        globalMaps.put(UUID.randomUUID().toString(), serverGlobalMap);
        return globalMaps;
    }

    private Map<String, String> getGlobalScriptsExample() {
        HashMap<String, String> globalScripts = new HashMap<String, String>();
        globalScripts.put("Undeploy", "// Example undeploy script\nreturn;");
        globalScripts.put("Postprocessor", "// Example postprocessor script\nreturn;");
        globalScripts.put("Deploy", "// Example deploy script\nreturn;");
        globalScripts.put("Preprocessor", "// Example preprocessor script\nreturn message;");
        return globalScripts;
    }

    private Set<String> getGuidSetExample() {
        HashSet<String> stringSet = new HashSet<String>();
        stringSet.add(UUID.randomUUID().toString());
        stringSet.add(UUID.randomUUID().toString());
        return stringSet;
    }

    private Map<String, Integer> getGuidToIntMapExample() {
        HashMap<String, Integer> guidToIntMap = new HashMap<String, Integer>();
        guidToIntMap.put(UUID.randomUUID().toString(), 1);
        return guidToIntMap;
    }

    private Map<String, String> getGuidToNameMapExample() {
        HashMap<String, String> guidToNameMap = new HashMap<String, String>();
        guidToNameMap.put(UUID.randomUUID().toString(), "Name 1");
        guidToNameMap.put(UUID.randomUUID().toString(), "Name 2");
        return guidToNameMap;
    }

    private HttpDispatcherProperties getHttpDispatcherPropertiesExample() {
        HttpDispatcherProperties dispatcherProperties = new HttpDispatcherProperties();
        dispatcherProperties.setHost("http://example.com:9000");
        return dispatcherProperties;
    }

    private Set<String> getJmsTemplateNameSetExample() {
        HashSet<String> templateSet = new HashSet<String>();
        templateSet.add("Template 1");
        templateSet.add("Template 2");
        return templateSet;
    }

    private JmsConnectorProperties getJmsConnectorPropertiesExample() {
        JmsConnectorProperties properties = new JmsConnectorProperties();
        properties.setUseJndi(false);
        properties.setConnectionFactoryClass("com.some.connection.FactoryClass");
        properties.getConnectionProperties().put("property1", "value1");
        properties.getConnectionProperties().put("property2", "value2");
        return properties;
    }

    private Map<String, JmsConnectorProperties> getJmsConnectorPropertiesMapExample() {
        LinkedHashMap<String, JmsConnectorProperties> map = new LinkedHashMap<String, JmsConnectorProperties>();
        map.put("Template 1", this.getJmsConnectorPropertiesExample());
        return map;
    }

    private List<String> getLibraryListExample() {
        ArrayList<String> libraryList = new ArrayList<String>();
        libraryList.add("library1.jar");
        libraryList.add("library2.jar");
        return libraryList;
    }

    private LicenseInfo getLicenseInfoExample() {
        HashSet<String> extensions = new HashSet<String>();
        extensions.add("SSL Manager");
        extensions.add("Advanced Clustering");
        LicenseInfo licenseInfo = new LicenseInfo();
        licenseInfo.setActivated(true);
        licenseInfo.setExpirationDate(dateTomorrow.getTimeInMillis());
        licenseInfo.setExtensions(extensions);
        licenseInfo.setGracePeriod(7L);
        return licenseInfo;
    }

    private LoginStatus getLoginStatusExample() {
        LoginStatus loginStatus = new LoginStatus(LoginStatus.Status.SUCCESS, "", "newUserName");
        return loginStatus;
    }

    private Long getLongExample() {
        return 2L;
    }

    private Message getMessageExample() {
        Message message = new Message();
        message.setServerId(UUID.randomUUID().toString());
        message.setChannelId(UUID.randomUUID().toString());
        message.setReceivedDate(dateNow);
        message.setProcessed(true);
        message.getConnectorMessages().put(1, this.getConnectorMessageExample());
        return message;
    }

    private List<Message> getMessageListExample() {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(this.getMessageExample());
        return messages;
    }

    private MessageFilter getMessageFilterExample() {
        ArrayList<ContentSearchElement> contentSearch = new ArrayList<ContentSearchElement>();
        ArrayList<String> searches = new ArrayList<String>();
        searches.add("keyword");
        contentSearch.add(new ContentSearchElement(1, searches));
        ArrayList<Integer> excludedMetaDataIds = new ArrayList<Integer>();
        excludedMetaDataIds.add(2);
        ArrayList<Integer> includedMetaDataIds = new ArrayList<Integer>();
        includedMetaDataIds.add(0);
        includedMetaDataIds.add(1);
        ArrayList<MetaDataSearchElement> metaDataSearch = new ArrayList<MetaDataSearchElement>();
        metaDataSearch.add(new MetaDataSearchElement("Column 1", "operator", "example value", true));
        HashSet<Status> statuses = new HashSet<Status>();
        statuses.add(Status.ERROR);
        MessageFilter messageFilter = new MessageFilter();
        messageFilter.setAttachment(false);
        messageFilter.setContentSearch(contentSearch);
        messageFilter.setEndDate(dateTomorrow);
        messageFilter.setError(false);
        messageFilter.setImportIdLower(1L);
        messageFilter.setIncludedMetaDataIds(includedMetaDataIds);
        messageFilter.setMaxMessageId(200L);
        messageFilter.setMetaDataSearch(metaDataSearch);
        messageFilter.setMinMessageId(5L);
        messageFilter.setOriginalIdUpper(25L);
        messageFilter.setSendAttemptsLower(0);
        messageFilter.setServerId(UUID.randomUUID().toString());
        messageFilter.setStartDate(dateNow);
        messageFilter.setStatuses(statuses);
        messageFilter.setTextSearch("keyword");
        return messageFilter;
    }

    private MessageImportResult getMessageImportResultExample() {
        MessageImportResult result = new MessageImportResult(10, 8);
        return result;
    }

    private List<MetaDataColumn> getMetaDataColumnListExample() {
        ArrayList<MetaDataColumn> metaDataColumns = new ArrayList<MetaDataColumn>();
        metaDataColumns.add(new MetaDataColumn("SOURCE", MetaDataColumnType.STRING, "message_source"));
        metaDataColumns.add(new MetaDataColumn("TYPE", MetaDataColumnType.STRING, "message_type"));
        return metaDataColumns;
    }

    private PasswordRequirements getPasswordRequirementsExample() {
        return new PasswordRequirements(8, 1, 1, 1, 1, 3, 0, 0, 0, 0, 3);
    }

    private List<String> getPasswordRequirementListExample() {
        ArrayList<String> requirements = new ArrayList<String>();
        requirements.add("Password is too short. Minimum length is 8 characters");
        requirements.add("Password must contain 1 special character(s)");
        return requirements;
    }

    private PluginMetaData getPluginMetaDataExample() {
        PluginMetaData metaData = new PluginMetaData();
        this.configureMetaData(metaData);
        ArrayList<PluginClass> serverClasses = new ArrayList<PluginClass>();
        PluginClass serverClass = new PluginClass();
        serverClass.setName("com.example.package.ServerPlugin");
        serverClasses.add(serverClass);
        metaData.setServerClasses(serverClasses);
        ArrayList<PluginClass> clientClasses = new ArrayList<PluginClass>();
        PluginClass clientClass = new PluginClass();
        clientClass.setName("com.example.package.ClientPlugin");
        clientClasses.add(clientClass);
        metaData.setClientClasses(clientClasses);
        return metaData;
    }

    private Map<String, PluginMetaData> getPluginMetaDataMapExample() {
        HashMap<String, PluginMetaData> pluginMetaDataMap = new HashMap<String, PluginMetaData>();
        pluginMetaDataMap.put("Name", this.getPluginMetaDataExample());
        return pluginMetaDataMap;
    }

    private Properties getPropertiesExample() {
        Properties properties = new Properties();
        properties.setProperty("exampleKey1", "exampleValue1");
        properties.setProperty("exampleKey2", "exampleValue2");
        return properties;
    }

    private Map<String, String[]> getProtocolsAndCipherSuitesMapExample() {
        HashMap<String, String[]> protocolsAndCipherSuites = new HashMap<String, String[]>();
        protocolsAndCipherSuites.put("enabledCipherSuites", new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA"});
        protocolsAndCipherSuites.put("enabledClientProtocols", new String[]{"TLSv1.2", "TLSv1.1"});
        protocolsAndCipherSuites.put("supportedCipherSuites", new String[]{"TLS_DHE_DSS_WITH_AES_256_GCM_SHA384"});
        protocolsAndCipherSuites.put("supportedProtocols", new String[]{"SSLv2Hello", "TLSv1.2"});
        protocolsAndCipherSuites.put("enabledServerProtocols", new String[]{"TLSv1.2", "TLSv1.1"});
        return protocolsAndCipherSuites;
    }

    private PurgedDocument getPurgedDocumentExample() {
        PurgedDocument purgedDocument = new PurgedDocument();
        purgedDocument.setServerId(UUID.randomUUID().toString());
        purgedDocument.setMirthVersion(Version.getLatest().toString());
        purgedDocument.setUsers(10);
        return purgedDocument;
    }

    private RawMessage getRawMessageExample() {
        String rawData = "Example raw data.";
        HashSet<Integer> destinationMetaDataIds = new HashSet<Integer>();
        destinationMetaDataIds.add(1);
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        sourceMap.put("exampleKey", "exampleValue");
        List<Attachment> attachments = this.getAttachmentListExample();
        RawMessage rawMessage = new RawMessage(rawData, destinationMetaDataIds, sourceMap, attachments);
        return rawMessage;
    }

    private ResourceProperties getResourcePropertiesExample() {
        DirectoryResourceProperties resourceProperties = new DirectoryResourceProperties();
        resourceProperties.setDescription("Custom directory resources");
        resourceProperties.setDirectory("/path/to/directory");
        resourceProperties.setDirectoryRecursion(true);
        resourceProperties.setId(UUID.randomUUID().toString());
        resourceProperties.setIncludeWithGlobalScripts(false);
        resourceProperties.setName("Custom resources 1");
        return resourceProperties;
    }

    private List<ResourceProperties> getResourcePropertiesListExample() {
        ArrayList<ResourceProperties> resourceProperties = new ArrayList<ResourceProperties>();
        resourceProperties.add(this.getResourcePropertiesExample());
        return resourceProperties;
    }

    private ServerEvent getServerEventExample() {
        ServerEvent serverEvent = new ServerEvent();
        serverEvent.setName("Name 1");
        serverEvent.addAttribute("key", "value");
        serverEvent.setIpAddress("0:0:0:0:0:0:0:1");
        serverEvent.setServerId(UUID.randomUUID().toString());
        return serverEvent;
    }

    private ServerConfiguration getServerConfigurationExample() {
        ServerConfiguration serverConfiguration = new ServerConfiguration();
        serverConfiguration.setAlerts(this.getAlertListExample());
        serverConfiguration.setChannelDependencies(this.getChannelDependencySetExample());
        serverConfiguration.setChannelGroups(this.getChannelGroupListExample());
        serverConfiguration.setChannels(this.getChannelListExample());
        serverConfiguration.setChannelTags(this.getChannelTagSetExample());
        serverConfiguration.setCodeTemplateLibraries(this.getCodeTemplateLibraryListExample(true));
        serverConfiguration.setConfigurationMap(this.getConfigurationMapExample());
        serverConfiguration.setGlobalScripts(this.getGlobalScriptsExample());
        serverConfiguration.setServerSettings(this.getServerSettingsExample());
        serverConfiguration.setUpdateSettings(this.getUpdateSettingsExample());
        serverConfiguration.setUsers(this.getUserListExample());
        return serverConfiguration;
    }

    private List<ServerEvent> getServerEventListExample() {
        ArrayList<ServerEvent> serverEventList = new ArrayList<ServerEvent>();
        serverEventList.add(this.getServerEventExample());
        return serverEventList;
    }

    private ServerLogItem getServerLogItemExample() {
        return new ServerLogItem(UUID.randomUUID().toString(), Long.valueOf(1L), "INFO", dateNow.getTime(), "Main Server Thread", "com.mirth.connect.server.Mirth", "1", "Example message", "Example throwable information");
    }

    private List<ServerLogItem> getServerLogItemListExample() {
        ArrayList<ServerLogItem> serverLogList = new ArrayList<ServerLogItem>();
        serverLogList.add(this.getServerLogItemExample());
        return serverLogList;
    }

    private SmtpDispatcherProperties getSmtpDispatcherPropertiesExample(String encryption) {
        SmtpDispatcherProperties props = new SmtpDispatcherProperties();
        if ("SSL".equalsIgnoreCase(encryption)) {
            props.setSmtpPort("465");
            props.setEncryption("SSL");
            props.setAuthentication(true);
            props.setUsername("username@example.com");
            props.setPassword("your_password");
        } else if ("TLS".equalsIgnoreCase(encryption)) {
            props.setSmtpPort("587");
            props.setEncryption("TLS");
            props.setAuthentication(true);
            props.setUsername("username@example.com");
            props.setPassword("your_password");
        } else {
            props.setSmtpPort("25");
            props.setEncryption("none");
        }
        props.setSmtpHost("smtp.example.com");
        props.setTo("test@example.com");
        props.setFrom("you@test.com");
        return props;
    }

    private ServerSettings getServerSettingsExample() {
        ServerSettings serverSettings = new ServerSettings("Environment 1", "Server 1", this.getPropertiesExample());
        serverSettings.setClearGlobalMap(true);
        serverSettings.setSmtpHost("");
        serverSettings.setSmtpPort("");
        serverSettings.setSmtpTimeout("5000");
        serverSettings.setSmtpFrom("");
        serverSettings.setSmtpUsername("");
        serverSettings.setSmtpPassword("");
        serverSettings.setLoginNotificationEnabled(false);
        serverSettings.setLoginNotificationMessage("");
        return serverSettings;
    }

    private PublicServerSettings getPublicServerSettingsExample() {
        return new PublicServerSettings(this.getServerSettingsExample());
    }

    private SystemInfo getSystemInfoExample() {
        SystemInfo systemInfo = new SystemInfo();
        systemInfo.setJvmVersion("1.8.0_172");
        systemInfo.setOsName("Mac OS X");
        systemInfo.setOsVersion("10.14.5");
        systemInfo.setOsArchitecture("x86_64");
        systemInfo.setDbName("PostgreSQL");
        systemInfo.setDbVersion("9.6.15");
        return systemInfo;
    }

    private SystemStats getSystemStatsExample() {
        SystemStats systemStats = new SystemStats();
        systemStats.setTimestamp(dateNow);
        systemStats.setCpuUsagePct(50.0);
        systemStats.setAllocatedMemoryBytes(300000000L);
        systemStats.setFreeMemoryBytes(200000000L);
        systemStats.setMaxMemoryBytes(500000000L);
        systemStats.setDiskFreeBytes(70000000000L);
        systemStats.setDiskTotalBytes(500000000000L);
        return systemStats;
    }

    private Set<Table> getTableSetExample() {
        TreeSet<Table> tableSet = new TreeSet<Table>();
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column("id", "bpchar", 36));
        columns.add(new Column("name", "varchar", 255));
        tableSet.add(new Table("table_name", columns));
        return tableSet;
    }

    private TcpDispatcherProperties getTcpDispatcherPropertiesExample() {
        TcpDispatcherProperties props = new TcpDispatcherProperties();
        props.setRemoteAddress("example.com");
        props.setRemotePort("6661");
        return props;
    }

    private WebServiceDispatcherProperties getWsDispatcherPropertiesExample() {
        WebServiceDispatcherProperties props = new WebServiceDispatcherProperties();
        props.setWsdlUrl("http://example.com:8081/services/SomeService?wsdl");
        props.setLocationURI("http://example.com:8081/services/SomeService");
        return props;
    }

    private UpdateSettings getUpdateSettingsExample() {
        UpdateSettings updateSettings = new UpdateSettings();
        updateSettings.setLastStatsTime(dateNow.getTimeInMillis());
        updateSettings.setStatsEnabled(true);
        updateSettings.setProperties(this.getPropertiesExample());
        return updateSettings;
    }

    private User getNewUserExample() {
        User user = new User();
        user.setEmail("newuser@email.com");
        user.setFirstName("John");
        user.setLastName("Doe");
        user.setGracePeriodStart(dateNow);
        user.setUsername("newuser");
        user.setDescription("");
        user.setIndustry("");
        user.setCountry("United States");
        user.setStateTerritory("");
        user.setRole("");
        user.setLastLogin(dateNow);
        user.setLastStrikeTime(dateNow);
        user.setOrganization("");
        user.setPhoneNumber("");
        user.setStrikeCount(0);
        return user;
    }

    private User getUserExample() {
        User user = this.getNewUserExample();
        user.setId(1);
        return user;
    }

    private List<User> getUserListExample() {
        ArrayList<User> users = new ArrayList<User>();
        users.add(this.getUserExample());
        return users;
    }
}

