/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.servlets;

import com.mirth.connect.client.core.Version;
import io.swagger.v3.jaxrs2.integration.ServletOpenApiContextBuilder;
import io.swagger.v3.oas.integration.OpenApiConfigurationException;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwaggerServlet
extends HttpServlet {
    private String basePath;
    private Version version;
    private Version apiVersion;
    private Set<String> resourcePackages;
    private Set<Class<?>> resourceClasses;
    private boolean allowHTTP;
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    public SwaggerServlet(String basePath, Version version, Version apiVersion, Set<String> resourcePackages, Set<Class<?>> resourceClasses, boolean allowHTTP) {
        this.basePath = basePath;
        this.version = version;
        this.apiVersion = apiVersion;
        this.resourcePackages = resourcePackages;
        this.resourceClasses = resourceClasses;
        this.allowHTTP = allowHTTP;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        OpenAPI oas = new OpenAPI();
        ArrayList<Server> servers = new ArrayList<Server>();
        servers.add(new Server().url(this.basePath));
        oas.servers(servers);
        Info info = new Info().title("BridgeLink Client API").description("Swagger documentation for the BridgeLink Client API.").version(this.apiVersion.toString());
        oas.info(info);
        SwaggerConfiguration oasConfig = new SwaggerConfiguration().openAPI(oas).resourceClasses(this.resourceClasses.stream().map(Class::getName).collect(Collectors.toSet()));
        try {
            new ServletOpenApiContextBuilder().servletConfig(config).openApiConfiguration((OpenAPIConfiguration)oasConfig).buildContext(true).read();
        }
        catch (OpenApiConfigurationException e) {
            this.logger.error("Failed to initialize Swagger servlet", (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }
}

