/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.sqlmap.extensions;

import com.mirth.connect.model.converters.ObjectXMLSerializer;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public abstract class SerializedObjectTypeHandler<T>
implements TypeHandler<T> {
    private Class<T> clazz;

    protected SerializedObjectTypeHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void setParameter(PreparedStatement statement, int i, T parameter, JdbcType jdbc) throws SQLException {
        if (parameter == null) {
            statement.setNull(i, -1);
        } else {
            statement.setString(i, ObjectXMLSerializer.getInstance().serialize(parameter));
        }
    }

    public T getResult(ResultSet resultSet, String columnName) throws SQLException {
        return ObjectXMLSerializer.getInstance().deserialize(resultSet.getString(columnName), this.clazz);
    }

    public T getResult(ResultSet resultSet, int columnIndex) throws SQLException {
        return ObjectXMLSerializer.getInstance().deserialize(resultSet.getString(columnIndex), this.clazz);
    }

    public T getResult(CallableStatement callableStatement, int columnIndex) throws SQLException {
        String resultString = callableStatement.getString(columnIndex);
        if (resultString != null) {
            return ObjectXMLSerializer.getInstance().deserialize(resultString, this.clazz);
        }
        return null;
    }
}

