/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.tools;

import com.mirth.connect.server.util.DatabaseUtil;
import com.mirth.connect.server.util.ResourceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.derby.tools.ij;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScriptRunner {
    private static Logger logger = LogManager.getLogger((String)"ScriptRunner");

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java ScriptRunner scriptFile");
        } else {
            ScriptRunner.runScript(args[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void runScript(String scriptFile) {
        FileInputStream in;
        Connection connection;
        block12: {
            connection = null;
            in = null;
            try {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
                connection = DriverManager.getConnection("jdbc:derby:mirthdb;create=true");
                in = new FileInputStream(new File(scriptFile));
                NullOutputStream out = new NullOutputStream();
                ij.runScript((Connection)connection, (InputStream)in, (String)"UTF-8", (OutputStream)out, (String)"UTF-8");
                if (connection == null) break block12;
            }
            catch (Exception e) {
                logger.error("error executing script", (Throwable)e);
                return;
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                logger.error("Error closing database connection.", (Throwable)e);
            }
        }
        ResourceUtil.closeResourceQuietly(in);
        return;
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error("Error closing database connection.", (Throwable)e);
                }
            }
            ResourceUtil.closeResourceQuietly(in);
        }
    }

    public static void runScript(File scriptFile) {
        try {
            DatabaseUtil.executeScript(FileUtils.readFileToString((File)scriptFile), false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

