/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.transformers;

import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.server.channel.Channel;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.DestinationConnector;
import com.mirth.connect.donkey.server.channel.FilterTransformerResult;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.channel.components.FilterTransformer;
import com.mirth.connect.donkey.server.channel.components.FilterTransformerException;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.server.MirthJavascriptTransformerException;
import com.mirth.connect.server.MirthScopeProvider;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.transformers.JavaScriptInitializationException;
import com.mirth.connect.server.util.CompiledScriptCache;
import com.mirth.connect.server.util.javascript.JavaScriptExecutorException;
import com.mirth.connect.server.util.javascript.JavaScriptScopeUtil;
import com.mirth.connect.server.util.javascript.JavaScriptTask;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import com.mirth.connect.userutil.ImmutableConnectorMessage;
import com.mirth.connect.util.ErrorMessageBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.MirthMain;

public class JavaScriptFilterTransformer
implements FilterTransformer {
    private Logger logger = LogManager.getLogger(this.getClass());
    private CompiledScriptCache compiledScriptCache = CompiledScriptCache.getInstance();
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private Connector connector;
    private String connectorName;
    private String template;
    private String scriptId;
    private volatile String contextFactoryId;
    private Boolean debug = false;
    private MirthMain debugger;
    private MirthScopeProvider scopeProvider = new MirthScopeProvider();
    private boolean ignoreBreakpoints = false;

    public JavaScriptFilterTransformer(Connector connector, String connectorName, String script, String template, DebugOptions debugOptions) throws JavaScriptInitializationException {
        this.connector = connector;
        this.connectorName = connectorName;
        this.template = template;
        this.initialize(script, debugOptions);
    }

    private void initialize(String script, DebugOptions debugOptions) throws JavaScriptInitializationException {
        Channel channel = this.connector.getChannel();
        ContextType contextType = null;
        this.scriptId = ScriptController.getScriptId("JavaScript_Filter_Transformer_" + this.connector.getMetaDataId(), this.connector.getChannelId());
        if (this.connector instanceof SourceConnector) {
            if (debugOptions != null && debugOptions.isSourceFilterTransformer()) {
                this.debug = true;
            }
            contextType = ContextType.SOURCE_FILTER_TRANSFORMER;
        } else if (this.connector instanceof DestinationConnector) {
            if (debugOptions != null && debugOptions.isDestinationFilterTransformer()) {
                this.debug = true;
            }
            contextType = ContextType.DESTINATION_FILTER_TRANSFORMER;
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)script)) {
                MirthContextFactory contextFactory;
                this.logger.debug("compiling filter/transformer scripts");
                if (this.debug.booleanValue()) {
                    contextFactory = this.getDebugContextFactory();
                    contextFactory.setContextType(contextType);
                    contextFactory.setScriptText(script);
                    contextFactory.setDebugType(true);
                    this.debugger = this.getDebugger(channel, contextFactory);
                } else {
                    contextFactory = this.getContextFactory();
                    contextFactory.setContextType(contextType);
                    contextFactory.setScriptText(script);
                }
                this.contextFactoryId = contextFactory.getId();
                this.compileAndAddScript(script, contextFactory);
            }
        }
        catch (Exception e2) {
            MirthJavascriptTransformerException e2;
            if (e2 instanceof RhinoException) {
                e2 = new MirthJavascriptTransformerException((RhinoException)e2, this.connector.getChannelId(), this.connectorName, 0, "Filter/Transformer", null);
            }
            this.logger.error(ErrorMessageBuilder.buildErrorMessage("Filter/Transformer", null, e2));
            throw new JavaScriptInitializationException("Error initializing JavaScript Filter/Transformer", e2);
        }
    }

    protected MirthContextFactory getDebugContextFactory() throws Exception {
        return this.contextFactoryController.getDebugContextFactory(this.connector.getResourceIds(), this.connector.getChannelId(), this.scriptId);
    }

    protected void compileAndAddScript(String script, MirthContextFactory contextFactory) throws Exception {
        JavaScriptUtil.compileAndAddScript(this.connector.getChannelId(), contextFactory, this.scriptId, script, this.connector instanceof SourceConnector ? ContextType.SOURCE_FILTER_TRANSFORMER : ContextType.DESTINATION_FILTER_TRANSFORMER, null, null);
    }

    protected MirthContextFactory getContextFactory() throws Exception {
        return this.contextFactoryController.getContextFactory(this.connector.getResourceIds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterTransformerResult doFilterTransform(ConnectorMessage message) throws FilterTransformerException, InterruptedException {
        try {
            MirthContextFactory contextFactory;
            MirthContextFactory mirthContextFactory = contextFactory = this.debug != false ? this.getDebugContextFactory() : this.getContextFactory();
            if (!this.contextFactoryId.equals(contextFactory.getId())) {
                JavaScriptFilterTransformer javaScriptFilterTransformer = this;
                synchronized (javaScriptFilterTransformer) {
                    MirthContextFactory mirthContextFactory2 = contextFactory = this.debug != false ? this.getDebugContextFactory() : this.getContextFactory();
                    if (!this.contextFactoryId.equals(contextFactory.getId())) {
                        JavaScriptUtil.recompileGeneratedScript(contextFactory, this.scriptId);
                        this.contextFactoryId = contextFactory.getId();
                    }
                }
            }
            return JavaScriptUtil.execute(new FilterTransformerTask(contextFactory, message));
        }
        catch (JavaScriptExecutorException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FilterTransformerException) {
                throw (FilterTransformerException)cause;
            }
            throw new FilterTransformerException(cause.getMessage(), cause, ErrorMessageBuilder.buildErrorMessage("Filter/Transformer", null, cause));
        }
        catch (Exception e) {
            throw new FilterTransformerException(e.getMessage(), (Throwable)e, ErrorMessageBuilder.buildErrorMessage("Filter/Transformer", null, e));
        }
    }

    public void dispose() {
        this.removeScriptFromCache();
        if (this.debug.booleanValue() && this.debugger != null) {
            this.contextFactoryController.removeDebugContextFactory(this.connector.getResourceIds(), this.connector.getChannelId(), this.scriptId);
            this.debugger.dispose();
            this.debugger = null;
        }
    }

    protected void removeScriptFromCache() {
        JavaScriptUtil.removeScriptFromCache(this.scriptId);
    }

    protected MirthMain getDebugger(Channel channel, MirthContextFactory contextFactory) {
        return JavaScriptUtil.getDebugger(contextFactory, this.scopeProvider, channel, this.scriptId);
    }

    private class FilterTransformerTask
    extends JavaScriptTask<FilterTransformerResult> {
        private ConnectorMessage message;

        public FilterTransformerTask(MirthContextFactory contextFactory, ConnectorMessage message) {
            super(contextFactory, (JavaScriptFilterTransformer.this.connector instanceof SourceConnector ? "Source" : "Destination") + " Filter/Transformer", JavaScriptFilterTransformer.this.connector);
            this.message = message;
        }

        @Override
        public FilterTransformerResult doCall() throws Exception {
            Logger scriptLogger = LogManager.getLogger((String)"filter");
            String[] phase = new String[]{new String()};
            Script compiledScript = JavaScriptFilterTransformer.this.compiledScriptCache.getCompiledScript(JavaScriptFilterTransformer.this.scriptId);
            if (compiledScript == null) {
                JavaScriptFilterTransformer.this.logger.debug("Could not find script " + JavaScriptFilterTransformer.this.scriptId + " in cache.");
                throw new FilterTransformerException("Could not find script " + JavaScriptFilterTransformer.this.scriptId + " in cache.", null, ErrorMessageBuilder.buildErrorMessage("Filter/Transformer", "Could not find script " + JavaScriptFilterTransformer.this.scriptId + " in cache.", null));
            }
            try {
                Scriptable scope = JavaScriptScopeUtil.getFilterTransformerScope(this.getContextFactory(), scriptLogger, new ImmutableConnectorMessage(this.message, true, JavaScriptFilterTransformer.this.connector.getDestinationIdMap()), JavaScriptFilterTransformer.this.template, phase);
                if (JavaScriptFilterTransformer.this.debug.booleanValue()) {
                    JavaScriptFilterTransformer.this.scopeProvider.setScope(scope);
                    if (JavaScriptFilterTransformer.this.debugger != null && !JavaScriptFilterTransformer.this.ignoreBreakpoints) {
                        JavaScriptFilterTransformer.this.debugger.doBreak();
                        if (!JavaScriptFilterTransformer.this.debugger.isVisible()) {
                            JavaScriptFilterTransformer.this.debugger.setVisible(true);
                        }
                    }
                }
                Object result = this.executeScript(compiledScript, scope);
                String transformedData = JavaScriptScopeUtil.getTransformedDataFromScope(scope, StringUtils.isNotBlank((CharSequence)JavaScriptFilterTransformer.this.template));
                FilterTransformerResult filterTransformerResult = new FilterTransformerResult((Boolean)Context.jsToJava((Object)result, Boolean.class) == false, transformedData);
                return filterTransformerResult;
            }
            catch (Throwable t22) {
                MirthJavascriptTransformerException t22;
                if (t22 instanceof RhinoException) {
                    try {
                        String script = CompiledScriptCache.getInstance().getSourceScript(JavaScriptFilterTransformer.this.scriptId);
                        int linenumber = ((RhinoException)t22).lineNumber();
                        String errorReport = JavaScriptUtil.getSourceCode(script, linenumber, 0);
                        t22 = new MirthJavascriptTransformerException((RhinoException)t22, JavaScriptFilterTransformer.this.connector.getChannelId(), JavaScriptFilterTransformer.this.connectorName, 0, phase[0].toUpperCase(), errorReport);
                    }
                    catch (Exception ee) {
                        t22 = new MirthJavascriptTransformerException((RhinoException)t22, JavaScriptFilterTransformer.this.connector.getChannelId(), JavaScriptFilterTransformer.this.connectorName, 0, phase[0].toUpperCase(), null);
                    }
                }
                if (phase[0].equals("filter")) {
                    JavaScriptFilterTransformer.this.eventController.dispatchEvent((Event)new ErrorEvent(this.message.getChannelId(), Integer.valueOf(this.message.getMetaDataId()), Long.valueOf(this.message.getMessageId()), ErrorEventType.FILTER, JavaScriptFilterTransformer.this.connectorName, null, "Error evaluating filter", (Throwable)t22));
                    throw new FilterTransformerException(((Throwable)t22).getMessage(), (Throwable)t22, ErrorMessageBuilder.buildErrorMessage(ErrorEventType.FILTER.toString(), "Error evaluating filter", t22));
                }
                JavaScriptFilterTransformer.this.eventController.dispatchEvent((Event)new ErrorEvent(this.message.getChannelId(), Integer.valueOf(this.message.getMetaDataId()), Long.valueOf(this.message.getMessageId()), ErrorEventType.TRANSFORMER, JavaScriptFilterTransformer.this.connectorName, null, "Error evaluating transformer", (Throwable)t22));
                throw new FilterTransformerException(((Throwable)t22).getMessage(), (Throwable)t22, ErrorMessageBuilder.buildErrorMessage(ErrorEventType.TRANSFORMER.toString(), "Error evaluating transformer", t22));
            }
            finally {
                Context.exit();
            }
        }
    }
}

