/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.server.transformers;

import com.mirth.connect.donkey.model.channel.DebugOptions;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.event.Event;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.components.ResponseTransformer;
import com.mirth.connect.donkey.server.channel.components.ResponseTransformerException;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.server.MirthJavascriptTransformerException;
import com.mirth.connect.server.MirthScopeProvider;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.EventController;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.transformers.JavaScriptInitializationException;
import com.mirth.connect.server.util.CompiledScriptCache;
import com.mirth.connect.server.util.javascript.JavaScriptExecutorException;
import com.mirth.connect.server.util.javascript.JavaScriptScopeUtil;
import com.mirth.connect.server.util.javascript.JavaScriptTask;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.server.util.javascript.MirthContextFactory;
import com.mirth.connect.userutil.ImmutableConnectorMessage;
import com.mirth.connect.userutil.Response;
import com.mirth.connect.util.ErrorMessageBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.MirthMain;

public class JavaScriptResponseTransformer
implements ResponseTransformer {
    private Logger logger = LogManager.getLogger(this.getClass());
    private CompiledScriptCache compiledScriptCache = CompiledScriptCache.getInstance();
    private EventController eventController = ControllerFactory.getFactory().createEventController();
    private ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private Connector connector;
    private String connectorName;
    private String scriptId;
    private String template;
    private String script;
    private boolean debug = false;
    private MirthMain debugger;
    private MirthScopeProvider scopeProvider = new MirthScopeProvider();
    private DebugOptions debugOptions;
    private volatile String contextFactoryId;

    public JavaScriptResponseTransformer(Connector connector, String connectorName, String script, String template, DebugOptions debugOptions) throws JavaScriptInitializationException {
        this.connector = connector;
        this.connectorName = connectorName;
        this.template = template;
        this.debugOptions = debugOptions;
        this.script = script;
        this.initialize(script);
    }

    private void initialize(String script) throws JavaScriptInitializationException {
        try {
            if (StringUtils.isNotBlank((CharSequence)script)) {
                this.scriptId = ScriptController.getScriptId("Response_Transformer_" + this.connector.getMetaDataId(), this.connector.getChannel().getChannelId());
                MirthContextFactory contextFactory = this.getContextFactory();
                contextFactory.setContextType(ContextType.DESTINATION_RESPONSE_TRANSFORMER);
                contextFactory.setScriptText(script);
                if (this.debugOptions != null && this.debugOptions.isDestinationResponseTransformer()) {
                    this.debug = true;
                    contextFactory.setDebugType(true);
                    this.debugger = this.getDebugger(contextFactory);
                }
                this.contextFactoryId = contextFactory.getId();
                this.compileAndAddScript(contextFactory);
            }
        }
        catch (Exception e2) {
            MirthJavascriptTransformerException e2;
            if (e2 instanceof RhinoException) {
                e2 = new MirthJavascriptTransformerException((RhinoException)e2, this.connector.getChannelId(), this.connectorName, 0, "response", null);
            }
            this.logger.error(ErrorMessageBuilder.buildErrorMessage(ErrorEventType.RESPONSE_TRANSFORMER.toString(), null, e2));
            throw new JavaScriptInitializationException("Error initializing JavaScript response transformer", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doTransform(com.mirth.connect.donkey.model.message.Response response, ConnectorMessage connectorMessage) throws ResponseTransformerException, InterruptedException {
        try {
            MirthContextFactory contextFactory = this.getContextFactory();
            if (!this.contextFactoryId.equals(contextFactory.getId())) {
                JavaScriptResponseTransformer javaScriptResponseTransformer = this;
                synchronized (javaScriptResponseTransformer) {
                    contextFactory = this.getContextFactory();
                    if (!this.contextFactoryId.equals(contextFactory.getId())) {
                        JavaScriptUtil.recompileGeneratedScript(contextFactory, this.scriptId);
                        this.contextFactoryId = contextFactory.getId();
                    }
                }
            }
            return this.execute(contextFactory, response, connectorMessage);
        }
        catch (JavaScriptExecutorException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ResponseTransformerException) {
                throw (ResponseTransformerException)cause;
            }
            throw new ResponseTransformerException(cause.getMessage(), cause, ErrorMessageBuilder.buildErrorMessage(ErrorEventType.RESPONSE_TRANSFORMER.toString(), null, cause));
        }
        catch (Exception e) {
            throw new ResponseTransformerException(e.getMessage(), (Throwable)e, ErrorMessageBuilder.buildErrorMessage("Filter/Transformer", null, e));
        }
    }

    protected MirthMain getDebugger(MirthContextFactory contextFactory) {
        return JavaScriptUtil.getDebugger(contextFactory, this.scopeProvider, this.connector.getChannel(), this.scriptId);
    }

    protected String execute(MirthContextFactory contextFactory, com.mirth.connect.donkey.model.message.Response response, ConnectorMessage connectorMessage) throws JavaScriptExecutorException, InterruptedException {
        return JavaScriptUtil.execute(new ResponseTransformerTask(contextFactory, response, connectorMessage, this.scriptId, this.template, this.debugOptions));
    }

    protected void compileAndAddScript(MirthContextFactory contextFactory) throws Exception {
        JavaScriptUtil.compileAndAddScript(this.connector.getChannelId(), contextFactory, this.scriptId, this.script, ContextType.DESTINATION_RESPONSE_TRANSFORMER, null, null);
    }

    protected MirthContextFactory getContextFactory() throws Exception {
        if (this.debugOptions != null && this.debugOptions.isDestinationResponseTransformer()) {
            return this.contextFactoryController.getDebugContextFactory(this.connector.getChannel().getResourceIds(), this.connector.getChannel().getChannelId(), this.scriptId);
        }
        return this.contextFactoryController.getContextFactory(this.connector.getChannel().getResourceIds());
    }

    public void dispose() {
        JavaScriptUtil.removeScriptFromCache(this.scriptId);
        if (this.debug && this.debugger != null) {
            this.contextFactoryController.removeDebugContextFactory(this.connector.getResourceIds(), this.connector.getChannelId(), this.scriptId);
            this.debugger.dispose();
            this.debugger = null;
        }
    }

    private class ResponseTransformerTask
    extends JavaScriptTask<String> {
        private com.mirth.connect.donkey.model.message.Response response;
        private ConnectorMessage connectorMessage;
        private String scriptId;
        private String template;
        private DebugOptions debugOptions;

        public ResponseTransformerTask(MirthContextFactory contextFactory, com.mirth.connect.donkey.model.message.Response response, ConnectorMessage connectorMessage, String scriptId, String template, DebugOptions debugOptions) {
            super(contextFactory, "Response Transformer", JavaScriptResponseTransformer.this.connector);
            this.response = response;
            this.connectorMessage = connectorMessage;
            this.scriptId = scriptId;
            this.template = template;
            this.debugOptions = debugOptions;
        }

        @Override
        public String doCall() throws Exception {
            Logger scriptLogger = LogManager.getLogger((String)"response");
            Script compiledScript = JavaScriptResponseTransformer.this.compiledScriptCache.getCompiledScript(this.scriptId);
            if (compiledScript == null) {
                JavaScriptResponseTransformer.this.logger.debug("Could not find script " + this.scriptId + " in cache.");
                throw new ResponseTransformerException("Could not find script " + this.scriptId + " in cache.", null, ErrorMessageBuilder.buildErrorMessage(ErrorEventType.RESPONSE_TRANSFORMER.toString(), "Could not find script " + this.scriptId + " in cache.", null));
            }
            try {
                Response userResponse = new Response(this.response);
                Scriptable scope = JavaScriptScopeUtil.getResponseTransformerScope(this.getContextFactory(), scriptLogger, userResponse, new ImmutableConnectorMessage(this.connectorMessage, true, JavaScriptResponseTransformer.this.connector.getDestinationIdMap()), this.template);
                if (this.debugOptions != null && this.debugOptions.isDestinationResponseTransformer()) {
                    JavaScriptResponseTransformer.this.scopeProvider.setScope(scope);
                    if (JavaScriptResponseTransformer.this.debugger != null) {
                        JavaScriptResponseTransformer.this.debugger.enableDebugging();
                        JavaScriptResponseTransformer.this.debugger.doBreak();
                        if (!JavaScriptResponseTransformer.this.debugger.isVisible()) {
                            JavaScriptResponseTransformer.this.debugger.setVisible(true);
                        }
                    }
                }
                this.executeScript(compiledScript, scope);
                JavaScriptScopeUtil.getResponseDataFromScope(scope, userResponse);
                String string = JavaScriptScopeUtil.getTransformedDataFromScope(scope, StringUtils.isNotBlank((CharSequence)this.template));
                return string;
            }
            catch (Throwable t22) {
                MirthJavascriptTransformerException t22;
                if (t22 instanceof RhinoException) {
                    try {
                        String script = CompiledScriptCache.getInstance().getSourceScript(this.scriptId);
                        int linenumber = ((RhinoException)t22).lineNumber();
                        String errorReport = JavaScriptUtil.getSourceCode(script, linenumber, 0);
                        t22 = new MirthJavascriptTransformerException((RhinoException)t22, JavaScriptResponseTransformer.this.connector.getChannelId(), JavaScriptResponseTransformer.this.connectorName, 0, "response", errorReport);
                    }
                    catch (Exception ee) {
                        t22 = new MirthJavascriptTransformerException((RhinoException)t22, JavaScriptResponseTransformer.this.connector.getChannelId(), JavaScriptResponseTransformer.this.connectorName, 0, "response", null);
                    }
                }
                JavaScriptResponseTransformer.this.eventController.dispatchEvent((Event)new ErrorEvent(this.connectorMessage.getChannelId(), Integer.valueOf(this.connectorMessage.getMetaDataId()), Long.valueOf(this.connectorMessage.getMessageId()), ErrorEventType.RESPONSE_TRANSFORMER, JavaScriptResponseTransformer.this.connectorName, null, "Error evaluating response transformer", (Throwable)t22));
                throw new ResponseTransformerException(((Throwable)t22).getMessage(), (Throwable)t22, ErrorMessageBuilder.buildErrorMessage(ErrorEventType.RESPONSE_TRANSFORMER.toString(), "Error evaluating response transformer", t22));
            }
            finally {
                Context.exit();
            }
        }
    }
}

